/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.source;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class FileSourceNode
implements SourceNode {
    protected File file;

    public FileSourceNode(File file) {
        this.file = file;
    }

    public FileSourceNode(String path) {
        this.file = new File(path);
    }

    @Override
    public BlobHolder getBlobHolder() {
        return new SimpleBlobHolder((Blob)new FileBlob(this.file));
    }

    @Override
    public List<SourceNode> getChildren() {
        ArrayList<SourceNode> children = new ArrayList<SourceNode>();
        for (File child : this.file.listFiles()) {
            children.add(new FileSourceNode(child));
        }
        return children;
    }

    @Override
    public boolean isFolderish() {
        return this.file.isDirectory();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getSourcePath() {
        return this.file.getAbsolutePath();
    }

    public File getFile() {
        return this.file;
    }
}

