/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.wiki;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.rendering.wiki.TocMacro;
import org.nuxeo.ecm.platform.rendering.wiki.WikiExpression;
import org.nuxeo.ecm.platform.rendering.wiki.WikiFilter;
import org.nuxeo.ecm.platform.rendering.wiki.WikiMacro;
import org.nuxeo.ecm.platform.rendering.wiki.WikiSerializerHandler;
import org.wikimodel.wem.IWemListener;
import org.wikimodel.wem.WikiParserException;
import org.wikimodel.wem.common.CommonWikiParser;

public class WikiSerializer {
    public static final Log log = LogFactory.getLog(WikiSerializer.class);
    protected final CommonWikiParser parser;
    protected final Map<String, WikiMacro> macros = new HashMap<String, WikiMacro>();
    protected final Map<String, WikiExpression> expressions = new HashMap<String, WikiExpression>();
    protected final List<WikiFilter> filters = new ArrayList<WikiFilter>();

    public WikiSerializer() {
        this.parser = new CommonWikiParser();
        this.registerMacro(new TocMacro());
    }

    public void registerMacro(WikiMacro macro) {
        this.macros.put(macro.getName(), macro);
    }

    public void registerExpression(WikiExpression expression) {
        this.expressions.put(expression.getName(), expression);
    }

    public void addFilter(WikiFilter filter) {
        this.filters.add(filter);
    }

    public void serialize(Reader reader, Writer writer) throws IOException, WikiParserException {
        WikiSerializerHandler serializer = new WikiSerializerHandler(this);
        this.parser.parse(reader, (IWemListener)serializer);
        serializer.getWriter().writeTo(serializer, writer);
        writer.flush();
    }
}

