/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.api;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.comment.CommentProcessorHelper;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PredicateDefinition;
import org.nuxeo.ecm.platform.query.api.PredicateFieldDefinition;
import org.nuxeo.runtime.api.Framework;

public class AuditPageProvider
extends AbstractPageProvider<LogEntry>
implements PageProvider<LogEntry> {
    private static final long serialVersionUID = 1L;
    protected String auditQuery;
    protected Map<String, Object> auditQueryParams;
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String UICOMMENTS_PROPERTY = "generateUIComments";

    public String toString() {
        this.buildAuditQuery(true);
        StringBuffer sb = new StringBuffer();
        sb.append("\nquery : " + this.auditQuery);
        sb.append("\nparams : ");
        ArrayList<String> pNames = new ArrayList<String>(this.auditQueryParams.keySet());
        Collections.sort(pNames);
        for (String name : pNames) {
            sb.append("\n ");
            sb.append(name);
            sb.append(" : ");
            sb.append(this.auditQueryParams.get(name).toString());
        }
        return sb.toString();
    }

    protected void preprocessCommentsIfNeeded(List<LogEntry> entries) {
        Serializable preprocess = (Serializable)this.getProperties().get(UICOMMENTS_PROPERTY);
        CoreSession session = (CoreSession)this.getProperties().get(CORE_SESSION_PROPERTY);
        if (session != null && preprocess != null && "true".equalsIgnoreCase(preprocess.toString())) {
            CommentProcessorHelper cph = new CommentProcessorHelper(session);
            cph.processComments(entries);
        }
    }

    public List<LogEntry> getCurrentPage() {
        AuditReader reader;
        try {
            reader = (AuditReader)Framework.getService(AuditReader.class);
        }
        catch (Exception e) {
            return null;
        }
        this.buildAuditQuery(true);
        List<LogEntry> entries = reader.nativeQuery(this.auditQuery, this.auditQueryParams, (int)this.getCurrentPageIndex() + 1, (int)this.getMinMaxPageSize());
        this.preprocessCommentsIfNeeded(entries);
        return entries;
    }

    protected String getSortPart() {
        StringBuffer sort = new StringBuffer();
        if (this.getSortInfos() != null && this.getSortInfos().size() > 0) {
            sort.append(" ORDER BY ");
        }
        int index = 0;
        for (SortInfo si : this.getSortInfos()) {
            if (index > 0) {
                sort.append(" , ");
            }
            sort.append(si.getSortColumn());
            if (si.getSortAscending()) {
                sort.append(" ASC ");
            } else {
                sort.append(" DESC ");
            }
            ++index;
        }
        return sort.toString();
    }

    protected Object convertParam(Object param) {
        if (param == null) {
            return null;
        }
        if (param instanceof Calendar) {
            return new Timestamp(((Calendar)param).getTime().getTime());
        }
        return param;
    }

    protected boolean isNonNullParam(Object[] val) {
        if (val == null) {
            return false;
        }
        for (Object v : val) {
            if (v == null) continue;
            if (v instanceof String) {
                if (((String)v).isEmpty()) continue;
                return true;
            }
            if (v instanceof String[]) {
                if (((String[])v).length <= 0) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    protected String getFixedPart() {
        if (this.getDefinition().getWhereClause() == null) {
            return null;
        }
        return this.getDefinition().getWhereClause().getFixedPart();
    }

    protected boolean allowSimplePattern() {
        return true;
    }

    protected void buildAuditQuery(boolean includeSort) {
        PageProviderDefinition def = this.getDefinition();
        Object[] params = this.getParameters();
        if (def.getWhereClause() == null) {
            if (!this.allowSimplePattern()) {
                throw new UnsupportedOperationException("This page provider requires a explicit Where Clause");
            }
            String baseQuery = def.getPattern();
            HashMap<String, Object> qParams = new HashMap<String, Object>();
            for (int i = 0; i < params.length; ++i) {
                baseQuery = baseQuery.replaceFirst("\\?", ":param" + i);
                qParams.put("param" + i, this.convertParam(params[i]));
            }
            if (includeSort) {
                baseQuery = baseQuery + this.getSortPart();
            }
            this.auditQuery = baseQuery;
            this.auditQueryParams = qParams;
        } else {
            DocumentModel searchDocumentModel;
            StringBuilder baseQuery = new StringBuilder("from LogEntry log ");
            String fixedPart = this.getFixedPart();
            HashMap<String, Object> qParams = new HashMap<String, Object>();
            int idxParam = 0;
            if (fixedPart != null && !fixedPart.isEmpty()) {
                while (fixedPart.indexOf("?") > 0) {
                    fixedPart = fixedPart.replaceFirst("\\?", ":param" + idxParam);
                    qParams.put("param" + idxParam, this.convertParam(params[idxParam]));
                    ++idxParam;
                }
                baseQuery.append(" where ");
                baseQuery.append(fixedPart);
            }
            if ((searchDocumentModel = this.getSearchDocumentModel()) != null) {
                PredicateDefinition[] predicates = def.getWhereClause().getPredicates();
                int idxPredicate = 0;
                for (PredicateDefinition predicate : predicates) {
                    Object[] val;
                    try {
                        PredicateFieldDefinition[] fieldDef = predicate.getValues();
                        val = new Object[fieldDef.length];
                        for (int fidx = 0; fidx < fieldDef.length; ++fidx) {
                            val[fidx] = fieldDef[fidx].getXpath() != null ? searchDocumentModel.getPropertyValue(fieldDef[fidx].getXpath()) : searchDocumentModel.getProperty(fieldDef[fidx].getSchema(), fieldDef[fidx].getName());
                        }
                    }
                    catch (Exception e) {
                        throw new ClientRuntimeException((Throwable)e);
                    }
                    if (!this.isNonNullParam(val)) continue;
                    if (idxPredicate > 0 || idxParam > 0) {
                        baseQuery.append(" AND ");
                    } else {
                        baseQuery.append(" where ");
                    }
                    baseQuery.append(predicate.getParameter());
                    baseQuery.append(" ");
                    if (!predicate.getOperator().equalsIgnoreCase("BETWEEN")) {
                        baseQuery.append(predicate.getOperator());
                    }
                    if (predicate.getOperator().equalsIgnoreCase("IN")) {
                        Object v;
                        baseQuery.append(" (");
                        if (val[0] instanceof Iterable) {
                            Iterable vals = (Iterable)val[0];
                            Iterator valueIterator = vals.iterator();
                            while (valueIterator.hasNext()) {
                                v = valueIterator.next();
                                qParams.put("param" + idxParam, this.convertParam(v));
                                baseQuery.append(" :param" + idxParam);
                                ++idxParam;
                                if (!valueIterator.hasNext()) continue;
                                baseQuery.append(",");
                            }
                        } else if (val[0] instanceof Object[]) {
                            Object[] valArray = (Object[])val[0];
                            for (int i = 0; i < valArray.length; ++i) {
                                v = valArray[i];
                                qParams.put("param" + idxParam, this.convertParam(v));
                                baseQuery.append(" :param" + idxParam);
                                ++idxParam;
                                if (i >= valArray.length - 1) continue;
                                baseQuery.append(",");
                            }
                        }
                        baseQuery.append(" ) ");
                    } else if (predicate.getOperator().equalsIgnoreCase("BETWEEN")) {
                        Object startValue = this.convertParam(val[0]);
                        Object endValue = null;
                        if (val.length > 1) {
                            endValue = this.convertParam(val[1]);
                        }
                        if (startValue != null && endValue != null) {
                            baseQuery.append(predicate.getOperator());
                            baseQuery.append(" :param" + idxParam);
                            qParams.put("param" + idxParam, startValue);
                            baseQuery.append(" AND :param" + ++idxParam);
                            qParams.put("param" + idxParam, endValue);
                        } else if (startValue == null) {
                            baseQuery.append("<=");
                            baseQuery.append(" :param" + idxParam);
                            qParams.put("param" + idxParam, endValue);
                        } else if (endValue == null) {
                            baseQuery.append(">=");
                            baseQuery.append(" :param" + idxParam);
                            qParams.put("param" + idxParam, startValue);
                        }
                        ++idxParam;
                    } else {
                        baseQuery.append(" :param" + idxParam);
                        qParams.put("param" + idxParam, this.convertParam(val[0]));
                        ++idxParam;
                    }
                    ++idxPredicate;
                }
            }
            if (includeSort) {
                baseQuery.append(this.getSortPart());
            }
            this.auditQuery = baseQuery.toString();
            this.auditQueryParams = qParams;
        }
    }

    public void refresh() {
        super.refresh();
        this.setCurrentPageOffset(0L);
    }

    public long getResultsCount() {
        AuditReader reader;
        this.buildAuditQuery(false);
        try {
            reader = (AuditReader)Framework.getService(AuditReader.class);
        }
        catch (Exception e) {
            return 0L;
        }
        List<?> res = reader.nativeQuery("select count(log.id) " + this.auditQuery, this.auditQueryParams, 1, 20);
        this.resultsCount = (Long)res.get(0);
        return this.resultsCount;
    }
}

