/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.web;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskImpl;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="routingTaskActions")
public class RoutingTaskActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RoutingTaskActionsBean.class);
    public static final String SUBJECT_PATTERN = "([a-zA-Z_0-9]*(:)[a-zA-Z_0-9]*)";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(required=true, create=true)
    protected NavigationContext navigationContext;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    protected Task currentTask;
    protected Map<String, Serializable> formVariables;
    @RequestParameter(value="button")
    protected String button;

    public void validateTaskDueDate(FacesContext context, UIComponent component, Object value) {
        String DATE_FORMAT = "dd/MM/yyyy";
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        String messageString = null;
        if (value != null) {
            Date today = null;
            Date dueDate = null;
            try {
                dueDate = dateFormat.parse(dateFormat.format((Date)value));
                today = dateFormat.parse(dateFormat.format(new Date()));
            }
            catch (ParseException e) {
                messageString = "label.workflow.error.date_parsing";
            }
            if (dueDate.before(today)) {
                messageString = "label.workflow.error.outdated_duedate";
            }
        }
        if (messageString != null) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.workflow.error.outdated_duedate"), null);
            ((EditableValueHolder)component).setValid(false);
            context.addMessage(component.getClientId(context), message);
        }
    }

    public void validateSubject(FacesContext context, UIComponent component, Object value) {
        if (!(value instanceof String) || !((String)value).matches(SUBJECT_PATTERN)) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.document.routing.invalid.subject"), null);
            context.addMessage(null, message);
            throw new ValidatorException(message);
        }
    }

    public String getTaskLayout(Task task) throws ClientException {
        return this.getTaskInfo((Task)task, (boolean)false).layout;
    }

    public List<GraphNode.Button> getTaskButtons(Task task) throws ClientException {
        return this.getTaskInfo((Task)task, (boolean)false).buttons;
    }

    public String endTask(Task task) throws ClientException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (this.formVariables != null) {
            data.put("WorkflowVariables", this.formVariables);
            data.put("NodeVariables", this.formVariables);
            if (this.formVariables.containsKey("comment")) {
                data.put("comment", this.formVariables.get("comment"));
            }
        }
        try {
            DocumentRoutingService routing = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
            routing.endTask(this.documentManager, task, data, this.button);
            this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("workflow.feedback.info.taskEnded"), new Object[0]);
        }
        catch (DocumentRouteException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e, (Throwable)e);
            }
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("workflow.feedback.error.taskEnded"), new Object[0]);
        }
        Events.instance().raiseEvent("workflowTaskCompleted", new Object[0]);
        this.clear();
        return null;
    }

    private void clear() {
        this.currentTask = null;
        this.formVariables = null;
        this.button = null;
    }

    public Task setCurrentTask(String taskDocId) throws ClientException {
        TaskImpl task = new TaskImpl(this.documentManager.getDocument((DocumentRef)new IdRef(taskDocId)));
        return this.setCurrentTask((Task)task);
    }

    public Task setCurrentTask(Task task) throws ClientException {
        this.currentTask = task;
        this.formVariables = null;
        this.button = null;
        return this.currentTask;
    }

    public Map<String, Serializable> getFormVariables(Task task) throws ClientException {
        return this.getTaskInfo((Task)task, (boolean)true).formVariables;
    }

    protected TaskInfo getTaskInfo(Task task, final boolean getFormVariables) throws ClientException {
        final String routeDocId = task.getVariable("routeInstanceDocId");
        final String nodeId = task.getVariable("nodeId");
        if (routeDocId == null) {
            throw new ClientException("Can not get the source graph for this task");
        }
        if (nodeId == null) {
            throw new ClientException("Can not get the source node for this task");
        }
        final TaskInfo[] res = new TaskInfo[1];
        new UnrestrictedSessionRunner(this.documentManager){

            public void run() throws ClientException {
                DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(routeDocId));
                GraphRoute route = (GraphRoute)doc.getAdapter(GraphRoute.class);
                GraphNode node = route.getNode(nodeId);
                HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                if (getFormVariables) {
                    map.putAll(node.getVariables());
                    map.putAll(route.getVariables());
                }
                res[0] = new TaskInfo(map, node.getTaskLayout(), node.getTaskButtons());
            }
        }.runUnrestricted();
        return res[0];
    }

    public Map<String, Serializable> getFormVariables() throws ClientException {
        if (this.formVariables == null) {
            if (this.currentTask == null) {
                throw new ClientException("No current task defined");
            }
            this.formVariables = this.getFormVariables(this.currentTask);
        }
        return this.formVariables;
    }

    public void setFormVariables(Map<String, Serializable> formVariables) {
        this.formVariables = formVariables;
    }

    public boolean isRoutingTask(Task task) {
        return task.getDocument().hasFacet("RoutingTask");
    }

    public List<Action> getTaskActions(Task task) throws ClientException {
        return new ArrayList<Action>(this.getTaskActionsMap(task).values());
    }

    protected boolean isLayoutEmpty(String layoutName) {
        if (layoutName == null || layoutName.isEmpty()) {
            return true;
        }
        try {
            WebLayoutManager lm = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
            LayoutDefinition layout = lm.getLayoutDefinition(layoutName);
            if (layout == null || layout.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return true;
        }
        return false;
    }

    public Map<String, Action> getTaskActionsMap(Task task) throws ClientException {
        LinkedHashMap<String, Action> actions = new LinkedHashMap<String, Action>();
        TaskInfo taskInfo = this.getTaskInfo(task, true);
        String layout = taskInfo.layout;
        List<GraphNode.Button> buttons = taskInfo.buttons;
        boolean addLayout = !this.isLayoutEmpty(layout);
        HashMap<String, Object> props = null;
        if (addLayout) {
            props = new HashMap<String, Object>();
            props.put("layout", layout);
            props.put("formVariables", taskInfo.formVariables);
        }
        if (buttons != null && !buttons.isEmpty()) {
            for (GraphNode.Button button : buttons) {
                String id = button.getName();
                Action action = new Action(id, Action.EMPTY_CATEGORIES);
                action.setLabel(button.getLabel());
                if (addLayout) {
                    action.setProperties(props);
                    action.setType("fancybox");
                } else {
                    action.setType("link");
                }
                actions.put(id, action);
            }
        }
        return actions;
    }

    public List<Action> getTaskActions(String selectionListName) throws ClientException {
        LinkedHashMap<String, Action> actions = new LinkedHashMap<String, Action>();
        HashMap<String, Integer> actionsCounter = new HashMap<String, Integer>();
        List docs = this.documentsListsManager.getWorkingList(selectionListName);
        int taskDocsNum = 0;
        if (docs != null && !docs.isEmpty()) {
            for (DocumentModel doc : docs) {
                if (!doc.hasFacet("RoutingTask")) continue;
                TaskImpl task = new TaskImpl(doc);
                Map<String, Action> taskActions = this.getTaskActionsMap((Task)task);
                for (String actionId : taskActions.keySet()) {
                    Integer count = (Integer)actionsCounter.get(actionId);
                    if (count == null) {
                        actionsCounter.put(actionId, 1);
                        continue;
                    }
                    actionsCounter.put(actionId, count + 1);
                }
                actions.putAll(taskActions);
                ++taskDocsNum;
            }
        }
        ArrayList<Action> res = new ArrayList<Action>(actions.values());
        for (Action action : res) {
            if (((Integer)actionsCounter.get(action.getId())).equals(taskDocsNum)) continue;
            action.setAvailable(false);
        }
        return res;
    }

    public String endTasks(String selectionListName, Action taskAction) throws ClientException {
        HashMap data = new HashMap();
        Map formVariables = (Map)taskAction.getProperties().get("formVariables");
        if (formVariables != null) {
            data.put("WorkflowVariables", formVariables);
            data.put("NodeVariables", formVariables);
            if (formVariables.containsKey("comment")) {
                data.put("comment", formVariables.get("comment"));
            }
        }
        boolean hasErrors = false;
        DocumentRoutingService routing = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
        List docs = this.documentsListsManager.getWorkingList(selectionListName);
        if (docs != null && !docs.isEmpty()) {
            for (DocumentModel doc : docs) {
                if (!doc.hasFacet("RoutingTask")) continue;
                try {
                    routing.endTask(this.documentManager, (Task)new TaskImpl(doc), data, taskAction.getId());
                }
                catch (DocumentRouteException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)e, (Throwable)e);
                    }
                    hasErrors = true;
                }
            }
        }
        if (hasErrors) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("workflow.feedback.error.tasksEnded"), new Object[0]);
        } else {
            this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("workflow.feedback.info.tasksEnded"), new Object[0]);
        }
        this.documentsListsManager.resetWorkingList(selectionListName);
        Events.instance().raiseEvent("documentChanged", new Object[0]);
        Events.instance().raiseEvent("workflowTaskCompleted", new Object[0]);
        return null;
    }

    protected class TaskInfo {
        protected HashMap<String, Serializable> formVariables;
        protected String layout;
        protected List<GraphNode.Button> buttons;

        protected TaskInfo(HashMap<String, Serializable> formVariables, String layout, List<GraphNode.Button> buttons) {
            this.formVariables = formVariables;
            this.layout = layout;
            this.buttons = buttons;
        }
    }
}

