/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.schema.SchemaEntityFactory;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.AbstractSchemaLoader;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.syntax.ComparatorDescription;
import org.apache.directory.shared.ldap.schema.syntax.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionSchemaLoader
extends AbstractSchemaLoader {
    private static final Logger log = LoggerFactory.getLogger(PartitionSchemaLoader.class);
    private final SchemaPartitionDao dao;
    private SchemaEntityFactory factory;
    private Partition partition;
    private AttributeTypeRegistry attrRegistry;
    private final AttributeType mOidAT;
    private final AttributeType mNameAT;
    private final AttributeType cnAT;
    private final AttributeType byteCodeAT;
    private final AttributeType descAT;
    private final AttributeType fqcnAT;
    private static Map<String, LdapDN> staticAttributeTypeDNs = new HashMap<String, LdapDN>();
    private static Map<String, LdapDN> staticMatchingRulesDNs = new HashMap<String, LdapDN>();
    private static Map<String, LdapDN> staticObjectClassesDNs = new HashMap<String, LdapDN>();
    private static Map<String, LdapDN> staticComparatorsDNs = new HashMap<String, LdapDN>();
    private static Map<String, LdapDN> staticNormalizersDNs = new HashMap<String, LdapDN>();
    private static Map<String, LdapDN> staticSyntaxCheckersDNs = new HashMap<String, LdapDN>();
    private static Map<String, LdapDN> staticSyntaxesDNs = new HashMap<String, LdapDN>();

    public PartitionSchemaLoader(Partition partition, Registries bootstrapRegistries) throws NamingException {
        this.factory = new SchemaEntityFactory(bootstrapRegistries);
        this.partition = partition;
        this.attrRegistry = bootstrapRegistries.getAttributeTypeRegistry();
        this.dao = new SchemaPartitionDao(this.partition, bootstrapRegistries);
        this.mOidAT = bootstrapRegistries.getAttributeTypeRegistry().lookup("m-oid");
        this.mNameAT = bootstrapRegistries.getAttributeTypeRegistry().lookup("m-name");
        this.cnAT = bootstrapRegistries.getAttributeTypeRegistry().lookup("cn");
        this.byteCodeAT = bootstrapRegistries.getAttributeTypeRegistry().lookup("m-bytecode");
        this.descAT = bootstrapRegistries.getAttributeTypeRegistry().lookup("m-description");
        this.fqcnAT = bootstrapRegistries.getAttributeTypeRegistry().lookup("m-fqcn");
        this.initStaticDNs("system");
        this.initStaticDNs("core");
        this.initStaticDNs("apache");
        this.initStaticDNs("apachemeta");
        this.initStaticDNs("other");
        this.initStaticDNs("collective");
        this.initStaticDNs("java");
        this.initStaticDNs("cosine");
        this.initStaticDNs("inetorgperson");
    }

    private void initStaticDNs(String schemaName) throws NamingException {
        LdapDN dn = new LdapDN("ou=attributeTypes,cn=" + schemaName + ",ou=schema");
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        staticAttributeTypeDNs.put(schemaName, dn);
        dn = new LdapDN("ou=objectClasses,cn=" + schemaName + ",ou=schema");
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        staticObjectClassesDNs.put(schemaName, dn);
        dn = new LdapDN("ou=matchingRules,cn=" + schemaName + ",ou=schema");
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        staticMatchingRulesDNs.put(schemaName, dn);
        dn = new LdapDN("ou=comparators,cn=" + schemaName + ",ou=schema");
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        staticComparatorsDNs.put(schemaName, dn);
        dn = new LdapDN("ou=normalizers,cn=" + schemaName + ",ou=schema");
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        staticNormalizersDNs.put(schemaName, dn);
        dn = new LdapDN("ou=syntaxCheckers,cn=" + schemaName + ",ou=schema");
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        staticSyntaxCheckersDNs.put(schemaName, dn);
        dn = new LdapDN("ou=syntaxes,cn=" + schemaName + ",ou=schema");
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        staticSyntaxesDNs.put(schemaName, dn);
    }

    public void loadEnabled(Registries targetRegistries) throws NamingException {
        NamingEnumeration ne = this.dao.listAllNames();
        while (ne.hasMore()) {
            Attributes attrs = ((SearchResult)ne.next()).getAttributes();
            String oid = (String)AttributeUtils.getAttribute((Attributes)attrs, (AttributeType)this.mOidAT).get();
            Attribute names = AttributeUtils.getAttribute((Attributes)attrs, (AttributeType)this.mNameAT);
            targetRegistries.getOidRegistry().register(oid, oid);
            for (int ii = 0; ii < names.size(); ++ii) {
                targetRegistries.getOidRegistry().register((String)names.get(ii), oid);
            }
        }
        ne.close();
        Map<String, Schema> allSchemaMap = this.getSchemas();
        HashSet<Schema> enabledSchemaSet = new HashSet<Schema>();
        for (Schema schema : allSchemaMap.values()) {
            if (!schema.isDisabled()) {
                log.debug("will attempt to load enabled schema: {}", (Object)schema.getSchemaName());
                enabledSchemaSet.add(schema);
                continue;
            }
            log.debug("will NOT attempt to load disabled schema: {}", (Object)schema.getSchemaName());
        }
        this.loadWithDependencies(enabledSchemaSet, targetRegistries);
    }

    public Set<String> listDependentSchemaNames(String schemaName) throws NamingException {
        HashSet<String> dependees = new HashSet<String>();
        Set<SearchResult> results = this.dao.listSchemaDependents(schemaName);
        if (results.isEmpty()) {
            return dependees;
        }
        for (SearchResult sr : results) {
            Attribute cn = AttributeUtils.getAttribute((Attributes)sr.getAttributes(), (AttributeType)this.cnAT);
            dependees.add((String)cn.get());
        }
        return dependees;
    }

    public Set<String> listEnabledDependentSchemaNames(String schemaName) throws NamingException {
        HashSet<String> dependees = new HashSet<String>();
        Set<SearchResult> results = this.dao.listEnabledSchemaDependents(schemaName);
        if (results.isEmpty()) {
            return dependees;
        }
        for (SearchResult sr : results) {
            Attribute cn = AttributeUtils.getAttribute((Attributes)sr.getAttributes(), (AttributeType)this.cnAT);
            dependees.add((String)cn.get());
        }
        return dependees;
    }

    public Map<String, Schema> getSchemas() throws NamingException {
        return this.dao.getSchemas();
    }

    public Set<String> getSchemaNames() throws NamingException {
        return this.dao.getSchemaNames();
    }

    public Schema getSchema(String schemaName) throws NamingException {
        return this.dao.getSchema(schemaName);
    }

    public Schema getSchema(String schemaName, Properties schemaProperties) throws NamingException {
        return this.getSchema(schemaName);
    }

    public final void loadWithDependencies(Collection<Schema> schemas, Registries targetRegistries) throws NamingException {
        HashMap<String, Schema> notLoaded = new HashMap<String, Schema>();
        for (Schema schema : schemas) {
            notLoaded.put(schema.getSchemaName(), schema);
        }
        Iterator<Object> list = notLoaded.values().iterator();
        while (list.hasNext()) {
            Schema schema;
            schema = (Schema)list.next();
            this.loadDepsFirst(schema, new Stack(), notLoaded, schema, targetRegistries, null);
            list = notLoaded.values().iterator();
        }
    }

    public final void load(Schema schema, Registries targetRegistries, boolean isDepLoad) throws NamingException {
        if (schema.isDisabled() && isDepLoad) {
            this.dao.enableSchema(schema.getSchemaName());
        }
        if (targetRegistries.getLoadedSchemas().containsKey(schema.getSchemaName())) {
            log.debug("schema {} already seems to be loaded", (Object)schema.getSchemaName());
            return;
        }
        log.debug("loading {} schema ...", (Object)schema.getSchemaName());
        this.loadComparators(schema, targetRegistries);
        this.loadNormalizers(schema, targetRegistries);
        this.loadSyntaxCheckers(schema, targetRegistries);
        this.loadSyntaxes(schema, targetRegistries);
        this.loadMatchingRules(schema, targetRegistries);
        this.loadAttributeTypes(schema, targetRegistries);
        this.loadObjectClasses(schema, targetRegistries);
        this.loadMatchingRuleUses(schema, targetRegistries);
        this.loadDitContentRules(schema, targetRegistries);
        this.loadNameForms(schema, targetRegistries);
        this.loadDitStructureRules(schema, targetRegistries);
        this.notifyListenerOrRegistries(schema, targetRegistries);
    }

    private void loadMatchingRuleUses(Schema schema, Registries targetRegistries) {
    }

    private void loadDitStructureRules(Schema schema, Registries targetRegistries) throws NamingException {
    }

    private void loadNameForms(Schema schema, Registries targetRegistries) throws NamingException {
    }

    private void loadDitContentRules(Schema schema, Registries targetRegistries) throws NamingException {
    }

    private void loadObjectClasses(Schema schema, Registries targetRegistries) throws NamingException {
        LinkedList<ObjectClass> deferred = new LinkedList<ObjectClass>();
        LdapDN dn = staticObjectClassesDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new LdapDN("ou=objectClasses,cn=" + schema.getSchemaName() + ",ou=schema");
            dn.normalize(this.attrRegistry.getNormalizerMapping());
            staticObjectClassesDNs.put(schema.getSchemaName(), dn);
        }
        if (!this.partition.hasEntry(new EntryOperationContext(dn))) {
            return;
        }
        log.debug("{} schema: loading objectClasses", (Object)schema.getSchemaName());
        NamingEnumeration<SearchResult> list = this.partition.list(new ListOperationContext(dn));
        while (list.hasMore()) {
            SearchResult result = list.next();
            LdapDN resultDN = new LdapDN(result.getName());
            resultDN.normalize(this.attrRegistry.getNormalizerMapping());
            Attributes attrs = this.partition.lookup(new LookupOperationContext(resultDN));
            ObjectClass oc = this.factory.getObjectClass(attrs, targetRegistries, schema.getSchemaName());
            try {
                targetRegistries.getObjectClassRegistry().register(oc);
            }
            catch (NamingException ne) {
                deferred.add(oc);
            }
        }
        log.debug("Deferred queue size = {}", (Object)deferred.size());
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Deferred queue contains: ");
            for (ObjectClass extra : deferred) {
                buf.append(extra.getName());
                buf.append('[');
                buf.append(extra.getOid());
                buf.append("]");
                buf.append("\n");
            }
        }
        int lastCount = deferred.size();
        while (!deferred.isEmpty()) {
            log.debug("Deferred queue size = {}", (Object)deferred.size());
            ObjectClass oc = (ObjectClass)deferred.removeFirst();
            NamingException lastException = null;
            try {
                targetRegistries.getObjectClassRegistry().register(oc);
            }
            catch (NamingException ne) {
                deferred.addLast(oc);
                lastException = ne;
            }
            if (deferred.size() < lastCount) {
                lastCount = deferred.size();
                continue;
            }
            StringBuffer buf = new StringBuffer();
            buf.append("A cycle must exist somewhere within the objectClasses of the ");
            buf.append(schema.getSchemaName());
            buf.append(" schema.  We cannot seem to register the following objectClasses:\n");
            for (ObjectClass extra : deferred) {
                buf.append(extra.getName());
                buf.append('[');
                buf.append(extra.getOid());
                buf.append("]");
                buf.append("\n");
            }
            NamingException ne = new NamingException(buf.toString());
            ne.setRootCause(lastException);
        }
    }

    private void loadAttributeTypes(Schema schema, Registries targetRegistries) throws NamingException {
        LinkedList<AttributeType> deferred = new LinkedList<AttributeType>();
        LdapDN dn = staticAttributeTypeDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new LdapDN("ou=attributeTypes,cn=" + schema.getSchemaName() + ",ou=schema");
            dn.normalize(this.attrRegistry.getNormalizerMapping());
            staticAttributeTypeDNs.put(schema.getSchemaName(), dn);
        }
        if (!this.partition.hasEntry(new EntryOperationContext(dn))) {
            return;
        }
        log.debug("{} schema: loading attributeTypes", (Object)schema.getSchemaName());
        NamingEnumeration<SearchResult> list = this.partition.list(new ListOperationContext(dn));
        while (list.hasMore()) {
            SearchResult result = list.next();
            LdapDN resultDN = new LdapDN(result.getName());
            resultDN.normalize(this.attrRegistry.getNormalizerMapping());
            Attributes attrs = this.partition.lookup(new LookupOperationContext(resultDN));
            AttributeType at = this.factory.getAttributeType(attrs, targetRegistries, schema.getSchemaName());
            try {
                targetRegistries.getAttributeTypeRegistry().register(at);
            }
            catch (NamingException ne) {
                deferred.add(at);
            }
        }
        log.debug("Deferred queue size = {}", (Object)deferred.size());
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Deferred queue contains: ");
            for (AttributeType extra : deferred) {
                buf.append(extra.getName());
                buf.append('[');
                buf.append(extra.getOid());
                buf.append("]");
                buf.append("\n");
            }
        }
        int lastCount = deferred.size();
        while (!deferred.isEmpty()) {
            log.debug("Deferred queue size = {}", (Object)deferred.size());
            AttributeType at = (AttributeType)deferred.removeFirst();
            NamingException lastException = null;
            try {
                targetRegistries.getAttributeTypeRegistry().register(at);
            }
            catch (NamingException ne) {
                deferred.addLast(at);
                lastException = ne;
            }
            if (deferred.size() < lastCount) {
                lastCount = deferred.size();
                continue;
            }
            StringBuffer buf = new StringBuffer();
            buf.append("A cycle must exist somewhere within the attributeTypes of the ");
            buf.append(schema.getSchemaName());
            buf.append(" schema.  We cannot seem to register the following attributeTypes:\n");
            for (AttributeType extra : deferred) {
                buf.append(extra.getName());
                buf.append('[');
                buf.append(extra.getOid());
                buf.append("]");
                buf.append("\n");
            }
            NamingException ne = new NamingException(buf.toString());
            ne.setRootCause(lastException);
        }
    }

    private void loadMatchingRules(Schema schema, Registries targetRegistries) throws NamingException {
        LdapDN dn = staticMatchingRulesDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new LdapDN("ou=matchingRules,cn=" + schema.getSchemaName() + ",ou=schema");
            dn.normalize(this.attrRegistry.getNormalizerMapping());
            staticMatchingRulesDNs.put(schema.getSchemaName(), dn);
        }
        if (!this.partition.hasEntry(new EntryOperationContext(dn))) {
            return;
        }
        log.debug("{} schema: loading matchingRules", (Object)schema.getSchemaName());
        NamingEnumeration<SearchResult> list = this.partition.list(new ListOperationContext(dn));
        while (list.hasMore()) {
            SearchResult result = list.next();
            LdapDN resultDN = new LdapDN(result.getName());
            resultDN.normalize(this.attrRegistry.getNormalizerMapping());
            Attributes attrs = this.partition.lookup(new LookupOperationContext(resultDN));
            MatchingRule mrule = this.factory.getMatchingRule(attrs, targetRegistries, schema.getSchemaName());
            targetRegistries.getMatchingRuleRegistry().register(mrule);
        }
    }

    private void loadSyntaxes(Schema schema, Registries targetRegistries) throws NamingException {
        LdapDN dn = staticSyntaxesDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new LdapDN("ou=syntaxes,cn=" + schema.getSchemaName() + ",ou=schema");
            dn.normalize(this.attrRegistry.getNormalizerMapping());
            staticSyntaxesDNs.put(schema.getSchemaName(), dn);
        }
        if (!this.partition.hasEntry(new EntryOperationContext(dn))) {
            return;
        }
        log.debug("{} schema: loading syntaxes", (Object)schema.getSchemaName());
        NamingEnumeration<SearchResult> list = this.partition.list(new ListOperationContext(dn));
        while (list.hasMore()) {
            SearchResult result = list.next();
            LdapDN resultDN = new LdapDN(result.getName());
            resultDN.normalize(this.attrRegistry.getNormalizerMapping());
            Attributes attrs = this.partition.lookup(new LookupOperationContext(resultDN));
            Syntax syntax = this.factory.getSyntax(attrs, targetRegistries, schema.getSchemaName());
            targetRegistries.getSyntaxRegistry().register(syntax);
        }
    }

    private void loadSyntaxCheckers(Schema schema, Registries targetRegistries) throws NamingException {
        LdapDN dn = staticSyntaxCheckersDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new LdapDN("ou=syntaxCheckers,cn=" + schema.getSchemaName() + ",ou=schema");
            dn.normalize(this.attrRegistry.getNormalizerMapping());
            staticSyntaxCheckersDNs.put(schema.getSchemaName(), dn);
        }
        if (!this.partition.hasEntry(new EntryOperationContext(dn))) {
            return;
        }
        log.debug("{} schema: loading syntaxCheckers", (Object)schema.getSchemaName());
        NamingEnumeration<SearchResult> list = this.partition.list(new ListOperationContext(dn));
        while (list.hasMore()) {
            SearchResult result = list.next();
            LdapDN resultDN = new LdapDN(result.getName());
            resultDN.normalize(this.attrRegistry.getNormalizerMapping());
            Attributes attrs = this.partition.lookup(new LookupOperationContext(resultDN));
            SyntaxChecker sc = this.factory.getSyntaxChecker(attrs, targetRegistries);
            SyntaxCheckerDescription syntaxCheckerDescription = this.getSyntaxCheckerDescription(schema.getSchemaName(), attrs);
            targetRegistries.getSyntaxCheckerRegistry().register(syntaxCheckerDescription, sc);
        }
    }

    private void loadNormalizers(Schema schema, Registries targetRegistries) throws NamingException {
        LdapDN dn = staticNormalizersDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new LdapDN("ou=normalizers,cn=" + schema.getSchemaName() + ",ou=schema");
            dn.normalize(this.attrRegistry.getNormalizerMapping());
            staticNormalizersDNs.put(schema.getSchemaName(), dn);
        }
        if (!this.partition.hasEntry(new EntryOperationContext(dn))) {
            return;
        }
        log.debug("{} schema: loading normalizers", (Object)schema.getSchemaName());
        NamingEnumeration<SearchResult> list = this.partition.list(new ListOperationContext(dn));
        while (list.hasMore()) {
            SearchResult result = list.next();
            LdapDN resultDN = new LdapDN(result.getName());
            resultDN.normalize(this.attrRegistry.getNormalizerMapping());
            Attributes attrs = this.partition.lookup(new LookupOperationContext(resultDN));
            Normalizer normalizer = this.factory.getNormalizer(attrs, targetRegistries);
            NormalizerDescription normalizerDescription = this.getNormalizerDescription(schema.getSchemaName(), attrs);
            targetRegistries.getNormalizerRegistry().register(normalizerDescription, normalizer);
        }
    }

    private String getOid(Attributes entry) throws NamingException {
        Attribute oid = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.mOidAT);
        if (oid == null) {
            return null;
        }
        return (String)oid.get();
    }

    private NormalizerDescription getNormalizerDescription(String schemaName, Attributes entry) throws NamingException {
        Attribute bytecode;
        NormalizerDescription description = new NormalizerDescription();
        description.setNumericOid(this.getOid(entry));
        ArrayList<String> values = new ArrayList<String>();
        values.add(schemaName);
        description.addExtension("X-SCHEMA", values);
        description.setFqcn((String)AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.fqcnAT).get());
        Attribute desc = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.descAT);
        if (desc != null && desc.size() > 0) {
            description.setDescription((String)desc.get());
        }
        if ((bytecode = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.byteCodeAT)) != null && bytecode.size() > 0) {
            byte[] bytes = (byte[])bytecode.get();
            description.setBytecode(new String(Base64.encode((byte[])bytes)));
        }
        return description;
    }

    private void loadComparators(Schema schema, Registries targetRegistries) throws NamingException {
        LdapDN dn = staticComparatorsDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new LdapDN("ou=comparators,cn=" + schema.getSchemaName() + ",ou=schema");
            dn.normalize(this.attrRegistry.getNormalizerMapping());
            staticComparatorsDNs.put(schema.getSchemaName(), dn);
        }
        if (!this.partition.hasEntry(new EntryOperationContext(dn))) {
            return;
        }
        log.debug("{} schema: loading comparators", (Object)schema.getSchemaName());
        NamingEnumeration<SearchResult> list = this.partition.list(new ListOperationContext(dn));
        while (list.hasMore()) {
            SearchResult result = list.next();
            LdapDN resultDN = new LdapDN(result.getName());
            resultDN.normalize(this.attrRegistry.getNormalizerMapping());
            Attributes attrs = this.partition.lookup(new LookupOperationContext(resultDN));
            Comparator comparator = this.factory.getComparator(attrs, targetRegistries);
            ComparatorDescription comparatorDescription = this.getComparatorDescription(schema.getSchemaName(), attrs);
            targetRegistries.getComparatorRegistry().register(comparatorDescription, comparator);
        }
    }

    private ComparatorDescription getComparatorDescription(String schemaName, Attributes entry) throws NamingException {
        Attribute bytecode;
        ComparatorDescription description = new ComparatorDescription();
        description.setNumericOid(this.getOid(entry));
        ArrayList<String> values = new ArrayList<String>();
        values.add(schemaName);
        description.addExtension("X-SCHEMA", values);
        description.setFqcn((String)AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.fqcnAT).get());
        Attribute desc = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.descAT);
        if (desc != null && desc.size() > 0) {
            description.setDescription((String)desc.get());
        }
        if ((bytecode = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.byteCodeAT)) != null && bytecode.size() > 0) {
            byte[] bytes = (byte[])bytecode.get();
            description.setBytecode(new String(Base64.encode((byte[])bytes)));
        }
        return description;
    }

    private SyntaxCheckerDescription getSyntaxCheckerDescription(String schemaName, Attributes entry) throws NamingException {
        Attribute bytecode;
        SyntaxCheckerDescription description = new SyntaxCheckerDescription();
        description.setNumericOid(this.getOid(entry));
        ArrayList<String> values = new ArrayList<String>();
        values.add(schemaName);
        description.addExtension("X-SCHEMA", values);
        description.setFqcn((String)AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.fqcnAT).get());
        Attribute desc = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.descAT);
        if (desc != null && desc.size() > 0) {
            description.setDescription((String)desc.get());
        }
        if ((bytecode = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.byteCodeAT)) != null && bytecode.size() > 0) {
            byte[] bytes = (byte[])bytecode.get();
            description.setBytecode(new String(Base64.encode((byte[])bytes)));
        }
        return description;
    }

    public void loadWithDependencies(Schema schema, Registries registries) throws NamingException {
        HashMap<String, Schema> notLoaded = new HashMap<String, Schema>();
        notLoaded.put(schema.getSchemaName(), schema);
        Properties props = new Properties();
        this.loadDepsFirst(schema, new Stack(), notLoaded, schema, registries, props);
    }
}

