/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.registries;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class SchemaRegistry
extends ContributionFragmentRegistry<Schema> {
    protected final Map<String, Schema> schemas = new HashMap<String, Schema>();
    protected final Map<String, Schema> uri2schemaReg = new HashMap<String, Schema>();
    protected final Map<String, Schema> prefix2schemaReg = new HashMap<String, Schema>();

    public String getContributionId(Schema contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, Schema schema, Schema newOrigContrib) {
        Namespace ns = schema.getNamespace();
        this.uri2schemaReg.put(ns.uri, schema);
        this.prefix2schemaReg.put(ns.prefix, schema);
        this.schemas.put(id, schema);
    }

    public void contributionRemoved(String id, Schema schema) {
        Namespace ns = schema.getNamespace();
        this.uri2schemaReg.remove(ns.uri);
        this.prefix2schemaReg.remove(ns.prefix);
        this.schemas.remove(id);
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public Schema clone(Schema orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(Schema src, Schema dst) {
        throw new UnsupportedOperationException();
    }

    public Schema getSchema(String name) {
        return this.schemas.get(name);
    }

    public Schema getSchemaFromPrefix(String schemaPrefix) {
        return this.prefix2schemaReg.get(schemaPrefix);
    }

    public Schema getSchemaFromURI(String schemaURI) {
        return this.uri2schemaReg.get(schemaURI);
    }

    public Schema[] getSchemas() {
        return this.schemas.values().toArray(new Schema[this.schemas.size()]);
    }

    public int size() {
        return this.schemas.size();
    }

    public void clear() {
        this.schemas.clear();
        this.prefix2schemaReg.clear();
        this.uri2schemaReg.clear();
        this.contribs.clear();
    }
}

