/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.fn;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ui.web.rest.RestHelper;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public final class Functions {
    private static final Log log = LogFactory.getLog(Functions.class);
    public static final String I18N_DURATION_PREFIX = "label.duration.unit.";
    public static final String BIG_FILE_SIZE_LIMIT_PROPERTY = "org.nuxeo.big.file.size.limit";
    public static final long DEFAULT_BIG_FILE_SIZE_LIMIT = 0x500000L;
    private static UserManager userManager;
    private static final String FULLNAMES_MAP_KEY;
    static final Map<String, String> mapOfDateLength;

    private Functions() {
    }

    public static Object test(Boolean test, Object onSuccess, Object onFailure) {
        return test != false ? onSuccess : onFailure;
    }

    public static String join(String[] list, String separator) {
        return org.apache.commons.lang.StringUtils.join((Object[])list, (String)separator);
    }

    public static String joinCollection(Collection<Object> collection, String separator) {
        if (collection == null) {
            return null;
        }
        return org.apache.commons.lang.StringUtils.join(collection.iterator(), (String)separator);
    }

    public static String htmlEscape(String data) {
        return StringEscapeUtils.escapeHtml((String)data);
    }

    public static String javaScriptEscape(String data) {
        if (data != null) {
            data = StringEscapeUtils.escapeJavaScript((String)data);
        }
        return data;
    }

    public static String joinCollectionWithFinalDelimiter(Collection<Object> collection, String separator, String finalSeparator) {
        return Functions.joinArrayWithFinalDelimiter(collection.toArray(), separator, finalSeparator);
    }

    public static String joinArrayWithFinalDelimiter(Object[] collection, String separator, String finalSeparator) {
        if (collection == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        for (Object object : collection) {
            result.append(object);
            if (++i == collection.length - 1) {
                separator = finalSeparator;
            }
            if (i == collection.length) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static String formatDateUsingBasicFormatter(Date date) {
        return Functions.formatDate(date, Functions.basicDateFormater());
    }

    public static String formatDate(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String concat(String s1, String s2) {
        return s1 + s2;
    }

    public static String indentString(Integer level, String text) {
        StringBuilder label = new StringBuilder("");
        for (int i = 0; i < level; ++i) {
            label.append(text);
        }
        return label.toString();
    }

    public static boolean userIsMemberOf(String groupName) {
        FacesContext context = FacesContext.getCurrentInstance();
        NuxeoPrincipal principal = (NuxeoPrincipal)context.getExternalContext().getUserPrincipal();
        return principal.isMemberOf(groupName);
    }

    private static UserManager getUserManager() throws ClientException {
        if (userManager == null) {
            try {
                userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
        return userManager;
    }

    public static String userFullName(String username) {
        String fullName;
        if ("system".equals(username)) {
            return username;
        }
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        if (org.apache.commons.lang.StringUtils.isBlank((String)username)) {
            return null;
        }
        Map session = externalContext.getSessionMap();
        HashMap<String, String> fullNames = (HashMap<String, String>)session.get(FULLNAMES_MAP_KEY);
        if (fullNames != null && fullNames.containsKey(username)) {
            return (String)fullNames.get(username);
        }
        try {
            NuxeoPrincipal principal = Functions.getUserManager().getPrincipal(username);
            fullName = principal != null ? Functions.principalFullName(principal) : username;
        }
        catch (ClientException e) {
            fullName = username;
        }
        if (fullNames == null) {
            fullNames = new HashMap<String, String>();
            session.put(FULLNAMES_MAP_KEY, fullNames);
        }
        fullNames.put(username, fullName);
        return fullName;
    }

    public static String groupFullName(String groupId) {
        try {
            NuxeoGroup group = Functions.getUserManager().getGroup(groupId);
            String groupLabel = group.getLabel();
            String groupName = group.getName();
            return Functions.groupDisplayName(groupName, groupLabel);
        }
        catch (Exception e) {
            return groupId;
        }
    }

    public static String principalFullName(NuxeoPrincipal principal) {
        String first = principal.getFirstName();
        String last = principal.getLastName();
        return Functions.userDisplayName(principal.getName(), first, last);
    }

    public static String userDisplayName(String id, String first, String last) {
        if (first == null || first.length() == 0) {
            if (last == null || last.length() == 0) {
                return id;
            }
            return last;
        }
        if (last == null || last.length() == 0) {
            return first;
        }
        return first + ' ' + last;
    }

    public static String userDisplayNameAndEmail(String id, String first, String last, String email) {
        String userDisplayedName = Functions.userDisplayName(id, first, last);
        if (userDisplayedName.equals(id)) {
            return userDisplayedName;
        }
        if (email == null || email.length() == 0) {
            return userDisplayedName;
        }
        return userDisplayedName + " " + email;
    }

    public static String groupDisplayName(String name, String label) {
        return org.apache.commons.lang.StringUtils.isBlank((String)label) ? name : label;
    }

    public static String dateFormater(String formatLength) {
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = context.getViewRoot().getLocale();
        int style = 3;
        String styleString = mapOfDateLength.get(formatLength.toLowerCase());
        boolean addCentury = false;
        if ("shortWithCentury".toLowerCase().equals(styleString)) {
            addCentury = true;
        } else {
            style = Integer.parseInt(styleString);
        }
        DateFormat aDateFormat = DateFormat.getDateInstance(style, locale);
        SimpleDateFormat format = (SimpleDateFormat)aDateFormat;
        String pattern = format.toPattern();
        if (style == 3 && addCentury) {
            pattern = pattern.replace("yy", "yyyy");
        }
        return pattern;
    }

    public static String basicDateFormater() {
        return Functions.dateFormater("shortWithCentury");
    }

    public static String dateAndTimeFormater(String formatLength) {
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = context.getViewRoot().getLocale();
        int style = 3;
        String styleString = mapOfDateLength.get(formatLength.toLowerCase());
        boolean addCentury = false;
        if ("shortWithCentury".toLowerCase().equals(styleString)) {
            addCentury = true;
        } else {
            style = Integer.parseInt(styleString);
        }
        DateFormat aDateFormat = DateFormat.getDateTimeInstance(style, style, locale);
        SimpleDateFormat format = (SimpleDateFormat)aDateFormat;
        String pattern = format.toPattern();
        if (style == 3 && addCentury) {
            pattern = pattern.replace("yy", "yyyy");
        }
        return pattern;
    }

    public static String basicDateAndTimeFormater() {
        return Functions.dateAndTimeFormater("shortWithCentury");
    }

    public static String printFileSize(String size) {
        return Functions.printFormatedFileSize(size, "SI", true);
    }

    public static String printFormatedFileSize(String sizeS, String format, Boolean isShort) {
        String msg;
        int ex;
        long size = sizeS == null || "".equals(sizeS) ? 0L : Long.parseLong(sizeS);
        BytePrefix prefix = Enum.valueOf(BytePrefix.class, format);
        int base = prefix.getBase();
        String[] suffix = isShort != false ? prefix.getShortSuffixes() : prefix.getLongSuffixes();
        for (ex = 0; size > (long)(base - 1) || ex > suffix.length; ++ex, size /= (long)base) {
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            Locale locale;
            String bundleName = context.getApplication().getMessageBundle();
            msg = I18NUtils.getMessageString((String)bundleName, (String)"label.bytes.suffix", null, (Locale)(locale = context.getViewRoot().getLocale()));
            if ("label.bytes.suffix".equals(msg)) {
                msg = "B";
            }
        } else {
            msg = "B";
        }
        return "" + size + " " + suffix[ex] + msg;
    }

    public static Integer integerDivision(Integer x, Integer y) {
        return x / y;
    }

    public static String printFormattedDuration(Object durationObj, Map<String, String> i18nLabels) {
        if (i18nLabels == null) {
            i18nLabels = new HashMap<String, String>();
        }
        double duration = 0.0;
        if (durationObj instanceof Float) {
            duration = ((Float)durationObj).doubleValue();
        } else if (durationObj instanceof Double) {
            duration = (Double)durationObj;
        } else if (durationObj instanceof Integer) {
            duration = ((Integer)durationObj).doubleValue();
        } else if (durationObj instanceof Long) {
            duration = ((Long)durationObj).doubleValue();
        } else if (durationObj instanceof String) {
            duration = Double.parseDouble((String)durationObj);
        }
        int days = (int)Math.floor(duration / 86400.0);
        int hours = (int)Math.floor(duration / 3600.0) - days * 24;
        int minutes = (int)Math.floor(duration / 60.0) - days * 24 * 60 - hours * 60;
        int seconds = (int)Math.floor(duration) - days * 24 * 3600 - hours * 3600 - minutes * 60;
        int[] components = new int[]{days, hours, minutes, seconds};
        String[] units = new String[]{"days", "hours", "minutes", "seconds"};
        String[] defaultLabels = new String[]{"d", "hr", "min", "sec"};
        String representation = null;
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == 0 && i != components.length - 1) continue;
            String i18nLabel = i18nLabels.get(I18N_DURATION_PREFIX + units[i]);
            if (i18nLabel == null) {
                i18nLabel = defaultLabels[i];
            }
            representation = String.format("%d %s", components[i], i18nLabel);
            if (i >= components.length - 1) break;
            i18nLabel = i18nLabels.get(I18N_DURATION_PREFIX + units[i + 1]);
            if (i18nLabel == null) {
                i18nLabel = defaultLabels[i + 1];
            }
            representation = representation + String.format(" %d %s", components[i + 1], i18nLabel);
            break;
        }
        return representation;
    }

    public static String printFormattedDuration(Object durationObj) {
        return Functions.printFormattedDuration(durationObj, null);
    }

    public static final String translate(String messageId, Object ... params) {
        return ComponentUtils.translate(FacesContext.getCurrentInstance(), messageId, params);
    }

    public static long getBigFileSizeLimit() {
        return Functions.getFileSize(Framework.getProperty((String)BIG_FILE_SIZE_LIMIT_PROPERTY, (String)""));
    }

    public static long getFileSize(String value) {
        Pattern pattern = Pattern.compile("([1-9][0-9]*)([kmgi]*)", 2);
        Matcher m = pattern.matcher(value.trim());
        if (!m.matches()) {
            return 0x500000L;
        }
        long number = Long.valueOf(m.group(1));
        String multiplier = m.group(2);
        return Functions.getValueFromMultiplier(multiplier) * number;
    }

    public static long getValueFromMultiplier(String m) {
        if ("k".equalsIgnoreCase(m)) {
            return 1000L;
        }
        if ("Ki".equalsIgnoreCase(m)) {
            return 1024L;
        }
        if ("M".equalsIgnoreCase(m)) {
            return 1000000L;
        }
        if ("Mi".equalsIgnoreCase(m)) {
            return 0x100000L;
        }
        if ("G".equalsIgnoreCase(m)) {
            return 1000000000L;
        }
        if ("Gi".equalsIgnoreCase(m)) {
            return 0x40000000L;
        }
        return 1L;
    }

    public static boolean hasMessages(String clientId) {
        Iterator it = FacesContext.getCurrentInstance().getClientIdsWithMessages();
        if (clientId == null) {
            return it.hasNext();
        }
        while (it.hasNext()) {
            String id = (String)it.next();
            if (id == null || !id.startsWith(clientId)) continue;
            return true;
        }
        return false;
    }

    public static String userUrl(String patternName, String username, String viewId, boolean newConversation) {
        return Functions.userUrl(patternName, username, viewId, newConversation, null);
    }

    public static String userUrl(String patternName, String username, String viewId, boolean newConversation, HttpServletRequest req) {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("username", username);
            DocumentViewImpl docView = new DocumentViewImpl(null, viewId, parameters);
            URLPolicyService service = (URLPolicyService)Framework.getService(URLPolicyService.class);
            if (patternName == null || patternName.length() == 0) {
                patternName = service.getDefaultPatternName();
            }
            String baseURL = null;
            baseURL = req == null ? BaseURL.getBaseURL() : BaseURL.getBaseURL((ServletRequest)req);
            String url = service.getUrlFromDocumentView(patternName, (DocumentView)docView, baseURL);
            if (!newConversation && url != null) {
                url = RestHelper.addCurrentConversationParameters(url);
            }
            return url;
        }
        catch (Exception e) {
            log.error((Object)"Could not generate user url", (Throwable)e);
            return null;
        }
    }

    public static List<Object> combineLists(List<? extends Object> ... lists) {
        ArrayList<Object> combined = new ArrayList<Object>();
        for (List<? extends Object> list : lists) {
            combined.addAll(list);
        }
        return combined;
    }

    public static String jsfTagIdEscape(String base) {
        if (base == null) {
            return null;
        }
        int n = base.length();
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = base.charAt(i);
            if (i == 0) {
                if (!Character.isLetter(c) && c != '_') {
                    res.append("_");
                    continue;
                }
                res.append(c);
                continue;
            }
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') {
                res.append("_");
                continue;
            }
            res.append(c);
        }
        return StringUtils.toAscii((String)res.toString());
    }

    static {
        FULLNAMES_MAP_KEY = Functions.class.getName() + ".FULLNAMES_MAP";
        mapOfDateLength = new HashMap<String, String>(){
            private static final long serialVersionUID = 8465772256977862352L;
            {
                this.put("short", String.valueOf(3));
                this.put("shortWithCentury".toLowerCase(), "shortWithCentury".toLowerCase());
                this.put("medium", String.valueOf(2));
                this.put("long", String.valueOf(1));
                this.put("full", String.valueOf(0));
            }
        };
    }

    public static enum BytePrefix {
        SI(1000, new String[]{"", "k", "M", "G", "T", "P", "E", "Z", "Y"}, new String[]{"", "kilo", "mega", "giga", "tera", "peta", "exa", "zetta", "yotta"}),
        IEC(1024, new String[]{"", "Ki", "Mi", "Gi", "Ti", "Pi", "Ei", "Zi", "Yi"}, new String[]{"", "kibi", "mebi", "gibi", "tebi", "pebi", "exbi", "zebi", "yobi"}),
        JEDEC(1024, new String[]{"", "K", "M", "G"}, new String[]{"", "kilo", "mega", "giga"});

        private final int base;
        private final String[] shortSuffixes;
        private final String[] longSuffixes;

        private BytePrefix(int base, String[] shortSuffixes, String[] longSuffixes) {
            this.base = base;
            this.shortSuffixes = shortSuffixes;
            this.longSuffixes = longSuffixes;
        }

        public int getBase() {
            return this.base;
        }

        public String[] getShortSuffixes() {
            return this.shortSuffixes;
        }

        public String[] getLongSuffixes() {
            return this.longSuffixes;
        }
    }
}

