/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.naming.directory.Attributes;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.apache.directory.server.core.partition.impl.btree.gui.AttributesTableModel;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddEntryDialog
extends JDialog
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(AddEntryDialog.class);
    private static final long serialVersionUID = 3544671793504663604L;
    private JPanel m_namePnl = new JPanel();
    private JPanel m_attrPnl = new JPanel();
    private JPanel m_buttonPnl = new JPanel();
    private JPanel m_rdnPnl = new JPanel();
    private JPanel m_dnPnl = new JPanel();
    private JLabel m_rdnLbl = new JLabel();
    private JComboBox m_rdnChoice = new JComboBox();
    private JTextField m_dnText = new JTextField();
    private JScrollPane m_attrScrollPnl = new JScrollPane();
    private JTable m_attrTbl = new JTable();
    private JButton m_doneBut = new JButton();
    private JButton m_cancelBut = new JButton();
    private JPopupMenu m_popup;
    private Attributes m_childEntry = new AttributesImpl();

    public AddEntryDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.m_childEntry.put("objectClass", "top");
        this.initGUI();
    }

    private void initGUI() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AddEntryDialog.this.closeDialog();
            }
        });
        this.pack();
        this.setBounds(new Rectangle(0, 0, 447, 364));
        this.setTitle("Add New Entry");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.m_namePnl, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.m_attrPnl, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.m_buttonPnl, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.05, 10, 2, new Insets(0, 0, 0, 20), 0, 0));
        this.m_namePnl.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1), "Naming", 4, 2, new Font("SansSerif", 0, 14), new Color(60, 60, 60)));
        this.m_namePnl.setLayout(new BoxLayout(this.m_namePnl, 1));
        this.m_namePnl.add(this.m_rdnPnl);
        this.m_namePnl.add(this.m_dnPnl);
        this.m_rdnLbl.setText("Rdn:");
        this.m_rdnPnl.setLayout(new GridBagLayout());
        this.m_rdnPnl.add((Component)this.m_rdnChoice, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.m_rdnPnl.add((Component)this.m_rdnLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.m_dnPnl.setLayout(new GridBagLayout());
        this.m_dnPnl.add((Component)this.m_dnText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.m_dnText.setText("unknown");
        this.m_dnText.setEditable(false);
        this.m_dnText.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1), "Dn", 4, 2, new Font("SansSerif", 0, 14), new Color(60, 60, 60)));
        this.m_rdnChoice.setEditable(true);
        this.m_rdnChoice.setMaximumRowCount(6);
        this.m_rdnChoice.setSize(new Dimension(130, 24));
        this.m_attrPnl.setLayout(new BorderLayout());
        this.m_attrPnl.add((Component)this.m_attrScrollPnl, "Center");
        this.m_attrScrollPnl.getViewport().add(this.m_attrTbl);
        this.m_attrTbl.setBounds(new Rectangle(78, 60, 32, 32));
        this.m_attrTbl.setCellSelectionEnabled(true);
        this.m_doneBut.setText("Done");
        this.m_buttonPnl.setLayout(new FlowLayout(2, 10, 5));
        this.m_buttonPnl.add(this.m_doneBut);
        this.m_buttonPnl.add(this.m_cancelBut);
        this.m_cancelBut.setText("Cancel");
        this.m_cancelBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a_evt) {
                AddEntryDialog.this.closeDialog();
            }
        });
        this.m_attrScrollPnl.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1), "Attributes", 4, 2, new Font("SansSerif", 0, 14), new Color(60, 60, 60)));
        this.m_attrTbl.setModel(new AttributesTableModel(this.m_childEntry, null, null, true));
        this.m_popup = new JPopupMenu();
        JMenuItem l_menuItem = new JMenuItem("Add");
        l_menuItem.setActionCommand("Add");
        l_menuItem.addActionListener(this);
        this.m_popup.add(l_menuItem);
        l_menuItem = new JMenuItem("Delete");
        l_menuItem.setActionCommand("Delete");
        l_menuItem.addActionListener(this);
        this.m_popup.add(l_menuItem);
        this.m_attrTbl.addMouseListener(new PopupListener());
        this.setUpEditor(this.m_attrTbl);
    }

    private void setUpEditor(JTable l_table) {
        final JTextField l_textField = new JTextField();
        DefaultCellEditor l_textEditor = new DefaultCellEditor(l_textField){
            private static final long serialVersionUID = 3256727286014554675L;

            public Object getCellEditorValue() {
                if (log.isDebugEnabled()) {
                    log.debug("Editor returning '" + l_textField.getText() + "'");
                }
                return l_textField.getText();
            }
        };
        l_table.setDefaultEditor(String.class, l_textEditor);
    }

    public void actionPerformed(ActionEvent a_event) {
        String l_cmd = a_event.getActionCommand();
        AttributesTableModel l_model = (AttributesTableModel)this.m_attrTbl.getModel();
        int l_row = this.m_attrTbl.getSelectedRow();
        log.debug(l_cmd);
        if (l_row >= l_model.getRowCount() || l_row < 0) {
            JOptionPane.showMessageDialog(this, "Row needs to be selected to apply operation");
        }
        if (l_cmd.equals("Add")) {
            l_model.insert(l_row, "xxxx", "xxxx");
        } else if (l_cmd.equals("Delete")) {
            l_model.delete(l_row);
        } else {
            JOptionPane.showMessageDialog(this, "Unrecognized action - abandoning action processing.");
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public void setParentDn(String dn) {
        this.m_dnText.setText(dn);
    }

    public Attributes getChildEntry() {
        return this.m_childEntry;
    }

    public String getChildDn() {
        return this.m_dnText.getText();
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                AddEntryDialog.this.m_popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

