/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.local.LocalSession;
import org.nuxeo.ecm.core.model.NoSuchRepositoryException;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.repository.RepositoryDescriptor;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.ecm.core.repository.RepositoryManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventListener;
import org.nuxeo.runtime.services.event.EventService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class RepositoryService
extends DefaultComponent
implements EventListener {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.core.repository.RepositoryService");
    private static final Log log = LogFactory.getLog(RepositoryService.class);
    public static final String REPOSITORY = "repository";
    public static final String REPOSITORY_REGISTERED = "registered";
    public static final String REPOSITORY_UNREGISTERED = "unregistered";
    private RepositoryManager repositoryMgr;
    private EventService eventService;

    public void activate(ComponentContext context) throws Exception {
        this.repositoryMgr = new RepositoryManager(this);
        this.eventService = (EventService)context.getRuntimeContext().getRuntime().getComponent(EventService.NAME);
        if (this.eventService == null) {
            throw new Exception("Event Service was not found");
        }
        this.eventService.addListener(REPOSITORY, (EventListener)this);
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.repositoryMgr.shutdown();
        this.repositoryMgr = null;
    }

    void fireRepositoryRegistered(RepositoryDescriptor rd) {
        this.eventService.sendEvent(new Event(REPOSITORY, REPOSITORY_REGISTERED, (Object)this, (Object)rd.getName()));
    }

    void fireRepositoryUnRegistered(RepositoryDescriptor rd) {
        this.eventService.sendEvent(new Event(REPOSITORY, REPOSITORY_UNREGISTERED, (Object)this, (Object)rd.getName()));
    }

    public boolean aboutToHandleEvent(Event event) {
        return false;
    }

    public void handleEvent(Event event) {
        if (event.getId().equals(REPOSITORY_UNREGISTERED)) {
            String name = (String)event.getData();
            try {
                Repository repo = NXCore.getRepository(name);
                log.info((Object)("Closing repository: " + name));
                repo.shutdown();
            }
            catch (NoSuchRepositoryException e) {
            }
            catch (Exception e) {
                log.error((Object)("Failed to close repository: " + name), (Throwable)e);
            }
        }
    }

    public void registerExtension(Extension extension) throws Exception {
        Object[] repos = extension.getContributions();
        if (repos != null) {
            for (Object repo : repos) {
                this.repositoryMgr.registerRepository((RepositoryDescriptor)repo);
            }
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        Object[] repos;
        super.unregisterExtension(extension);
        for (Object repo : repos = extension.getContributions()) {
            this.repositoryMgr.unregisterRepository((RepositoryDescriptor)repo);
        }
    }

    public RepositoryManager getRepositoryManager() {
        return this.repositoryMgr;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(CoreSession.class)) {
            return (T)LocalSession.createInstance();
        }
        return null;
    }

    public int getApplicationStartedOrder() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationStarted(ComponentContext context) throws Exception {
        RepositoryInitializationHandler handler = RepositoryInitializationHandler.getInstance();
        if (handler == null) {
            return;
        }
        boolean started = false;
        boolean ok = false;
        try {
            started = !TransactionHelper.isTransactionActive() && TransactionHelper.startTransaction();
            for (String name : this.repositoryMgr.getRepositoryNames()) {
                this.initializeRepository(handler, name);
            }
            ok = true;
        }
        finally {
            if (started) {
                try {
                    if (!ok) {
                        TransactionHelper.setTransactionRollbackOnly();
                    }
                }
                finally {
                    TransactionHelper.commitOrRollbackTransaction();
                }
            }
        }
    }

    protected void initializeRepository(final RepositoryInitializationHandler handler, String name) {
        try {
            new UnrestrictedSessionRunner(name){

                public void run() throws ClientException {
                    handler.initializeRepository(this.session);
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new RuntimeException("Failed to initialize repository '" + name + "': " + e.getMessage(), e);
        }
    }
}

