/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.ServiceManager;
import org.nuxeo.runtime.api.DefaultServiceProvider;
import org.nuxeo.runtime.api.ServiceProvider;
import org.nuxeo.runtime.api.SharedResourceLoader;
import org.nuxeo.runtime.api.login.LoginAs;
import org.nuxeo.runtime.api.login.LoginService;

public final class Framework {
    private static final Log log = LogFactory.getLog(Framework.class);
    public static final String NUXEO_DEV_SYSTEM_PROP = "org.nuxeo.dev";
    public static final String NUXEO_TESTING_SYSTEM_PROP = "org.nuxeo.runtime.testing";
    public static final String NUXEO_STRICT_RUNTIME_SYSTEM_PROP = "org.nuxeo.runtime.strict";
    private static RuntimeService runtime;
    private static ServiceManager serviceMgr;
    private static final ListenerList listeners;
    private static final FileCleaningTracker fileCleaningTracker;
    protected static SharedResourceLoader resourceLoader;
    protected static Boolean isOSGiServiceSupported;

    private Framework() {
    }

    public static void initialize(RuntimeService runtimeService) throws Exception {
        if (runtime != null) {
            throw new Exception("Nuxeo Framework was already initialized");
        }
        runtime = runtimeService;
        Framework.reloadResourceLoader();
        Framework.initServiceManager();
        runtime.start();
    }

    public static void reloadResourceLoader() throws Exception {
        File rs = new File(Environment.getDefault().getData(), "resources");
        rs.mkdirs();
        resourceLoader = new SharedResourceLoader(new URL[]{rs.toURI().toURL()}, Framework.class.getClassLoader());
    }

    public static void reloadResourceLoader(List<URL> urlsToAdd, List<URL> urlsToRemove) throws MalformedURLException {
        File rs = new File(Environment.getDefault().getData(), "resources");
        rs.mkdirs();
        URL[] existing = null;
        if (resourceLoader != null) {
            existing = resourceLoader.getURLs();
        }
        resourceLoader = new SharedResourceLoader(new URL[]{rs.toURI().toURL()}, Framework.class.getClassLoader());
        if (existing != null) {
            for (URL oldURL : existing) {
                if (urlsToRemove != null && urlsToRemove.contains(oldURL)) continue;
                resourceLoader.addURL(oldURL);
            }
        }
        if (urlsToAdd != null) {
            for (URL newURL : urlsToAdd) {
                resourceLoader.addURL(newURL);
            }
        }
    }

    public static void shutdown() throws Exception {
        if (runtime != null) {
            runtime.stop();
            runtime = null;
        }
    }

    public static synchronized boolean isInitialized() {
        return runtime != null;
    }

    public static SharedResourceLoader getResourceLoader() {
        return resourceLoader;
    }

    private static void initServiceManager() {
        serviceMgr = org.nuxeo.runtime.api.ServiceManager.getInstance();
    }

    public static RuntimeService getRuntime() {
        return runtime;
    }

    public static <T> T getService(Class<T> serviceClass) throws Exception {
        return serviceMgr.getService(serviceClass);
    }

    public static <T> T getService(Class<T> serviceClass, String name) throws Exception {
        return serviceMgr.getService(serviceClass, name);
    }

    public static <T> T getLocalService(Class<T> serviceClass) {
        ServiceProvider provider = DefaultServiceProvider.getProvider();
        if (provider != null) {
            return provider.getService(serviceClass);
        }
        return runtime.getService(serviceClass);
    }

    public static Object lookup(String key) {
        return null;
    }

    public static LoginContext login() throws LoginException {
        if (null == runtime) {
            throw new IllegalStateException("runtime not initialized");
        }
        LoginService loginService = runtime.getService(LoginService.class);
        if (loginService != null) {
            return loginService.login();
        }
        return null;
    }

    public static LoginContext loginAs(String username) throws LoginException {
        if (null == runtime) {
            throw new IllegalStateException("runtime not initialized");
        }
        LoginService loginService = runtime.getService(LoginService.class);
        if (loginService != null) {
            return loginService.loginAs(username);
        }
        return null;
    }

    public static LoginContext loginAsUser(String username) throws LoginException {
        return Framework.getLocalService(LoginAs.class).loginAs(username);
    }

    public static LoginContext login(String username, Object password) throws LoginException {
        LoginService loginService = runtime.getService(LoginService.class);
        if (loginService != null) {
            return loginService.login(username, password);
        }
        return null;
    }

    public static LoginContext login(CallbackHandler cbHandler) throws LoginException {
        LoginService loginService = runtime.getService(LoginService.class);
        if (loginService != null) {
            return loginService.login(cbHandler);
        }
        return null;
    }

    public static void sendEvent(RuntimeServiceEvent event) {
        Object[] listenersArray;
        for (Object listener : listenersArray = listeners.getListeners()) {
            ((RuntimeServiceListener)listener).handleEvent(event);
        }
    }

    public static void addListener(RuntimeServiceListener listener) {
        listeners.add((Object)listener);
    }

    public static void removeListener(RuntimeServiceListener listener) {
        listeners.remove((Object)listener);
    }

    public static String getProperty(String key) {
        return Framework.getProperty(key, null);
    }

    public static String getProperty(String key, String defValue) {
        return runtime.getProperty(key, defValue);
    }

    public static Properties getProperties() {
        return runtime.getProperties();
    }

    public static String expandVars(String expression) {
        int p = expression.indexOf("${");
        if (p == -1) {
            return expression;
        }
        char[] buf = expression.toCharArray();
        StringBuilder result = new StringBuilder(buf.length);
        if (p > 0) {
            result.append(expression.substring(0, p));
        }
        StringBuilder varBuf = new StringBuilder();
        boolean dollar = false;
        boolean var = false;
        block5: for (int i = p; i < buf.length; ++i) {
            char c = buf[i];
            switch (c) {
                case '$': {
                    dollar = true;
                    continue block5;
                }
                case '{': {
                    if (dollar) {
                        dollar = false;
                        var = true;
                        continue block5;
                    }
                    result.append(c);
                    continue block5;
                }
                case '}': {
                    if (var) {
                        var = false;
                        String varName = varBuf.toString();
                        varBuf.setLength(0);
                        String varValue = Framework.getProperty(varName);
                        if (varValue != null) {
                            result.append(varValue);
                            continue block5;
                        }
                        result.append("${").append(varName).append('}');
                        continue block5;
                    }
                    result.append(c);
                    continue block5;
                }
                default: {
                    if (var) {
                        varBuf.append(c);
                        continue block5;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static boolean isOSGiServiceSupported() {
        if (isOSGiServiceSupported == null) {
            isOSGiServiceSupported = Boolean.valueOf(Framework.getProperty("ecr.osgi.services", "false"));
        }
        return isOSGiServiceSupported;
    }

    public static boolean isDevModeSet() {
        return Framework.isBooleanPropertyTrue(NUXEO_DEV_SYSTEM_PROP);
    }

    public static boolean isTestModeSet() {
        return Framework.isBooleanPropertyTrue(NUXEO_TESTING_SYSTEM_PROP);
    }

    public static boolean isBooleanPropertyTrue(String propName) {
        String test = Framework.getProperty(propName);
        if (test == null) {
            test = System.getProperty(propName);
        }
        return Boolean.TRUE.equals(Boolean.valueOf(test));
    }

    public static void handleDevError(Throwable t) {
        if (Framework.isBooleanPropertyTrue(NUXEO_STRICT_RUNTIME_SYSTEM_PROP)) {
            System.err.println("Fatal error caught in strict runtime mode => exiting.");
            t.printStackTrace();
            System.exit(1);
        } else {
            log.error((Object)t, t);
        }
    }

    public static void trackFile(File file, Object marker) {
        fileCleaningTracker.track(file, marker);
    }

    public static void trackFile(File file, Object marker, FileDeleteStrategy fileDeleteStrategy) {
        fileCleaningTracker.track(file, marker, fileDeleteStrategy);
    }

    public static void main(String[] args) {
    }

    static {
        listeners = new ListenerList();
        fileCleaningTracker = new FileCleaningTracker();
    }
}

