/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.restAPI;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.syndication.vocabularies.HierarchicalVocabulary;
import org.nuxeo.ecm.platform.syndication.vocabularies.SimpleVocabulary;
import org.nuxeo.ecm.platform.syndication.vocabularies.Tree;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.w3c.dom.Element;

public class VocabularyRestlet
extends BaseStatelessNuxeoRestlet {
    private static String getTranslation(String key, Locale local) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("messages", local, Thread.currentThread().getContextClassLoader());
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public void handle(Request req, Response res) {
        Session dirSession;
        DOMDocument result;
        block16: {
            DirectoryService directoryService;
            DOMDocumentFactory domfactory = new DOMDocumentFactory();
            result = (DOMDocument)domfactory.createDocument();
            Locale translationLocal = Locale.getDefault();
            String lang = req.getResourceRef().getQueryAsForm().getFirstValue("lang");
            if (lang != null && !"".equals(lang)) {
                for (Locale loc : Locale.getAvailableLocales()) {
                    if (!loc.getLanguage().equalsIgnoreCase(lang)) continue;
                    translationLocal = loc;
                }
            }
            try {
                directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
                if (directoryService == null) {
                    VocabularyRestlet.handleError((DOMDocument)result, (Response)res, (String)"Unable to get Directory Service");
                    return;
                }
            }
            catch (Exception e) {
                VocabularyRestlet.handleError((DOMDocument)result, (Response)res, (Exception)e);
                return;
            }
            String vocName = (String)req.getAttributes().get("vocName");
            if ("".equals(vocName)) {
                VocabularyRestlet.handleError((DOMDocument)result, (Response)res, (String)"You must specify a vocabulary name");
                return;
            }
            try {
                dirSession = directoryService.open(vocName);
                String directorySchema = directoryService.getDirectorySchema(vocName);
                if (directorySchema.equals("vocabulary")) {
                    Element current = result.createElement("entries");
                    result.setRootElement((org.dom4j.Element)current);
                    for (DocumentModel entry : dirSession.getEntries()) {
                        Element el = result.createElement("entry");
                        el.setAttribute("id", entry.getId());
                        el.setAttribute("label", (String)entry.getProperty("vocabulary", "label"));
                        el.setAttribute("translatedLabel", VocabularyRestlet.getTranslation((String)entry.getProperty("vocabulary", "label"), translationLocal));
                        current.appendChild(el);
                    }
                    break block16;
                }
                if (directorySchema.equals("xvocabulary")) {
                    Tree.Builder treeBuilder = new Tree.Builder();
                    for (DocumentModel doc : dirSession.getEntries()) {
                        String id = doc.getId();
                        String label = (String)doc.getProperty("xvocabulary", "label");
                        String translatedLabel = VocabularyRestlet.getTranslation(label, translationLocal);
                        String parent = (String)doc.getProperty("xvocabulary", "parent");
                        SimpleVocabulary voca = new SimpleVocabulary(id, label, translatedLabel, vocName);
                        try {
                            treeBuilder.addElement(parent, VocabularyRestlet.constructHierarchicalParent(vocName, parent), voca);
                        }
                        catch (Exception e) {
                            VocabularyRestlet.handleError((DOMDocument)result, (Response)res, (String)"Problems when listing all the entries from vocabulary");
                        }
                    }
                    Tree tree = treeBuilder.build();
                    tree.buildXML(result);
                    break block16;
                }
                VocabularyRestlet.handleError((DOMDocument)result, (Response)res, (String)"Selected directory is not a vocabulary");
                return;
            }
            catch (ClientException e) {
                VocabularyRestlet.handleError((DOMDocument)result, (Response)res, (Exception)((Object)e));
                return;
            }
        }
        try {
            dirSession.close();
        }
        catch (ClientException e) {
            VocabularyRestlet.handleError((DOMDocument)result, (Response)res, (Exception)((Object)e));
            return;
        }
        res.setEntity(result.asXML(), MediaType.TEXT_XML);
        res.getEntity().setCharacterSet(CharacterSet.UTF_8);
    }

    private static HierarchicalVocabulary constructHierarchicalParent(String vocabularyName, String parentId) throws Exception {
        HierarchicalVocabulary parentVoca1;
        block5: {
            DirectoryService directoryService;
            try {
                directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
                if (directoryService == null) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            parentVoca1 = null;
            String parentVocabulary = directoryService.getParentDirectoryName(vocabularyName);
            if (parentVocabulary == null) break block5;
            Session parentDirSession = directoryService.open(parentVocabulary);
            String parentDirectorySchema = directoryService.getDirectorySchema(parentVocabulary);
            DocumentModel parentEntry = parentDirSession.getEntry(parentId);
            String parentLabel = (String)parentEntry.getProperty(parentDirectorySchema, "label");
            String parentTranslatedLabel = VocabularyRestlet.getTranslation(parentLabel, Locale.getDefault());
            String newVocaName = parentVocabulary;
            if ((parentVocabulary = directoryService.getParentDirectoryName(parentVocabulary)) == null) {
                parentVoca1 = new HierarchicalVocabulary(null, new SimpleVocabulary(parentEntry.getId(), parentLabel, parentTranslatedLabel));
                parentDirSession.close();
            } else {
                String parentEntryId = (String)parentEntry.getProperty(parentDirectorySchema, "parent");
                HierarchicalVocabulary hParent = VocabularyRestlet.constructHierarchicalParent(newVocaName, parentEntryId);
                parentVoca1 = new HierarchicalVocabulary(hParent, new SimpleVocabulary(parentEntry.getId(), parentLabel, parentTranslatedLabel));
                hParent.addChild(parentVoca1);
                parentDirSession.close();
            }
        }
        return parentVoca1;
    }
}

