/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.util;

import java.util.Iterator;
import java.util.List;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractPageFetcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIterator<T>
implements Iterator<T> {
    private long skipCount;
    private int skipOffset;
    private final AbstractPageFetcher<T> pageFetcher;
    private AbstractPageFetcher.Page<T> page;
    private Long totalNumItems;
    private Boolean hasMoreItems;

    protected AbstractIterator(long skipCount, AbstractPageFetcher<T> pageFetcher) {
        this.skipCount = skipCount;
        this.pageFetcher = pageFetcher;
    }

    public long getPosition() {
        return this.skipCount + (long)this.skipOffset;
    }

    public long getPageNumItems() {
        List<T> items;
        AbstractPageFetcher.Page<T> page = this.getCurrentPage();
        if (page != null && (items = page.getItems()) != null) {
            return items.size();
        }
        return 0L;
    }

    public long getTotalNumItems() {
        if (this.totalNumItems == null) {
            this.totalNumItems = -1L;
            AbstractPageFetcher.Page<T> page = this.getCurrentPage();
            if (page != null && page.getTotalNumItems() != null) {
                this.totalNumItems = page.getTotalNumItems();
            }
        }
        return this.totalNumItems;
    }

    public boolean getHasMoreItems() {
        if (this.hasMoreItems == null) {
            this.hasMoreItems = Boolean.FALSE;
            AbstractPageFetcher.Page<T> page = this.getCurrentPage();
            if (page != null && page.getHasMoreItems() != null) {
                this.hasMoreItems = page.getHasMoreItems();
            }
        }
        return this.hasMoreItems;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected long getSkipCount() {
        return this.skipCount;
    }

    protected int getSkipOffset() {
        return this.skipOffset;
    }

    protected int incrementSkipOffset() {
        return this.skipOffset++;
    }

    protected AbstractPageFetcher.Page<T> getCurrentPage() {
        if (this.page == null) {
            this.page = this.pageFetcher.fetchPage(this.skipCount);
        }
        return this.page;
    }

    protected AbstractPageFetcher.Page<T> incrementPage() {
        this.skipCount += (long)this.skipOffset;
        this.skipOffset = 0;
        this.totalNumItems = null;
        this.hasMoreItems = null;
        this.page = this.pageFetcher.fetchPage(this.skipCount);
        return this.page;
    }
}

