/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public abstract class AbstractBlob
implements Blob {
    public static final String EMPTY_STRING = "";
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final InputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(EMPTY_BYTE_ARRAY);
    public static final Reader EMPTY_READER = new StringReader("");
    protected static final int BUFFER_SIZE = 65536;

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[65536];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    public static void copy(Reader in, Writer out) throws IOException {
        int read;
        char[] buffer = new char[65536];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferTo(Writer writer) throws IOException {
        Reader reader = this.getReader();
        if (reader != null && reader != EMPTY_READER) {
            try {
                AbstractBlob.copy(reader, writer);
            }
            finally {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferTo(OutputStream out) throws IOException {
        InputStream in = this.getStream();
        if (in != null && in != EMPTY_INPUT_STREAM) {
            try {
                AbstractBlob.copy(in, out);
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferTo(File file) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.transferTo(out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @Override
    public void transferToOrMove(File file, boolean keep) throws IOException {
        StreamingBlob streamingBlob;
        StreamSource streamSource;
        if (this instanceof StreamingBlob && (streamSource = (streamingBlob = (StreamingBlob)this).getStreamSource()) instanceof FileSource && streamingBlob.isTemporary()) {
            FileSource fileSource = (FileSource)streamSource;
            AbstractBlob.atomicMove(fileSource.getFile(), file);
            fileSource.setFile(file);
            if (keep) {
                streamingBlob.setTemporary(false);
            }
            return;
        }
        this.transferTo(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void atomicMove(File source, File dest) throws IOException {
        if (dest.exists()) {
            dest.setLastModified(source.lastModified());
            return;
        }
        if (!source.renameTo(dest)) {
            File tmp = File.createTempFile(dest.getName(), ".tmp", dest.getParentFile());
            try {
                FileInputStream in = null;
                OutputStream out = null;
                try {
                    in = new FileInputStream(source);
                    out = new FileOutputStream(tmp);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                tmp.renameTo(dest);
            }
            finally {
                tmp.delete();
            }
            source.delete();
        }
        if (!dest.exists()) {
            throw new IOException("Could not create file: " + dest);
        }
    }
}

