/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.preview.adapter.AbstractPreviewer;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.api.PreviewException;

public class PlainTextPreviewer
extends AbstractPreviewer
implements MimeTypePreviewer {
    @Override
    public List<Blob> getPreview(Blob blob, DocumentModel dm) throws PreviewException {
        byte[] data;
        ArrayList<Blob> blobResults = new ArrayList<Blob>();
        StringBuilder htmlPage = new StringBuilder();
        htmlPage.append("<html><body>");
        try {
            data = blob.getByteArray();
        }
        catch (IOException e) {
            throw new PreviewException("Cannot fetch blob content", e);
        }
        String content = new String(data);
        String temp = content.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("'", "&apos;").replace("\"", "&quot;");
        htmlPage.append("<pre>").append(temp.replace("\n", "<br/>")).append("</pre>");
        htmlPage.append("</body></html>");
        StringBlob mainBlob = new StringBlob(htmlPage.toString());
        mainBlob.setFilename("index.html");
        mainBlob.setMimeType("text/html");
        blobResults.add((Blob)mainBlob);
        return blobResults;
    }
}

