/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.math.NumberUtils;
import org.nuxeo.ecm.automation.ConflictOperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.runtime.api.Framework;

public class ExceptionHandler {
    protected static final String PERMISSION_EXCEPTION_HTTP_CODE_PROP = "org.nuxeo.ecm.automation.server.permission.httpcode";
    protected int status = 500;
    protected String type;
    protected Throwable cause;
    protected String message;

    public static WebApplicationException newException(Throwable cause) {
        return ExceptionHandler.newException(null, cause);
    }

    public static WebApplicationException newException(String message, Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException("the cause parameter cannot be null");
        }
        ExceptionHandler e = new ExceptionHandler(message, cause);
        return new WebApplicationException(cause, Response.status((int)e.getStatus()).entity((Object)e).build());
    }

    public static void abort(String message, Throwable cause) throws WebApplicationException {
        throw ExceptionHandler.newException(message, cause);
    }

    public static void abort(Throwable cause) throws WebApplicationException {
        throw ExceptionHandler.newException(null, cause);
    }

    public static int getStatus(Throwable cause) {
        return ExceptionHandler.getStatus(cause, 8);
    }

    public static boolean isSecurityError(Throwable t) {
        return ExceptionHandler.getStatus(t) == 403;
    }

    public static int getStatus(Throwable cause, int depth) {
        Throwable parent;
        if (depth == 0) {
            return 500;
        }
        if (cause instanceof DocumentSecurityException || cause instanceof SecurityException || "javax.ejb.EJBAccessException".equals(cause.getClass().getName())) {
            int permissionExceptionStatus = NumberUtils.toInt((String)Framework.getProperty((String)PERMISSION_EXCEPTION_HTTP_CODE_PROP));
            if (permissionExceptionStatus == 0) {
                permissionExceptionStatus = 401;
            }
            return permissionExceptionStatus;
        }
        if (cause instanceof NoSuchDocumentException) {
            return 404;
        }
        if (cause instanceof ClientException) {
            Throwable ccause = cause.getCause();
            if (ccause != null && ccause.getMessage() != null && ccause.getMessage().contains("org.nuxeo.ecm.core.model.NoSuchDocumentException")) {
                return 404;
            }
        } else {
            if (cause instanceof OperationNotFoundException) {
                return 404;
            }
            if (cause instanceof ConflictOperationException) {
                return 409;
            }
        }
        if ((parent = cause.getCause()) != null) {
            return ExceptionHandler.getStatus(parent, depth - 1);
        }
        return 500;
    }

    public ExceptionHandler(String message, Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException("the cause parameter cannot be null");
        }
        this.status = ExceptionHandler.getStatus(cause);
        this.cause = cause;
        this.message = message == null ? cause.getMessage() : message;
        this.type = cause.getClass().getName();
    }

    public int getStatus() {
        return this.status;
    }

    public String getType() {
        return this.cause.getClass().getName();
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSerializedStackTrace() {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        this.cause.printStackTrace(pw);
        pw.flush();
        return writer.toString();
    }

    public Throwable getCause() {
        return this.cause;
    }
}

