/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.strategy;

import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.strategy.BaseMixedContentEncodingStrategy;

public abstract class MixedContentEncodingStrategy {
    public static final String ENCODING_OPTION_NAME = "org.apache.commons.betwixt.mixed-content-encoding";
    public static final String CDATA_ENCODING = "CDATA";
    public static final MixedContentEncodingStrategy DEFAULT = new BaseMixedContentEncodingStrategy(){

        protected boolean encodeAsCDATA(ElementDescriptor element) {
            boolean result = false;
            if (element != null) {
                String optionValue = element.getOptions().getValue(MixedContentEncodingStrategy.ENCODING_OPTION_NAME);
                result = MixedContentEncodingStrategy.CDATA_ENCODING.equals(optionValue);
            }
            return result;
        }
    };
    public static final MixedContentEncodingStrategy CDATA = new BaseMixedContentEncodingStrategy(){

        protected boolean encodeAsCDATA(ElementDescriptor element) {
            return true;
        }
    };
    public static final MixedContentEncodingStrategy ESCAPED_CHARACTERS = new BaseMixedContentEncodingStrategy(){

        protected boolean encodeAsCDATA(ElementDescriptor element) {
            return false;
        }
    };

    public abstract String encode(String var1, ElementDescriptor var2);
}

