/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.importer.base.GenericMultiThreadedImporter;
import org.nuxeo.ecm.platform.importer.base.ImporterRunnerConfiguration;
import org.nuxeo.ecm.platform.importer.executor.AbstractImporterExecutor;
import org.nuxeo.ecm.platform.importer.executor.DefaultImporterExecutor;
import org.nuxeo.ecm.platform.importer.factories.DefaultDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.filter.EventServiceConfiguratorFilter;
import org.nuxeo.ecm.platform.importer.log.ImporterLogger;
import org.nuxeo.ecm.platform.importer.service.DefaultImporterService;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class DefaultImporterServiceImpl
implements DefaultImporterService {
    private static Log log = LogFactory.getLog(DefaultImporterServiceImpl.class);
    private Class<? extends DefaultDocumentModelFactory> docModelFactoryClass;
    private Class<? extends SourceNode> sourceNodeClass;
    private DefaultDocumentModelFactory documentModelFactory;
    private String folderishDocType;
    private String leafDocType;
    private ImporterLogger importerLogger;

    @Override
    public void importDocuments(String destinationPath, String sourcePath, boolean skipRootContainerCreation, int batchSize, int noImportingThreads) throws ClientException {
        SourceNode sourceNode = this.createNewSourceNodeInstanceForSourcePath(sourcePath);
        if (sourceNode == null) {
            log.error((Object)"Need to set a sourceNode to be used by this importer");
            return;
        }
        if (this.getDocumentModelFactory() == null) {
            log.error((Object)"Need to set a documentModelFactory to be used by this importer");
        }
        DefaultImporterExecutor executor = new DefaultImporterExecutor();
        executor.setFactory(this.getDocumentModelFactory());
        try {
            executor.run(sourceNode, destinationPath, (Boolean)skipRootContainerCreation, (Integer)batchSize, (Integer)noImportingThreads, (Boolean)true);
        }
        catch (Exception e) {
            log.error((Object)"Import error:", (Throwable)e);
            throw new ClientException((Throwable)e);
        }
    }

    @Override
    public String importDocuments(AbstractImporterExecutor executor, String destinationPath, String sourcePath, boolean skipRootContainerCreation, int batchSize, int noImportingThreads, boolean interactive) throws ClientException {
        GenericMultiThreadedImporter runner;
        SourceNode sourceNode = this.createNewSourceNodeInstanceForSourcePath(sourcePath);
        if (sourceNode == null) {
            log.error((Object)"Need to set a sourceNode to be used by this importer");
            return "Can not import";
        }
        if (this.getDocumentModelFactory() == null) {
            log.error((Object)"Need to set a documentModelFactory to be used by this importer");
        }
        ImporterRunnerConfiguration configuration = new ImporterRunnerConfiguration.Builder(sourceNode, destinationPath, executor.getLogger()).skipRootContainerCreation(skipRootContainerCreation).batchSize(batchSize).nbThreads(noImportingThreads).build();
        try {
            runner = new GenericMultiThreadedImporter(configuration);
        }
        catch (Exception e1) {
            log.error((Object)e1);
            throw new ClientException((Throwable)e1);
        }
        EventServiceConfiguratorFilter filter = new EventServiceConfiguratorFilter(false, false, false, true);
        runner.addFilter(filter);
        runner.setFactory(this.getDocumentModelFactory());
        try {
            return executor.run(runner, interactive);
        }
        catch (Exception e) {
            log.error((Object)"Import error:", (Throwable)e);
            throw new ClientException((Throwable)e);
        }
    }

    @Override
    public String importDocuments(AbstractImporterExecutor executor, String leafType, String folderishType, String destinationPath, String sourcePath, boolean skipRootContainerCreation, int batchSize, int noImportingThreads, boolean interactive) throws ClientException {
        DefaultDocumentModelFactory defaultDocModelFactory = this.getDocumentModelFactory();
        defaultDocModelFactory.setLeafType(leafType == null ? this.getLeafDocType() : leafType);
        defaultDocModelFactory.setFolderishType(folderishType == null ? this.getFolderishDocType() : folderishType);
        this.setDocumentModelFactory(defaultDocModelFactory);
        String res = this.importDocuments(executor, destinationPath, sourcePath, skipRootContainerCreation, batchSize, noImportingThreads, interactive);
        this.setDocumentModelFactory(null);
        return res;
    }

    @Override
    public void setDocModelFactoryClass(Class<? extends DefaultDocumentModelFactory> docModelFactoryClass) {
        this.docModelFactoryClass = docModelFactoryClass;
    }

    @Override
    public void setSourceNodeClass(Class<? extends SourceNode> sourceNodeClass) {
        this.sourceNodeClass = sourceNodeClass;
    }

    protected SourceNode createNewSourceNodeInstanceForSourcePath(String sourcePath) {
        SourceNode sourceNode = null;
        if (this.sourceNodeClass != null && FileSourceNode.class.isAssignableFrom(this.sourceNodeClass)) {
            try {
                sourceNode = this.sourceNodeClass.getConstructor(String.class).newInstance(sourcePath);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return sourceNode;
    }

    protected DefaultDocumentModelFactory getDocumentModelFactory() {
        if (this.documentModelFactory == null && this.docModelFactoryClass != null && DefaultDocumentModelFactory.class.isAssignableFrom(this.docModelFactoryClass)) {
            try {
                this.setDocumentModelFactory(this.docModelFactoryClass.getConstructor(String.class, String.class).newInstance(this.getFolderishDocType(), this.getLeafDocType()));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return this.documentModelFactory;
    }

    protected void setDocumentModelFactory(DefaultDocumentModelFactory documentModelFactory) {
        this.documentModelFactory = documentModelFactory;
    }

    protected String getFolderishDocType() {
        return this.folderishDocType;
    }

    @Override
    public void setFolderishDocType(String folderishDocType) {
        this.folderishDocType = folderishDocType;
    }

    protected String getLeafDocType() {
        return this.leafDocType;
    }

    @Override
    public void setLeafDocType(String fileDocType) {
        this.leafDocType = fileDocType;
    }

    protected ImporterLogger getImporterLogger() {
        return this.importerLogger;
    }

    @Override
    public void setImporterLogger(ImporterLogger importerLogger) {
        this.importerLogger = importerLogger;
    }
}

