/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.listener;

import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.runtime.api.Framework;

public class RoutingTaskSecurityUpdaterListener
implements EventListener {
    private DocumentRoutingService routingService;

    public void handleEvent(Event event) throws ClientException {
        EventContext eventCtx = event.getContext();
        if (!(eventCtx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docEventCtx = (DocumentEventContext)eventCtx;
        Task task = (Task)docEventCtx.getProperties().get("taskInstance");
        if (task == null) {
            return;
        }
        CoreSession session = eventCtx.getCoreSession();
        List actors = task.getActors();
        if (actors == null || actors.isEmpty()) {
            return;
        }
        String routeDocId = (String)task.getVariables().get("routeInstanceDocId");
        if (routeDocId == null) {
            return;
        }
        DocumentModel routeDoc = session.getDocument((DocumentRef)new IdRef(routeDocId));
        for (String userName : actors) {
            if (userName.startsWith("group:") || userName.startsWith("user:")) {
                userName = userName.substring(userName.indexOf(":") + 1);
            }
            ACP acp = routeDoc.getACP();
            ACL routeACL = acp.getOrCreateACL("routingTask");
            routeACL.add((Object)new ACE(userName, "ReadWrite", true));
            acp.addACL(routeACL);
            session.setACP(routeDoc.getRef(), acp, true);
        }
        session.saveDocument(routeDoc);
    }

    protected DocumentRoutingService getDocumentRoutingService() {
        try {
            if (this.routingService == null) {
                this.routingService = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
            }
            return this.routingService;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

