/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.convert;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.video.convert.BaseVideoConverter;
import org.nuxeo.runtime.api.Framework;

public class StoryboardConverter
extends BaseVideoConverter
implements Converter {
    public static final Log log = LogFactory.getLog(StoryboardConverter.class);
    public static final String FFMPEG_INFO_COMMAND = "ffmpeg-info";
    public static final String FFMPEG_SCREENSHOT_RESIZE_COMMAND = "ffmpeg-screenshot-resize";
    public static final String WIDTH_PARAM = "width";
    public static final String HEIGHT_PARAM = "height";
    public static final String THUMBNAIL_NUMBER_PARAM = "thumbnail_number";
    protected int numberOfThumbnails = 9;
    protected Map<String, String> commonParams = new HashMap<String, String>();

    public void init(ConverterDescriptor descriptor) {
        try {
            this.cleService = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        this.commonParams = descriptor.getParameters();
        if (!this.commonParams.containsKey(WIDTH_PARAM)) {
            this.commonParams.put(WIDTH_PARAM, "100");
        }
        if (!this.commonParams.containsKey(HEIGHT_PARAM)) {
            this.commonParams.put(HEIGHT_PARAM, "62");
        }
        if (this.commonParams.containsKey(THUMBNAIL_NUMBER_PARAM)) {
            this.numberOfThumbnails = Integer.parseInt(this.commonParams.get(THUMBNAIL_NUMBER_PARAM));
        }
        if (this.numberOfThumbnails < 1) {
            this.numberOfThumbnails = 1;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        SimpleBlobHolderWithProperties simpleBlobHolderWithProperties;
        Double duration;
        CmdParameters params;
        SimpleBlobHolderWithProperties bh;
        ArrayList<String> comments;
        ArrayList<Double> timecodes;
        ArrayList<Blob> blobs;
        Blob blob;
        BaseVideoConverter.InputFile inputFile;
        File outFolder;
        block17: {
            block16: {
                outFolder = null;
                inputFile = null;
                blob = null;
                HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
                blobs = new ArrayList<Blob>();
                timecodes = new ArrayList<Double>();
                comments = new ArrayList<String>();
                properties.put("timecodes", timecodes);
                properties.put("comments", comments);
                bh = new SimpleBlobHolderWithProperties(blobs, properties);
                blob = blobHolder.getBlob();
                inputFile = new BaseVideoConverter.InputFile(blob);
                outFolder = File.createTempFile("StoryboardConverter-out-", "-tmp");
                outFolder.delete();
                outFolder.mkdir();
                params = new CmdParameters();
                params.addNamedParameter("inFilePath", inputFile.file.getAbsolutePath());
                duration = (Double)parameters.get("duration");
                if (duration != null) break block16;
                log.warn((Object)String.format("Cannot extract storyboard for file '%s' with missing duration info.", blob.getFilename()));
                SimpleBlobHolderWithProperties simpleBlobHolderWithProperties2 = bh;
                FileUtils.deleteQuietly((File)outFolder);
                if (inputFile != null && inputFile.isTempFile) {
                    FileUtils.deleteQuietly((File)inputFile.file);
                }
                return simpleBlobHolderWithProperties2;
            }
            if (!(duration < 10.0)) break block17;
            SimpleBlobHolderWithProperties simpleBlobHolderWithProperties3 = bh;
            FileUtils.deleteQuietly((File)outFolder);
            if (inputFile != null && inputFile.isTempFile) {
                FileUtils.deleteQuietly((File)inputFile.file);
            }
            return simpleBlobHolderWithProperties3;
        }
        try {
            for (int i = 0; i < this.numberOfThumbnails; ++i) {
                long timecode = Double.valueOf(Math.floor((double)i * duration / (double)this.numberOfThumbnails)).longValue();
                File outSubFolder = new File(outFolder, String.format("%04d", i));
                outSubFolder.mkdir();
                File outFile = new File(outSubFolder, "video-thumb-%04d.jpeg");
                params.addNamedParameter("outFilePath", outFile.getAbsolutePath());
                params.addNamedParameter("position", String.valueOf(timecode));
                params.addNamedParameter(WIDTH_PARAM, this.commonParams.get(WIDTH_PARAM));
                params.addNamedParameter(HEIGHT_PARAM, this.commonParams.get(HEIGHT_PARAM));
                ExecResult result = this.cleService.execCommand(FFMPEG_SCREENSHOT_RESIZE_COMMAND, params);
                if (!result.isSuccessful()) {
                    throw result.getError();
                }
                ArrayList thumbs = new ArrayList(FileUtils.listFiles((File)outSubFolder, (String[])new String[]{"jpeg"}, (boolean)false));
                if (thumbs.isEmpty()) {
                    String commandLine = result.getCommandLine();
                    log.error((Object)("Error executing command: " + commandLine));
                    String output = StringUtils.join((Collection)result.getOutput(), (String)"\n");
                    log.error((Object)output);
                    throw new ConversionException(String.format("Failed taking storyboard screenshot for video file '%s' with command: %s", blob.getFilename(), commandLine));
                }
                Blob thumbBlob = StreamingBlob.createFromStream((InputStream)new FileInputStream((File)thumbs.get(0)), (String)"image/jpeg").persist();
                thumbBlob.setFilename(String.format("%05d.000-seconds.jpeg", timecode));
                blobs.add(thumbBlob);
                timecodes.add(Double.valueOf(timecode));
                comments.add(String.format("%s %d", blob.getFilename(), i));
            }
            simpleBlobHolderWithProperties = bh;
        }
        catch (IOException e) {
            try {
                String msg = this.getErrorMessage(blob);
                throw new ConversionException(msg, (Exception)e);
                catch (CommandNotAvailable e2) {
                    msg = this.getErrorMessage(blob);
                    throw new ConversionException(msg, (Exception)((Object)e2));
                }
                catch (ClientException e3) {
                    msg = this.getErrorMessage(blob);
                    throw new ConversionException(msg, (Exception)((Object)e3));
                }
                catch (CommandException e4) {
                    msg = this.getErrorMessage(blob);
                    throw new ConversionException(msg, (Exception)((Object)e4));
                }
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(outFolder);
                if (inputFile != null && inputFile.isTempFile) {
                    FileUtils.deleteQuietly((File)inputFile.file);
                }
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)outFolder);
        if (inputFile != null && inputFile.isTempFile) {
            FileUtils.deleteQuietly((File)inputFile.file);
        }
        return simpleBlobHolderWithProperties;
    }

    private String getErrorMessage(Blob blob) {
        String msg = blob != null ? "Error extracting story board from '" + blob.getFilename() + "'" : "conversion failed";
        return msg;
    }
}

