/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.servlet;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.WSSConfig;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.fprpc.FPRPCRequest;
import org.nuxeo.wss.fprpc.FPRPCResponse;
import org.nuxeo.wss.handlers.fakews.FakeWSRequest;
import org.nuxeo.wss.handlers.fakews.FakeWSRouter;
import org.nuxeo.wss.handlers.fprpc.FPRPCRouter;
import org.nuxeo.wss.handlers.get.SimpleGetHandler;
import org.nuxeo.wss.handlers.resources.ResourcesHandler;
import org.nuxeo.wss.servlet.BaseWSSFilter;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.servlet.WSSResponse;
import org.nuxeo.wss.servlet.config.FilterBindingConfig;
import org.nuxeo.wss.spi.Backend;
import org.nuxeo.wss.spi.WSSBackend;

public class WSSFilter
extends BaseWSSFilter
implements Filter {
    protected Boolean rootFilter = null;
    protected SimpleGetHandler simpleGetHandler = null;
    protected ResourcesHandler resourcesHandler = null;
    protected static final Log log = LogFactory.getLog(WSSFilter.class);

    protected void doForward(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterBindingConfig config) throws Exception {
        ServletContext targetContext = this.ctx.getContext(this.getRootFilterTarget());
        if (targetContext != null) {
            targetContext.getRequestDispatcher(httpRequest.getRequestURI()).forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        } else {
            String newTarget = this.getRootFilterTarget() + httpRequest.getRequestURI() + "?" + httpRequest.getQueryString();
            if ("VtiHandler".equals(config.getTargetService()) || "SHtmlHandler".equals(config.getTargetService())) {
                this.handleWSSCall(httpRequest, httpResponse, config);
            } else {
                httpResponse.sendRedirect(newTarget);
            }
        }
    }

    protected void handleWSSCall(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterBindingConfig config) throws Exception {
        httpRequest.setCharacterEncoding("UTF-8");
        httpResponse.setCharacterEncoding("UTF-8");
        WSSRequest request = new WSSRequest(httpRequest, config.getSiteName());
        WSSResponse response = null;
        WSSBackend backend = Backend.get(request);
        backend.begin();
        log.debug((Object)("Handling WSS call : " + httpRequest.getRequestURL().toString()));
        try {
            if ("FP".equals(config.getRequestType())) {
                FPRPCRequest fpRequest = new FPRPCRequest(httpRequest, config.getSiteName());
                request = fpRequest;
                response = new FPRPCResponse(httpResponse);
                FPRPCRouter.handleFPRCPRequest(fpRequest, (FPRPCResponse)response, config);
            } else if ("GET".equals(config.getRequestType())) {
                response = new WSSResponse(httpResponse);
                this.simpleGetHandler.handleRequest(request, response);
            } else {
                if ("RESOURCES".equals(config.getRequestType())) {
                    this.resourcesHandler.handleResource(httpRequest, httpResponse);
                    return;
                }
                if ("FakeWS".equals(config.getRequestType())) {
                    FakeWSRequest wsRequest = new FakeWSRequest(httpRequest, config.getSiteName());
                    request = wsRequest;
                    response = new WSSResponse(httpResponse);
                    FakeWSRouter.handleFakeWSRequest(wsRequest, response, config);
                }
            }
            if (response == null) {
                log.error((Object)"no response was created by WSS call handling");
                throw new ServletException("WSSResponse is not set");
            }
            response.processIfNeeded();
            backend.saveChanges();
        }
        catch (Throwable t) {
            backend.discardChanges();
            log.error((Object)"Error during WSS call processing", t);
            throw new WSSException("Error while processing WSS request", t);
        }
    }

    protected boolean isRootFilter() {
        if (this.rootFilter == null) {
            if (this.filterConfig != null) {
                String target = this.filterConfig.getInitParameter("org.nuxeo.wss.rootFilter");
                if (target != null && !"".equals(target)) {
                    this.rootFilter = true;
                    this.rootFilterTarget = target;
                } else {
                    this.rootFilter = false;
                }
            } else {
                this.rootFilter = false;
            }
        }
        return this.rootFilter;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (this.isRootFilter()) {
            WSSConfig.instance().setContextPath(this.rootFilterTarget);
        }
    }

    protected void initBackend(FilterConfig filterConfig) {
        String factoryName = filterConfig.getInitParameter("org.nuxeo.wss.backendFactory");
        if (factoryName != null) {
            WSSConfig.instance().setWssBackendFactoryClassName(factoryName);
        }
    }

    protected void initHandlers(FilterConfig filterConfig) {
        this.simpleGetHandler = new SimpleGetHandler();
        this.resourcesHandler = new ResourcesHandler();
    }
}

