/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.adapters;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.impl.AbstractResourceAdapter;
import org.nuxeo.ecm.platform.relations.api.impl.QNameResourceImpl;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentModelResourceAdapter
extends AbstractResourceAdapter
implements Serializable {
    private static final Log log = LogFactory.getLog(DocumentModelResourceAdapter.class);
    private static final long serialVersionUID = -5307418102496342779L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Serializable getResourceRepresentation(Resource resource, Map<String, Serializable> context) {
        DocumentModel object = null;
        if (!resource.isQNameResource()) return object;
        CoreSession session = null;
        boolean sessionOpened = false;
        try {
            Serializable givenSessionId;
            String uid;
            String repoName;
            RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
            String localName = ((QNameResource)resource).getLocalName();
            int index = localName.indexOf(47);
            if (index == -1) {
                repoName = mgr.getDefaultRepository().getName();
                uid = localName;
            } else {
                repoName = localName.substring(0, index);
                uid = localName.substring(index + 1);
            }
            IdRef ref = new IdRef(uid);
            if (context != null && (givenSessionId = context.get("CoreSession")) instanceof String && !(session = CoreInstance.getInstance().getSession((String)((Object)givenSessionId))).getRepositoryName().equals(repoName)) {
                session = null;
            }
            if (session == null) {
                sessionOpened = true;
                Repository repo = mgr.getRepository(repoName);
                session = repo.open();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Opened a new session '%s' with id %s", repoName, session.getSessionId()));
                }
            }
            object = session.getDocument((DocumentRef)ref);
            if (session == null || !sessionOpened) return object;
        }
        catch (Exception e) {
            if (session == null || !sessionOpened) return object;
            CoreInstance core = CoreInstance.getInstance();
            core.close(session);
            return object;
            catch (Throwable throwable) {
                if (session == null || !sessionOpened) throw throwable;
                CoreInstance core2 = CoreInstance.getInstance();
                core2.close(session);
                throw throwable;
            }
        }
        CoreInstance core = CoreInstance.getInstance();
        core.close(session);
        return object;
    }

    public Resource getResource(Serializable object, Map<String, Serializable> context) {
        if (object instanceof DocumentModel) {
            DocumentModel doc = (DocumentModel)object;
            String localName = doc.getRepositoryName() + '/' + doc.getId();
            return new QNameResourceImpl(this.namespace, localName);
        }
        if (object instanceof DocumentLocation) {
            DocumentLocation docLoc = (DocumentLocation)object;
            String localName = docLoc.getServerName() + '/' + docLoc.getIdRef().toString();
            return new QNameResourceImpl(this.namespace, localName);
        }
        throw new IllegalArgumentException(String.format("cannot build resource for '%s'", object));
    }

    public Class<?> getKlass() {
        return DocumentModel.class;
    }
}

