/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.services;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.GraphDescription;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QueryResult;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.ResourceAdapter;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.descriptors.GraphDescriptor;
import org.nuxeo.ecm.platform.relations.descriptors.GraphTypeDescriptor;
import org.nuxeo.ecm.platform.relations.descriptors.ResourceAdapterDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationService
extends DefaultComponent
implements RelationManager,
FrameworkListener {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.relations.services.RelationService");
    private static final long serialVersionUID = -4778456059717447736L;
    private static final Log log = LogFactory.getLog(RelationService.class);
    private final Map<String, String> graphTypeRegistry = new Hashtable<String, String>();
    private final Map<String, GraphDescription> graphDescriptionRegistry = new Hashtable<String, GraphDescription>();
    private final transient Map<String, Graph> graphRegistry = new Hashtable<String, Graph>();
    private final Map<String, String> resourceAdapterRegistry = new Hashtable<String, String>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("graphtypes")) {
            this.registerGraphType(contribution);
        } else if (extensionPoint.equals("graphs")) {
            this.registerGraph(contribution);
        } else if (extensionPoint.equals("resourceadapters")) {
            this.registerResourceAdapter(contribution);
        } else {
            log.error((Object)String.format("Unknown extension point %s, can't register !", extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("graphtypes")) {
            this.unregisterGraphType(contribution);
        } else if (extensionPoint.equals("graphs")) {
            this.unregisterGraph(contribution);
        } else if (extensionPoint.equals("resourceadapters")) {
            this.unregisterResourceAdapter(contribution);
        } else {
            log.error((Object)String.format("Unknown extension point %s, can't unregister !", extensionPoint));
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(RelationManager.class)) {
            return (T)((Object)this);
        }
        return null;
    }

    private void registerGraphType(Object contribution) {
        GraphTypeDescriptor graphTypeExtension = (GraphTypeDescriptor)contribution;
        String name = graphTypeExtension.getName();
        String className = graphTypeExtension.getClassName();
        if (this.graphTypeRegistry.containsKey(name)) {
            log.error((Object)String.format("%s already registered using %s", name, className));
        } else {
            this.graphTypeRegistry.put(name, className);
            log.info((Object)String.format("Registered graph type: %s (%s)", name, className));
        }
    }

    private void unregisterGraphType(Object contrib) {
        GraphTypeDescriptor graphTypeExtension = (GraphTypeDescriptor)contrib;
        String name = graphTypeExtension.getName();
        String className = graphTypeExtension.getClassName();
        String registeredClassName = this.graphTypeRegistry.get(name);
        if (registeredClassName == null) {
            log.error((Object)String.format("Graph type %s not found", name));
        } else if (registeredClassName != className) {
            log.error((Object)String.format("Graph type %s: wrong class", registeredClassName));
        } else {
            this.graphTypeRegistry.remove(name);
            log.debug((Object)("Unregistered graph type: " + name));
        }
    }

    public Graph getGraphByType(String graphType) {
        String className = this.graphTypeRegistry.get(graphType);
        if (className == null) {
            log.error((Object)String.format("Graph type %s not found", graphType));
            return null;
        }
        try {
            return (Graph)RelationService.class.getClassLoader().loadClass(className).newInstance();
        }
        catch (Exception e) {
            String msg = String.format("Cannot instantiate graph with type '%s': %s", graphType, e);
            log.error((Object)msg);
            return null;
        }
    }

    public List<String> getGraphTypes() {
        ArrayList<String> res = new ArrayList<String>();
        for (String type : this.graphTypeRegistry.keySet()) {
            res.add(type);
        }
        return res;
    }

    private void registerGraph(Object contribution) {
        GraphDescription graphDescription = (GraphDescription)contribution;
        String name = graphDescription.getName();
        if (this.graphDescriptionRegistry.containsKey(name)) {
            log.info((Object)String.format("Overriding graph %s definition", name));
            this.graphDescriptionRegistry.remove(name);
        }
        this.graphDescriptionRegistry.put(name, graphDescription);
        log.info((Object)String.format("Graph %s registered", name));
        this.graphRegistry.remove(name);
    }

    private void unregisterGraph(Object contribution) {
        GraphDescriptor graphExtension = (GraphDescriptor)contribution;
        String name = graphExtension.getName();
        GraphDescription registeredGraphDef = this.graphDescriptionRegistry.get(name);
        if (registeredGraphDef == null) {
            log.error((Object)String.format("Graph %s not found", name));
        } else {
            this.graphDescriptionRegistry.remove(name);
            log.info((Object)String.format("Graph %s unregistered", name));
        }
        this.graphRegistry.remove(name);
    }

    private void registerResourceAdapter(Object contribution) {
        ResourceAdapterDescriptor adapter = (ResourceAdapterDescriptor)contribution;
        String ns = adapter.getNamespace();
        String adapterClassName = adapter.getClassName();
        if (this.resourceAdapterRegistry.containsKey(ns)) {
            log.info((Object)("Overriding resource adapter config for namespace " + ns));
        }
        this.resourceAdapterRegistry.put(ns, adapterClassName);
        log.info((Object)String.format("%s namespace registered using adapter %s", ns, adapterClassName));
    }

    private void unregisterResourceAdapter(Object contribution) {
        ResourceAdapterDescriptor adapter = (ResourceAdapterDescriptor)contribution;
        String ns = adapter.getNamespace();
        String adapterClassName = adapter.getClassName();
        String registered = this.resourceAdapterRegistry.get(ns);
        if (registered == null) {
            log.error((Object)String.format("Namespace %s not found", ns));
        } else if (!registered.equals(adapterClassName)) {
            log.error((Object)String.format("Namespace %s: wrong class %s", ns, registered));
        } else {
            this.resourceAdapterRegistry.remove(ns);
            log.info((Object)String.format("%s unregistered, was using %s", ns, adapterClassName));
        }
    }

    private ResourceAdapter getResourceAdapterForNamespace(String namespace) {
        String adapterClassName = this.resourceAdapterRegistry.get(namespace);
        if (adapterClassName == null) {
            log.error((Object)String.format("Cannot find adapter for namespace: %s", namespace));
            return null;
        }
        try {
            ResourceAdapter adapter = (ResourceAdapter)RelationService.class.getClassLoader().loadClass(adapterClassName).newInstance();
            adapter.setNamespace(namespace);
            return adapter;
        }
        catch (Exception e) {
            String msg = String.format("Cannot instantiate generator with namespace '%s': %s", namespace, e);
            log.error((Object)msg);
            return null;
        }
    }

    protected Graph createGraph(String name) {
        GraphDescription graphDescription = this.graphDescriptionRegistry.get(name);
        if (graphDescription == null) {
            throw new RuntimeException(String.format("getGraphByName: %s *not found* amongst %s", name, this.graphDescriptionRegistry.keySet()));
        }
        String graphType = graphDescription.getGraphType();
        Graph graph = this.getGraphByType(graphType);
        if (graph == null) {
            throw new RuntimeException(String.format("Caught error when instanciating graph %s", name));
        }
        Map options = graphDescription.getOptions();
        Map namespaces = graphDescription.getNamespaces();
        graph.setName(name);
        graph.setOptions(options);
        graph.setNamespaces(namespaces);
        return graph;
    }

    public Graph getTransientGraph(String type) throws ClientException {
        Graph graph = this.getGraphByType(type);
        if (graph == null) {
            throw new RuntimeException(String.format("Caught error when instanciating graph %s", type));
        }
        return graph;
    }

    public synchronized Graph getGraphByName(String name) throws ClientException {
        Graph registeredGraph = this.graphRegistry.get(name);
        if (registeredGraph == null) {
            registeredGraph = this.createGraph(name);
            this.graphRegistry.put(name, registeredGraph);
        }
        return registeredGraph;
    }

    public Resource getResource(String namespace, Serializable object, Map<String, Serializable> context) throws ClientException {
        ResourceAdapter adapter = this.getResourceAdapterForNamespace(namespace);
        if (adapter == null) {
            log.error((Object)("Cannot find adapter for namespace: " + namespace));
            return null;
        }
        return adapter.getResource(object, context);
    }

    public Set<Resource> getAllResources(Serializable object, Map<String, Serializable> context) throws ClientException {
        HashSet<Resource> res = new HashSet<Resource>();
        for (String ns : this.resourceAdapterRegistry.keySet()) {
            Class klass;
            ResourceAdapter adapter = this.getResourceAdapterForNamespace(ns);
            if (adapter == null || (klass = adapter.getKlass()) == null || !klass.isAssignableFrom(object.getClass())) continue;
            res.add(adapter.getResource(object, context));
        }
        return res;
    }

    public Serializable getResourceRepresentation(String namespace, Resource resource, Map<String, Serializable> context) throws ClientException {
        ResourceAdapter adapter = this.getResourceAdapterForNamespace(namespace);
        if (adapter == null) {
            log.error((Object)("Cannot find adapter for namespace: " + namespace));
            return null;
        }
        return adapter.getResourceRepresentation(resource, context);
    }

    public void add(String graphName, List<Statement> statements) throws ClientException {
        this.getGraphByName(graphName).add(statements);
    }

    public void clear(String graphName) throws ClientException {
        this.getGraphByName(graphName).clear();
    }

    public List<Node> getObjects(String graphName, Node subject, Node predicate) throws ClientException {
        return this.getGraphByName(graphName).getObjects(subject, predicate);
    }

    public List<Node> getPredicates(String graphName, Node subject, Node object) throws ClientException {
        return this.getGraphByName(graphName).getPredicates(subject, object);
    }

    public List<Statement> getStatements(String graphName, Statement statement) throws ClientException {
        return this.getGraphByName(graphName).getStatements(statement);
    }

    public List<Statement> getStatements(String graphName) throws ClientException {
        return this.getGraphByName(graphName).getStatements();
    }

    public List<Node> getSubjects(String graphName, Node predicate, Node object) throws ClientException {
        return this.getGraphByName(graphName).getSubjects(predicate, object);
    }

    public boolean hasResource(String graphName, Resource resource) throws ClientException {
        return this.getGraphByName(graphName).hasResource(resource);
    }

    public boolean hasStatement(String graphName, Statement statement) throws ClientException {
        return this.getGraphByName(graphName).hasStatement(statement);
    }

    public QueryResult query(String graphName, String queryString, String language, String baseURI) throws ClientException {
        return this.getGraphByName(graphName).query(queryString, language, baseURI);
    }

    public boolean read(String graphName, InputStream in, String lang, String base) throws ClientException {
        return this.getGraphByName(graphName).read(in, lang, base);
    }

    public void remove(String graphName, List<Statement> statements) throws ClientException {
        this.getGraphByName(graphName).remove(statements);
    }

    public Long size(String graphName) throws ClientException {
        return this.getGraphByName(graphName).size();
    }

    public boolean write(String graphName, OutputStream out, String lang, String base) throws ClientException {
        return this.getGraphByName(graphName).write(out, lang, base);
    }

    public List<String> getGraphNames() throws ClientException {
        return new ArrayList<String>(this.graphDescriptionRegistry.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            ClassLoader jbossCL = Thread.currentThread().getContextClassLoader();
            ClassLoader nuxeoCL = RelationService.class.getClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(nuxeoCL);
                log.info((Object)"Relation Service initialization");
                for (String graphName : this.graphDescriptionRegistry.keySet()) {
                    log.info((Object)("create RDF Graph " + graphName));
                    try {
                        Graph graph = this.getGraphByName(graphName);
                        graph.size();
                    }
                    catch (Exception e) {
                        log.error((Object)("Error while initializing graph " + graphName), (Throwable)e);
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(jbossCL);
                log.debug((Object)"JBoss ClassLoader restored");
            }
        }
    }

    public void activate(ComponentContext context) throws Exception {
        if (Boolean.parseBoolean(Framework.getProperty((String)"org.nuxeo.ecm.platform.relations.initOnStartup", (String)"true"))) {
            context.getRuntimeContext().getBundle().getBundleContext().addFrameworkListener((FrameworkListener)this);
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        context.getRuntimeContext().getBundle().getBundleContext().removeFrameworkListener((FrameworkListener)this);
    }
}

