/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.ecm.platform.tag.WeightedTag;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggingHelper {
    private static final Log log = LogFactory.getLog(TaggingHelper.class);
    private TagService tagService;

    public static boolean isStringBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    public boolean isTagServiceEnabled() throws ClientException {
        return this.getTagService().isEnabled();
    }

    public void addTagging(CoreSession session, DocumentModel document, String tagLabel) throws ClientException {
        if (TaggingHelper.isStringBlank(tagLabel)) {
            log.debug((Object)"The information provided about the new tag(s) cannot be empty ...");
            return;
        }
        if (null == document) {
            throw new ClientException("Can not tag document null.");
        }
        String[] tagLabelArray = tagLabel.split(",");
        DocumentModel rootTag = this.getTagService().getRootTag(session);
        if (rootTag == null) {
            log.debug((Object)"The root tag document was not properly generated ...");
            return;
        }
        for (int i = 0; i < tagLabelArray.length; ++i) {
            String currentTagLabel = tagLabelArray[i].trim();
            if (currentTagLabel.length() <= 0) continue;
            DocumentModel tagDocument = this.getTagService().getOrCreateTag(session, rootTag, currentTagLabel, false);
            this.getTagService().tagDocument(session, document, tagDocument.getId(), false);
        }
    }

    public void removeTagging(CoreSession session, DocumentModel document, String taggingId) throws ClientException {
        if (TaggingHelper.isStringBlank(taggingId)) {
            log.debug((Object)"The taggingId cannot be empty ...");
            return;
        }
        if (null == document) {
            throw new ClientException("Can not remove tag(s) from document null.");
        }
        NuxeoPrincipal principal = (NuxeoPrincipal)session.getPrincipal();
        if (principal.isAdministrator() || session.hasPermission(document.getRef(), "Write")) {
            this.getTagService().completeUntagDocument(session, document, taggingId);
        } else {
            this.getTagService().untagDocument(session, document, taggingId);
        }
    }

    public List<Tag> listDocumentTags(CoreSession session, DocumentModel document) throws ClientException {
        if (null == document) {
            throw new ClientException("Can not list tag(s) on document null.");
        }
        return this.getTagService().listTagsAppliedOnDocument(session, document);
    }

    public List<WeightedTag> getPopularCloud(CoreSession session, DocumentModel document) throws ClientException {
        if (null == document) {
            throw new ClientException("Can not retrieve popular cloud on document null.");
        }
        return this.getTagService().getPopularCloud(session, document);
    }

    public List<WeightedTag> getPopularCloudOnAllDocuments(CoreSession session) throws ClientException {
        return this.getTagService().getPopularCloudOnAllDocuments(session);
    }

    public DocumentModelList listDocumentsForTag(CoreSession session, String tagDocumentId) throws ClientException {
        if (TaggingHelper.isStringBlank(tagDocumentId)) {
            throw new ClientException("Can not list documents for an empty tag .");
        }
        DocumentModelListImpl documentsForTag = new DocumentModelListImpl();
        List<String> docsForTag = this.getTagService().listDocumentsForTag(session, tagDocumentId, session.getPrincipal().getName());
        for (String docForTagId : docsForTag) {
            documentsForTag.add((Object)session.getDocument((DocumentRef)new IdRef(docForTagId)));
        }
        return documentsForTag;
    }

    public boolean canModifyTag(CoreSession session, DocumentModel document, Tag tag) throws ClientException {
        NuxeoPrincipal principal = (NuxeoPrincipal)session.getPrincipal();
        if (principal.isAdministrator() || session.hasPermission(document.getRef(), "Write")) {
            return true;
        }
        if (document == null || tag == null) {
            return false;
        }
        return this.getTagService().getTaggingId(session, document.getId(), tag.tagLabel, principal.getName()) != null;
    }

    private TagService getTagService() {
        if (this.tagService == null) {
            try {
                this.tagService = (TagService)Framework.getService(TagService.class);
            }
            catch (Exception e) {
                log.debug((Object)"Problems retrieving the TagService ...", (Throwable)e);
                throw new IllegalStateException("TagService service not deployed.", e);
            }
        }
        return this.tagService;
    }
}

