/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.nuxeo.ecm.platform.tag.sql.Column;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<Column> columns = new ArrayList<Column>();

    public Table(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName(Dialect dialect) {
        return dialect.openQuote() + this.name + dialect.closeQuote();
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public String getCreateSql(Dialect dialect) {
        StringBuilder buf = new StringBuilder();
        buf.append("create table");
        buf.append(' ');
        buf.append(this.name);
        buf.append(" (");
        boolean first = true;
        for (Column column : this.columns) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(column.getName());
            buf.append(' ');
            buf.append(column.getSqlTypeString(dialect));
            String defaultValue = column.getDefaultValue();
            if (defaultValue != null) {
                buf.append(" default ");
                buf.append(defaultValue);
            }
            if (column.isNullable()) {
                buf.append(dialect.getNullColumnString());
                continue;
            }
            buf.append(" not null");
        }
        buf.append(')');
        buf.append(dialect.getTableTypeString());
        return buf.toString();
    }
}

