/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relation.ejb;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QueryResult;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.ejb.RelationManagerLocal;
import org.nuxeo.ecm.platform.relations.api.ejb.RelationManagerRemote;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Local(value={RelationManagerLocal.class})
@Remote(value={RelationManagerRemote.class})
public class RelationManagerBean
implements RelationManager {
    private static final long serialVersionUID = -4778456059717447736L;
    private static final Log log = LogFactory.getLog(RelationManagerBean.class);
    private transient RelationManager service;

    @PostConstruct
    public void initialize() {
        try {
            this.service = (RelationManager)Framework.getLocalService(RelationManager.class);
        }
        catch (Exception e) {
            log.error((Object)"Could not get relation service", (Throwable)e);
        }
    }

    public void remove() {
    }

    public Graph getGraphByName(String name) throws ClientException {
        try {
            return this.service.getGraphByName(name);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public Serializable getResourceRepresentation(String namespace, Resource resource, Map<String, Serializable> context) throws ClientException {
        try {
            return this.service.getResourceRepresentation(namespace, resource, context);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public Resource getResource(String namespace, Serializable object, Map<String, Serializable> context) throws ClientException {
        try {
            return this.service.getResource(namespace, object, context);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public Set<Resource> getAllResources(Serializable object, Map<String, Serializable> context) throws ClientException {
        try {
            return this.service.getAllResources(object, context);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public List<String> getGraphNames() throws ClientException {
        try {
            return this.service.getGraphNames();
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void add(String graphName, List<Statement> statements) throws ClientException {
        try {
            this.getGraphByName(graphName).add(statements);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void clear(String graphName) throws ClientException {
        try {
            this.getGraphByName(graphName).clear();
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public List<Node> getObjects(String graphName, Node subject, Node predicate) throws ClientException {
        try {
            return this.getGraphByName(graphName).getObjects(subject, predicate);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public List<Node> getPredicates(String graphName, Node subject, Node object) throws ClientException {
        try {
            return this.getGraphByName(graphName).getPredicates(subject, object);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public List<Statement> getStatements(String graphName, Statement statement) throws ClientException {
        try {
            return this.getGraphByName(graphName).getStatements(statement);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public List<Statement> getStatements(String graphName) throws ClientException {
        try {
            return this.getGraphByName(graphName).getStatements();
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public List<Node> getSubjects(String graphName, Node predicate, Node object) throws ClientException {
        try {
            return this.getGraphByName(graphName).getSubjects(predicate, object);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public boolean hasResource(String graphName, Resource resource) throws ClientException {
        try {
            return this.getGraphByName(graphName).hasResource(resource);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public boolean hasStatement(String graphName, Statement statement) throws ClientException {
        try {
            return this.getGraphByName(graphName).hasStatement(statement);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public QueryResult query(String graphName, String queryString, String language, String baseURI) throws ClientException {
        try {
            return this.getGraphByName(graphName).query(queryString, language, baseURI);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public boolean read(String graphName, InputStream in, String lang, String base) throws ClientException {
        try {
            return this.getGraphByName(graphName).read(in, lang, base);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void remove(String graphName, List<Statement> statements) throws ClientException {
        try {
            this.getGraphByName(graphName).remove(statements);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public Long size(String graphName) throws ClientException {
        try {
            return this.getGraphByName(graphName).size();
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public boolean write(String graphName, OutputStream out, String lang, String base) throws ClientException {
        try {
            return this.getGraphByName(graphName).write(out, lang, base);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public Graph getTransientGraph(String type) throws ClientException {
        return this.service.getTransientGraph(type);
    }
}

