/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.constants.NumberConstants;
import com.google.gwt.i18n.client.impl.CurrencyData;
import com.google.gwt.i18n.client.impl.CurrencyList;

public class NumberFormat {
    private static final NumberConstants defaultNumberConstants = (NumberConstants)GWT.create(NumberConstants.class);
    private static final char PATTERN_ZERO_DIGIT = '0';
    private static final char PATTERN_GROUPING_SEPARATOR = ',';
    private static final char PATTERN_DECIMAL_SEPARATOR = '.';
    private static final char PATTERN_PER_MILLE = '\u2030';
    private static final char PATTERN_PERCENT = '%';
    private static final char PATTERN_DIGIT = '#';
    private static final char PATTERN_SEPARATOR = ';';
    private static final char PATTERN_EXPONENT = 'E';
    private static final char PATTERN_MINUS = '-';
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char QUOTE = '\'';
    private static NumberFormat cachedDecimalFormat;
    private static NumberFormat cachedScientificFormat;
    private static NumberFormat cachedPercentFormat;
    private static NumberFormat cachedCurrencyFormat;
    private final NumberConstants numberConstants;
    private int maximumIntegerDigits = 40;
    private int minimumIntegerDigits = 1;
    private int maximumFractionDigits = 3;
    private int minimumFractionDigits = 0;
    private int minExponentDigits;
    private String positivePrefix = "";
    private String positiveSuffix = "";
    private String negativePrefix = "-";
    private String negativeSuffix = "";
    private int multiplier = 1;
    private int groupingSize = 3;
    private boolean decimalSeparatorAlwaysShown = false;
    private boolean isCurrencyFormat = false;
    private boolean useExponentialNotation = false;
    private final String currencySymbol;
    private final String currencyCode;
    private final String pattern;

    public static NumberFormat getCurrencyFormat() {
        if (cachedCurrencyFormat == null) {
            cachedCurrencyFormat = new NumberFormat(defaultNumberConstants.currencyPattern(), CurrencyList.get().getDefault(), false);
        }
        return cachedCurrencyFormat;
    }

    public static NumberFormat getCurrencyFormat(String currencyCode) {
        return new NumberFormat(defaultNumberConstants.currencyPattern(), CurrencyList.get().lookup(currencyCode), false);
    }

    public static NumberFormat getDecimalFormat() {
        if (cachedDecimalFormat == null) {
            cachedDecimalFormat = new NumberFormat(defaultNumberConstants.decimalPattern(), CurrencyList.get().getDefault(), false);
        }
        return cachedDecimalFormat;
    }

    public static NumberFormat getFormat(String pattern) {
        return new NumberFormat(pattern, CurrencyList.get().getDefault(), true);
    }

    public static NumberFormat getFormat(String pattern, String currencyCode) {
        return new NumberFormat(pattern, CurrencyList.get().lookup(currencyCode), true);
    }

    public static NumberFormat getPercentFormat() {
        if (cachedPercentFormat == null) {
            cachedPercentFormat = new NumberFormat(defaultNumberConstants.percentPattern(), CurrencyList.get().getDefault(), false);
        }
        return cachedPercentFormat;
    }

    public static NumberFormat getScientificFormat() {
        if (cachedScientificFormat == null) {
            cachedScientificFormat = new NumberFormat(defaultNumberConstants.scientificPattern(), CurrencyList.get().getDefault(), false);
        }
        return cachedScientificFormat;
    }

    protected NumberFormat(NumberConstants numberConstants, String pattern, CurrencyData cdata, boolean userSuppliedPattern) {
        if (cdata == null) {
            throw new IllegalArgumentException("Unknown currency code");
        }
        this.numberConstants = numberConstants;
        this.pattern = pattern;
        this.currencyCode = cdata.getCurrencyCode();
        this.currencySymbol = cdata.getCurrencySymbol();
        this.parsePattern(this.pattern);
        if (!userSuppliedPattern && this.isCurrencyFormat) {
            this.maximumFractionDigits = this.minimumFractionDigits = cdata.getDefaultFractionDigits();
        }
    }

    protected NumberFormat(String pattern, CurrencyData cdata, boolean userSuppliedPattern) {
        this(defaultNumberConstants, pattern, cdata, userSuppliedPattern);
    }

    public String format(double number) {
        StringBuffer result = new StringBuffer();
        if (Double.isNaN(number)) {
            result.append(this.numberConstants.notANumber());
            return result.toString();
        }
        boolean isNegative = number < 0.0 || number == 0.0 && 1.0 / number < 0.0;
        result.append(isNegative ? this.negativePrefix : this.positivePrefix);
        if (Double.isInfinite(number)) {
            result.append(this.numberConstants.infinity());
        } else {
            if (isNegative) {
                number = -number;
            }
            number *= (double)this.multiplier;
            if (this.useExponentialNotation) {
                this.subformatExponential(number, result);
            } else {
                this.subformatFixed(number, result, this.minimumIntegerDigits);
            }
        }
        result.append(isNegative ? this.negativeSuffix : this.positiveSuffix);
        return result.toString();
    }

    public String getPattern() {
        return this.pattern;
    }

    public double parse(String text) throws NumberFormatException {
        int[] pos = new int[]{0};
        double result = this.parse(text, pos);
        if (pos[0] == 0 || pos[0] != text.length()) {
            throw new NumberFormatException(text);
        }
        return result;
    }

    public double parse(String text, int[] inOutPos) throws NumberFormatException {
        boolean gotNegative;
        int start = inOutPos[0];
        double ret = 0.0;
        boolean gotPositivePrefix = text.startsWith(this.positivePrefix, inOutPos[0]);
        boolean gotNegativePrefix = text.startsWith(this.negativePrefix, inOutPos[0]);
        boolean gotPositiveSuffix = text.endsWith(this.positiveSuffix);
        boolean gotNegativeSuffix = text.endsWith(this.negativeSuffix);
        boolean gotPositive = gotPositivePrefix && gotPositiveSuffix;
        boolean bl = gotNegative = gotNegativePrefix && gotNegativeSuffix;
        if (gotPositive && gotNegative) {
            if (this.positivePrefix.length() > this.negativePrefix.length()) {
                gotNegative = false;
            } else if (this.positivePrefix.length() < this.negativePrefix.length()) {
                gotPositive = false;
            } else if (this.positiveSuffix.length() > this.negativeSuffix.length()) {
                gotNegative = false;
            } else if (this.positiveSuffix.length() < this.negativeSuffix.length()) {
                gotPositive = false;
            } else {
                gotNegative = false;
            }
        } else if (!gotPositive && !gotNegative) {
            throw new NumberFormatException(text + " does not have either positive or negative affixes");
        }
        String valueOnly = null;
        if (gotPositive) {
            inOutPos[0] = inOutPos[0] + this.positivePrefix.length();
            valueOnly = text.substring(inOutPos[0], text.length() - this.positiveSuffix.length());
        } else {
            inOutPos[0] = inOutPos[0] + this.negativePrefix.length();
            valueOnly = text.substring(inOutPos[0], text.length() - this.negativeSuffix.length());
        }
        if (valueOnly.equals(this.numberConstants.infinity())) {
            inOutPos[0] = inOutPos[0] + this.numberConstants.infinity().length();
            ret = Double.POSITIVE_INFINITY;
        } else if (valueOnly.equals(this.numberConstants.notANumber())) {
            inOutPos[0] = inOutPos[0] + this.numberConstants.notANumber().length();
            ret = Double.NaN;
        } else {
            int[] tempPos = new int[]{0};
            ret = this.parseNumber(valueOnly, tempPos);
            inOutPos[0] = inOutPos[0] + tempPos[0];
        }
        if (gotPositive) {
            inOutPos[0] = inOutPos[0] + this.positiveSuffix.length();
        } else if (gotNegative) {
            inOutPos[0] = inOutPos[0] + this.negativeSuffix.length();
        }
        if (gotNegative) {
            ret = -ret;
        }
        return ret;
    }

    private void addExponentPart(int exponent, StringBuffer result) {
        int len;
        result.append(this.numberConstants.exponentialSymbol());
        if (exponent < 0) {
            exponent = -exponent;
            result.append(this.numberConstants.minusSign());
        }
        String exponentDigits = String.valueOf(exponent);
        for (int i = len = exponentDigits.length(); i < this.minExponentDigits; ++i) {
            result.append(this.numberConstants.zeroDigit());
        }
        int zeroDelta = this.numberConstants.zeroDigit().charAt(0) - 48;
        for (int i = 0; i < len; ++i) {
            result.append((char)(exponentDigits.charAt(i) + zeroDelta));
        }
    }

    private int getDigit(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        char zeroChar = this.numberConstants.zeroDigit().charAt(0);
        return zeroChar <= ch && ch <= zeroChar + 9 ? ch - zeroChar : -1;
    }

    private String makeIntString(double number) {
        String intPart = String.valueOf(number);
        if (GWT.isScript()) {
            return intPart;
        }
        int digitLen = intPart.length();
        if (intPart.charAt(digitLen - 2) == '.') {
            return intPart.substring(0, digitLen - 2);
        }
        int radix = intPart.indexOf(46);
        int exp = intPart.indexOf(69);
        int digits = 0;
        for (int i = exp + 1; i < intPart.length(); ++i) {
            digits = digits * 10 + (intPart.charAt(i) - 48);
        }
        ++digits;
        StringBuffer newIntPart = new StringBuffer();
        newIntPart.append(intPart.substring(0, radix));
        newIntPart.append(intPart.substring(radix + 1, exp));
        while (newIntPart.length() < digits) {
            newIntPart.append('0');
        }
        newIntPart.setLength(digits);
        return newIntPart.toString();
    }

    private int parseAffix(String pattern, int start, StringBuffer affix, boolean inNegativePattern) {
        affix.delete(0, affix.length());
        boolean inQuote = false;
        int len = pattern.length();
        block7: for (int pos = start; pos < len; ++pos) {
            char ch = pattern.charAt(pos);
            if (ch == '\'') {
                if (pos + 1 < len && pattern.charAt(pos + 1) == '\'') {
                    ++pos;
                    affix.append("'");
                    continue;
                }
                inQuote = !inQuote;
                continue;
            }
            if (inQuote) {
                affix.append(ch);
                continue;
            }
            switch (ch) {
                case '#': 
                case ',': 
                case '.': 
                case '0': 
                case ';': {
                    return pos - start;
                }
                case '\u00a4': {
                    this.isCurrencyFormat = true;
                    if (pos + 1 < len && pattern.charAt(pos + 1) == '\u00a4') {
                        ++pos;
                        affix.append(this.currencyCode);
                        continue block7;
                    }
                    affix.append(this.currencySymbol);
                    continue block7;
                }
                case '%': {
                    if (!inNegativePattern) {
                        if (this.multiplier != 1) {
                            throw new IllegalArgumentException("Too many percent/per mille characters in pattern \"" + pattern + '\"');
                        }
                        this.multiplier = 100;
                    }
                    affix.append(this.numberConstants.percent());
                    continue block7;
                }
                case '\u2030': {
                    if (!inNegativePattern) {
                        if (this.multiplier != 1) {
                            throw new IllegalArgumentException("Too many percent/per mille characters in pattern \"" + pattern + '\"');
                        }
                        this.multiplier = 1000;
                    }
                    affix.append(this.numberConstants.perMill());
                    continue block7;
                }
                case '-': {
                    affix.append("-");
                    continue block7;
                }
                default: {
                    affix.append(ch);
                }
            }
        }
        return len - start;
    }

    private double parseNumber(String text, int[] pos) {
        boolean sawDecimal = false;
        boolean sawExponent = false;
        boolean sawDigit = false;
        int scale = 1;
        String decimal = this.isCurrencyFormat ? this.numberConstants.monetarySeparator() : this.numberConstants.decimalSeparator();
        String grouping = this.isCurrencyFormat ? this.numberConstants.monetaryGroupingSeparator() : this.numberConstants.groupingSeparator();
        String exponentChar = this.numberConstants.exponentialSymbol();
        StringBuffer normalizedText = new StringBuffer();
        while (pos[0] < text.length()) {
            char ch = text.charAt(pos[0]);
            int digit = this.getDigit(ch);
            if (digit >= 0 && digit <= 9) {
                normalizedText.append((char)(digit + 48));
                sawDigit = true;
            } else if (ch == decimal.charAt(0)) {
                if (sawDecimal || sawExponent) break;
                normalizedText.append('.');
                sawDecimal = true;
            } else if (ch == grouping.charAt(0)) {
                if (sawDecimal || sawExponent) {
                    break;
                }
            } else if (ch == exponentChar.charAt(0)) {
                if (sawExponent) break;
                normalizedText.append('E');
                sawExponent = true;
            } else if (ch == '+' || ch == '-') {
                normalizedText.append(ch);
            } else if (ch == this.numberConstants.percent().charAt(0)) {
                if (scale != 1) break;
                scale = 100;
                if (sawDigit) {
                    pos[0] = pos[0] + 1;
                    break;
                }
            } else {
                if (ch != this.numberConstants.perMill().charAt(0) || scale != 1) break;
                scale = 1000;
                if (sawDigit) {
                    pos[0] = pos[0] + 1;
                    break;
                }
            }
            pos[0] = pos[0] + 1;
        }
        double ret = Double.parseDouble(normalizedText.toString());
        return ret /= (double)scale;
    }

    private void parsePattern(String pattern) {
        int pos = 0;
        StringBuffer affix = new StringBuffer();
        pos += this.parseAffix(pattern, pos, affix, false);
        this.positivePrefix = affix.toString();
        pos += this.parseTrunk(pattern, pos, false);
        pos += this.parseAffix(pattern, pos, affix, false);
        this.positiveSuffix = affix.toString();
        if (pos < pattern.length() && pattern.charAt(pos) == ';') {
            ++pos;
            pos += this.parseAffix(pattern, pos, affix, true);
            this.negativePrefix = affix.toString();
            pos += this.parseTrunk(pattern, pos, true);
            pos += this.parseAffix(pattern, pos, affix, true);
            this.negativeSuffix = affix.toString();
        } else {
            this.negativePrefix = this.numberConstants.minusSign() + this.positivePrefix;
            this.negativeSuffix = this.positiveSuffix;
        }
    }

    private int parseTrunk(String pattern, int start, boolean ignorePattern) {
        int pos;
        int decimalPos = -1;
        int digitLeftCount = 0;
        int zeroDigitCount = 0;
        int digitRightCount = 0;
        int groupingCount = -1;
        int len = pattern.length();
        boolean loop = true;
        block7: for (pos = start; pos < len && loop; ++pos) {
            char ch = pattern.charAt(pos);
            switch (ch) {
                case '#': {
                    if (zeroDigitCount > 0) {
                        ++digitRightCount;
                    } else {
                        ++digitLeftCount;
                    }
                    if (groupingCount < 0 || decimalPos >= 0) continue block7;
                    groupingCount = (byte)(groupingCount + 1);
                    continue block7;
                }
                case '0': {
                    if (digitRightCount > 0) {
                        throw new IllegalArgumentException("Unexpected '0' in pattern \"" + pattern + '\"');
                    }
                    ++zeroDigitCount;
                    if (groupingCount < 0 || decimalPos >= 0) continue block7;
                    groupingCount = (byte)(groupingCount + 1);
                    continue block7;
                }
                case ',': {
                    groupingCount = 0;
                    continue block7;
                }
                case '.': {
                    if (decimalPos >= 0) {
                        throw new IllegalArgumentException("Multiple decimal separators in pattern \"" + pattern + '\"');
                    }
                    decimalPos = digitLeftCount + zeroDigitCount + digitRightCount;
                    continue block7;
                }
                case 'E': {
                    if (!ignorePattern) {
                        if (this.useExponentialNotation) {
                            throw new IllegalArgumentException("Multiple exponential symbols in pattern \"" + pattern + '\"');
                        }
                        this.useExponentialNotation = true;
                        this.minExponentDigits = 0;
                    }
                    while (pos + 1 < len && pattern.charAt(pos + 1) == '0') {
                        ++pos;
                        if (ignorePattern) continue;
                        ++this.minExponentDigits;
                    }
                    if (!ignorePattern && digitLeftCount + zeroDigitCount < 1 || this.minExponentDigits < 1) {
                        throw new IllegalArgumentException("Malformed exponential pattern \"" + pattern + '\"');
                    }
                    loop = false;
                    continue block7;
                }
                default: {
                    --pos;
                    loop = false;
                }
            }
        }
        if (zeroDigitCount == 0 && digitLeftCount > 0 && decimalPos >= 0) {
            int n = decimalPos;
            if (n == 0) {
                ++n;
            }
            digitRightCount = digitLeftCount - n;
            digitLeftCount = n - 1;
            zeroDigitCount = 1;
        }
        if (decimalPos < 0 && digitRightCount > 0 || decimalPos >= 0 && (decimalPos < digitLeftCount || decimalPos > digitLeftCount + zeroDigitCount) || groupingCount == 0) {
            throw new IllegalArgumentException("Malformed pattern \"" + pattern + '\"');
        }
        if (ignorePattern) {
            return pos - start;
        }
        int totalDigits = digitLeftCount + zeroDigitCount + digitRightCount;
        int n = this.maximumFractionDigits = decimalPos >= 0 ? totalDigits - decimalPos : 0;
        if (decimalPos >= 0) {
            this.minimumFractionDigits = digitLeftCount + zeroDigitCount - decimalPos;
            if (this.minimumFractionDigits < 0) {
                this.minimumFractionDigits = 0;
            }
        }
        int effectiveDecimalPos = decimalPos >= 0 ? decimalPos : totalDigits;
        this.minimumIntegerDigits = effectiveDecimalPos - digitLeftCount;
        if (this.useExponentialNotation) {
            this.maximumIntegerDigits = digitLeftCount + this.minimumIntegerDigits;
            if (this.maximumFractionDigits == 0 && this.minimumIntegerDigits == 0) {
                this.minimumIntegerDigits = 1;
            }
        }
        this.groupingSize = groupingCount > 0 ? groupingCount : 0;
        this.decimalSeparatorAlwaysShown = decimalPos == 0 || decimalPos == totalDigits;
        return pos - start;
    }

    private void subformatExponential(double number, StringBuffer result) {
        if (number == 0.0) {
            this.subformatFixed(number, result, this.minimumIntegerDigits);
            this.addExponentPart(0, result);
            return;
        }
        int exponent = (int)Math.floor(Math.log(number) / Math.log(10.0));
        number /= Math.pow(10.0, exponent);
        int minIntDigits = this.minimumIntegerDigits;
        if (this.maximumIntegerDigits > 1 && this.maximumIntegerDigits > this.minimumIntegerDigits) {
            while (exponent % this.maximumIntegerDigits != 0) {
                number *= 10.0;
                --exponent;
            }
            minIntDigits = 1;
        } else if (this.minimumIntegerDigits < 1) {
            ++exponent;
            number /= 10.0;
        } else {
            for (int i = 1; i < this.minimumIntegerDigits; ++i) {
                --exponent;
                number *= 10.0;
            }
        }
        this.subformatFixed(number, result, minIntDigits);
        this.addExponentPart(exponent, result);
    }

    private void subformatFixed(double number, StringBuffer result, int minIntDigits) {
        int fracLen;
        double power = Math.pow(10.0, this.maximumFractionDigits);
        double intValue = Math.floor(number);
        double fracValue = Math.floor((number - intValue) * power + 0.5);
        if (fracValue >= power) {
            intValue += 1.0;
            fracValue -= power;
        }
        boolean fractionPresent = this.minimumFractionDigits > 0 || fracValue > 0.0;
        String intPart = this.makeIntString(intValue);
        String grouping = this.isCurrencyFormat ? this.numberConstants.monetaryGroupingSeparator() : this.numberConstants.groupingSeparator();
        String decimal = this.isCurrencyFormat ? this.numberConstants.monetarySeparator() : this.numberConstants.decimalSeparator();
        int zeroDelta = this.numberConstants.zeroDigit().charAt(0) - 48;
        int digitLen = intPart.length();
        if (intValue > 0.0 || minIntDigits > 0) {
            int i;
            for (i = digitLen; i < minIntDigits; ++i) {
                result.append(this.numberConstants.zeroDigit());
            }
            for (i = 0; i < digitLen; ++i) {
                result.append((char)(intPart.charAt(i) + zeroDelta));
                if (digitLen - i <= 1 || this.groupingSize <= 0 || (digitLen - i) % this.groupingSize != 1) continue;
                result.append(grouping);
            }
        } else if (!fractionPresent) {
            result.append(this.numberConstants.zeroDigit());
        }
        if (this.decimalSeparatorAlwaysShown || fractionPresent) {
            result.append(decimal);
        }
        String fracPart = this.makeIntString(Math.floor(fracValue + power + 0.5));
        for (fracLen = fracPart.length(); fracPart.charAt(fracLen - 1) == '0' && fracLen > this.minimumFractionDigits + 1; --fracLen) {
        }
        for (int i = 1; i < fracLen; ++i) {
            result.append((char)(fracPart.charAt(i) + zeroDelta));
        }
    }
}

