/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Accessibility;
import com.google.gwt.user.client.ui.ButtonBase;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.UIObject;

public abstract class CustomButton
extends ButtonBase {
    private static final String STYLENAME_DEFAULT = "gwt-CustomButton";
    private static final int DOWN_ATTRIBUTE = 1;
    private static final int HOVERING_ATTRIBUTE = 2;
    private static final int DISABLED_ATTRIBUTE = 4;
    private static final int UP = 0;
    private static final int DOWN = 1;
    private static final int UP_HOVERING = 2;
    private static final int DOWN_HOVERING = 3;
    private static final int UP_DISABLED = 4;
    private static final int DOWN_DISABLED = 5;
    private Element curFaceElement;
    private Face curFace;
    private Face up;
    private Face down;
    private Face downHovering;
    private Face upHovering;
    private Face upDisabled;
    private Face downDisabled;
    private boolean isCapturing;
    private boolean isFocusing;

    public CustomButton(Image upImage) {
        this();
        this.getUpFace().setImage(upImage);
    }

    public CustomButton(Image upImage, Image downImage) {
        this(upImage);
        this.getDownFace().setImage(downImage);
    }

    public CustomButton(Image upImage, Image downImage, ClickListener listener) {
        this(upImage, listener);
        this.getDownFace().setImage(downImage);
    }

    public CustomButton(Image upImage, ClickListener listener) {
        this(upImage);
        this.addClickListener(listener);
    }

    public CustomButton(String upText) {
        this();
        this.getUpFace().setText(upText);
    }

    public CustomButton(String upText, ClickListener listener) {
        this(upText);
        this.addClickListener(listener);
    }

    public CustomButton(String upText, String downText) {
        this(upText);
        this.getDownFace().setText(downText);
    }

    public CustomButton(String upText, String downText, ClickListener listener) {
        this(upText, downText);
        this.addClickListener(listener);
    }

    protected CustomButton() {
        super(FocusPanel.impl.createFocusable());
        this.sinkEvents(7165);
        this.setUpFace(this.createFace(null, "up", 0));
        this.setStyleName(STYLENAME_DEFAULT);
        Accessibility.setRole(this.getElement(), "button");
    }

    public final Face getDownDisabledFace() {
        if (this.downDisabled == null) {
            this.setDownDisabledFace(this.createFace(this.getDownFace(), "down-disabled", 5));
        }
        return this.downDisabled;
    }

    public final Face getDownFace() {
        if (this.down == null) {
            this.setDownFace(this.createFace(this.getUpFace(), "down", 1));
        }
        return this.down;
    }

    public final Face getDownHoveringFace() {
        if (this.downHovering == null) {
            this.setDownHoveringFace(this.createFace(this.getDownFace(), "down-hovering", 3));
        }
        return this.downHovering;
    }

    public String getHTML() {
        return this.getCurrentFace().getHTML();
    }

    public int getTabIndex() {
        return FocusPanel.impl.getTabIndex(this.getElement());
    }

    public String getText() {
        return this.getCurrentFace().getText();
    }

    public final Face getUpDisabledFace() {
        if (this.upDisabled == null) {
            this.setUpDisabledFace(this.createFace(this.getUpFace(), "up-disabled", 4));
        }
        return this.upDisabled;
    }

    public final Face getUpFace() {
        return this.up;
    }

    public final Face getUpHoveringFace() {
        if (this.upHovering == null) {
            this.setUpHoveringFace(this.createFace(this.getUpFace(), "up-hovering", 2));
        }
        return this.upHovering;
    }

    public void onBrowserEvent(Event event) {
        if (!this.isEnabled()) {
            return;
        }
        int type = DOM.eventGetType(event);
        switch (type) {
            case 4: {
                if (event.getButton() != 1) break;
                this.setFocus(true);
                this.onClickStart();
                DOM.setCapture(this.getElement());
                this.isCapturing = true;
                DOM.eventPreventDefault(event);
                break;
            }
            case 8: {
                if (!this.isCapturing) break;
                this.isCapturing = false;
                DOM.releaseCapture(this.getElement());
                if (!this.isHovering() || event.getButton() != 1) break;
                this.onClick();
                break;
            }
            case 64: {
                if (!this.isCapturing) break;
                DOM.eventPreventDefault(event);
                break;
            }
            case 32: {
                Element to = DOM.eventGetToElement(event);
                if (!DOM.isOrHasChild(this.getElement(), DOM.eventGetTarget(event)) || to != null && DOM.isOrHasChild(this.getElement(), to)) break;
                if (this.isCapturing) {
                    this.onClickCancel();
                }
                this.setHovering(false);
                break;
            }
            case 16: {
                if (!DOM.isOrHasChild(this.getElement(), DOM.eventGetTarget(event))) break;
                this.setHovering(true);
                if (!this.isCapturing) break;
                this.onClickStart();
                break;
            }
            case 1: {
                return;
            }
            case 4096: {
                if (!this.isFocusing) break;
                this.isFocusing = false;
                this.onClickCancel();
                break;
            }
            case 8192: {
                if (!this.isCapturing) break;
                this.isCapturing = false;
                this.onClickCancel();
            }
        }
        super.onBrowserEvent(event);
        if ((event.getTypeInt() & 0x380) != 0) {
            char keyCode = (char)DOM.eventGetKeyCode(event);
            switch (type) {
                case 128: {
                    if (keyCode != ' ') break;
                    this.isFocusing = true;
                    this.onClickStart();
                    break;
                }
                case 512: {
                    if (!this.isFocusing || keyCode != ' ') break;
                    this.isFocusing = false;
                    this.onClick();
                    break;
                }
                case 256: {
                    if (keyCode != '\n' && keyCode != '\r') break;
                    this.onClickStart();
                    this.onClick();
                }
            }
        }
    }

    public void setAccessKey(char key) {
        FocusPanel.impl.setAccessKey(this.getElement(), key);
    }

    public final void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            this.toggleDisabled();
            super.setEnabled(enabled);
            if (!enabled) {
                this.cleanupCaptureState();
            }
        }
    }

    public void setFocus(boolean focused) {
        if (focused) {
            FocusPanel.impl.focus(this.getElement());
        } else {
            FocusPanel.impl.blur(this.getElement());
        }
    }

    public void setHTML(String html) {
        this.getCurrentFace().setHTML(html);
    }

    public void setTabIndex(int index) {
        FocusPanel.impl.setTabIndex(this.getElement(), index);
    }

    public void setText(String text) {
        this.getCurrentFace().setText(text);
    }

    protected boolean isDown() {
        return (1 & this.getCurrentFace().getFaceID()) > 0;
    }

    protected void onAttach() {
        this.finishSetup();
        super.onAttach();
    }

    protected void onClick() {
        this.fireClickListeners();
    }

    protected void onClickCancel() {
    }

    protected void onClickStart() {
    }

    protected void onDetach() {
        super.onDetach();
        this.cleanupCaptureState();
    }

    protected void setDown(boolean down) {
        if (down != this.isDown()) {
            this.toggleDown();
        }
    }

    void finishSetup() {
        if (this.curFace == null) {
            this.setCurrentFace(this.getUpFace());
        }
    }

    Face getCurrentFace() {
        this.finishSetup();
        return this.curFace;
    }

    final boolean isHovering() {
        return (2 & this.getCurrentFace().getFaceID()) > 0;
    }

    void setCurrentFace(Face newFace) {
        if (this.curFace != newFace) {
            if (this.curFace != null) {
                this.removeStyleDependentName(this.curFace.getName());
            }
            this.curFace = newFace;
            this.setCurrentFaceElement(newFace.getFace());
            this.addStyleDependentName(this.curFace.getName());
        }
    }

    final void setHovering(boolean hovering) {
        if (hovering != this.isHovering()) {
            this.toggleHover();
        }
    }

    void toggleDown() {
        int newFaceID = this.getCurrentFace().getFaceID() ^ 1;
        this.setCurrentFace(newFaceID);
    }

    private void cleanupCaptureState() {
        if (this.isCapturing || this.isFocusing) {
            DOM.releaseCapture(this.getElement());
            this.isCapturing = false;
            this.isFocusing = false;
            this.onClickCancel();
        }
    }

    private Face createFace(Face delegateTo, final String name, final int faceID) {
        return new Face(delegateTo){

            public String getName() {
                return name;
            }

            int getFaceID() {
                return faceID;
            }
        };
    }

    private Face getFaceFromID(int id) {
        switch (id) {
            case 1: {
                return this.getDownFace();
            }
            case 0: {
                return this.getUpFace();
            }
            case 3: {
                return this.getDownHoveringFace();
            }
            case 2: {
                return this.getUpHoveringFace();
            }
            case 4: {
                return this.getUpDisabledFace();
            }
            case 5: {
                return this.getDownDisabledFace();
            }
        }
        throw new IllegalStateException(id + " is not a known face id.");
    }

    private void setCurrentFace(int faceID) {
        Face newFace = this.getFaceFromID(faceID);
        this.setCurrentFace(newFace);
    }

    private void setCurrentFaceElement(Element newFaceElement) {
        if (this.curFaceElement != newFaceElement) {
            if (this.curFaceElement != null) {
                DOM.removeChild(this.getElement(), this.curFaceElement);
            }
            this.curFaceElement = newFaceElement;
            DOM.appendChild(this.getElement(), this.curFaceElement);
        }
    }

    private void setDownDisabledFace(Face downDisabled) {
        this.downDisabled = downDisabled;
    }

    private void setDownFace(Face down) {
        this.down = down;
    }

    private void setDownHoveringFace(Face downHovering) {
        this.downHovering = downHovering;
    }

    private void setUpDisabledFace(Face upDisabled) {
        this.upDisabled = upDisabled;
    }

    private void setUpFace(Face up) {
        this.up = up;
    }

    private void setUpHoveringFace(Face upHovering) {
        this.upHovering = upHovering;
    }

    private void toggleDisabled() {
        int newFaceID = this.getCurrentFace().getFaceID() ^ 4;
        this.setCurrentFace(newFaceID &= 0xFFFFFFFD);
    }

    private void toggleHover() {
        int newFaceID = this.getCurrentFace().getFaceID() ^ 2;
        this.setCurrentFace(newFaceID &= 0xFFFFFFFB);
    }

    public abstract class Face
    implements HasHTML,
    HasText {
        private static final String STYLENAME_HTML_FACE = "html-face";
        private final Face delegateTo;
        private Element face;

        private Face(Face delegateTo) {
            this.delegateTo = delegateTo;
        }

        public String getHTML() {
            return DOM.getInnerHTML(this.getFace());
        }

        public String getText() {
            return DOM.getInnerText(this.getFace());
        }

        public void setHTML(String html) {
            this.face = DOM.createDiv();
            UIObject.setStyleName(this.face, STYLENAME_HTML_FACE, true);
            DOM.setInnerHTML(this.face, html);
            this.updateButtonFace();
        }

        public final void setImage(Image image) {
            this.face = image.getElement();
            this.updateButtonFace();
        }

        public final void setText(String text) {
            this.face = DOM.createDiv();
            UIObject.setStyleName(this.face, STYLENAME_HTML_FACE, true);
            DOM.setInnerText(this.face, text);
            this.updateButtonFace();
        }

        public final String toString() {
            return this.getName();
        }

        abstract int getFaceID();

        abstract String getName();

        private Element getFace() {
            if (this.face == null) {
                if (this.delegateTo == null) {
                    this.face = DOM.createDiv();
                    return this.face;
                }
                return this.delegateTo.getFace();
            }
            return this.face;
        }

        private void updateButtonFace() {
            if (CustomButton.this.curFace != null && CustomButton.this.curFace.getFace() == this.getFace()) {
                CustomButton.this.setCurrentFaceElement(this.face);
            }
        }
    }
}

