/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.gadgets;

import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.IllegalParameterException;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;

@WebObject(type="GadgetDocument")
@Produces(value={"application/octet-stream"})
public class GadgetDocument
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(GadgetDocument.class);

    @GET
    public Object noRootRessource() {
        return Response.serverError();
    }

    @GET
    @Path(value="/getFile/{gadgetid}")
    public Response getFile(@PathParam(value="gadgetid") String id) {
        CoreSession session = this.ctx.getCoreSession();
        try {
            StringTokenizer st = new StringTokenizer(id, ".");
            IdRef ref = new IdRef(st.nextToken());
            if (session.exists((DocumentRef)ref)) {
                DocumentModel doc = session.getDocument((DocumentRef)ref);
                FormData form = this.ctx.getForm();
                String xpath = form.getString("property");
                if (xpath == null) {
                    if (doc.hasSchema("file")) {
                        xpath = "file:content";
                    } else {
                        throw new IllegalParameterException("Missing request parameter named 'property' that specify the blob property xpath to fetch");
                    }
                }
                try {
                    Property p = doc.getProperty(xpath);
                    Blob blob = (Blob)p.getValue();
                    if (blob == null) {
                        throw new WebResourceNotFoundException("No attached file at " + xpath);
                    }
                    String fileName = blob.getFilename();
                    if (fileName == null && (p = p.getParent()).isComplex()) {
                        try {
                            fileName = (String)((Object)p.getValue("filename"));
                        }
                        catch (PropertyException e) {
                            fileName = "Unknown";
                        }
                    }
                    return Response.ok((Object)blob).header("Content-Disposition", (Object)("attachment;filename=" + fileName)).type(blob.getMimeType()).build();
                }
                catch (Exception e) {
                    throw WebException.wrap((String)"Failed to get the attached file", (Throwable)e);
                }
            }
            return Response.status((int)404).build();
        }
        catch (ClientException e) {
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/setFile/{gadgetid}")
    public Response setFile(@PathParam(value="gadgetid") String id) {
        CoreSession session = this.ctx.getCoreSession();
        IdRef ref = new IdRef(id);
        try {
            if (session.exists((DocumentRef)ref)) {
                Blob blob;
                DocumentModel doc = session.getDocument((DocumentRef)ref);
                FormData form = this.ctx.getForm();
                form.fillDocument(doc);
                String xpath = this.ctx.getForm().getString("property");
                if (xpath == null) {
                    if (doc.hasSchema("file")) {
                        xpath = "file:content";
                    } else {
                        throw new IllegalArgumentException("Missing request parameter named 'property' that specifies the blob property xpath to fetch");
                    }
                }
                if ((blob = form.getFirstBlob()) == null) {
                    throw new IllegalArgumentException("Could not find any uploaded file");
                }
                try {
                    Property p = doc.getProperty(xpath);
                    if (p.isList()) {
                        if ("files".equals(p.getSchema().getName())) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("filename", blob.getFilename());
                            map.put("file", (Serializable)blob);
                            p.add(map);
                        } else {
                            p.add((Object)blob);
                        }
                    } else {
                        if ("file".equals(p.getSchema().getName())) {
                            p.getParent().get("filename").setValue((Object)blob.getFilename());
                        }
                        p.setValue((Object)blob);
                    }
                    session.saveDocument(doc);
                    session.save();
                    return Response.ok().build();
                }
                catch (WebException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw WebException.wrap((String)"Failed to attach file", (Throwable)e);
                }
            }
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
        return Response.serverError().build();
    }
}

