/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.versioning.facet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterFactory;
import org.nuxeo.ecm.platform.versioning.api.VersioningManager;
import org.nuxeo.ecm.platform.versioning.facet.VersioningDocumentAdapter;
import org.nuxeo.runtime.api.Framework;

public class VersioningAdapterFactory
implements DocumentAdapterFactory {
    private static final Log log = LogFactory.getLog(VersioningAdapterFactory.class);

    public Object getAdapter(DocumentModel doc, Class itf) {
        VersioningManager vservice = (VersioningManager)Framework.getLocalService(VersioningManager.class);
        if (null == vservice) {
            try {
                vservice = (VersioningManager)Framework.getService(VersioningManager.class);
            }
            catch (Exception e) {
                log.error((Object)"Error getting facade to VersioningService", (Throwable)e);
            }
        }
        if (null == vservice) {
            log.error((Object)("Cannot create VersioningDocumentAdapter. " + VersioningManager.class.getSimpleName() + " service not available. "));
            return null;
        }
        String documentType = doc.getType();
        String fieldNameMajorVersion = vservice.getMajorVersionPropertyName(documentType);
        String fieldNameMinorVersion = vservice.getMinorVersionPropertyName(documentType);
        return new VersioningDocumentAdapter(doc, fieldNameMajorVersion, fieldNameMinorVersion);
    }
}

