/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Util;

public class QuoteServer
implements MembershipListener,
MessageListener {
    final Hashtable stocks = new Hashtable();
    Channel channel;
    RpcDispatcher disp;
    static final String channel_name = "Quotes";
    final int num_members = 1;
    Log log = LogFactory.getLog(this.getClass());
    final String props = "UDP:PING(num_initial_members=2;timeout=3000):FD:pbcast.PBCAST(gossip_interval=5000;gc_lag=50):UNICAST:FRAG:pbcast.GMS:pbcast.STATE_TRANSFER";

    private void integrate(Hashtable state) {
        if (state == null) {
            return;
        }
        Enumeration e = state.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.stocks.put(key, state.get(key));
        }
    }

    public void viewAccepted(View new_view) {
        System.out.println("Accepted view (" + new_view.size() + new_view.getMembers() + ')');
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public void start() {
        try {
            this.channel = new JChannel("UDP:PING(num_initial_members=2;timeout=3000):FD:pbcast.PBCAST(gossip_interval=5000;gc_lag=50):UNICAST:FRAG:pbcast.GMS:pbcast.STATE_TRANSFER");
            this.channel.setOpt(4, Boolean.TRUE);
            this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
            this.channel.connect(channel_name);
            System.out.println("\nQuote Server started at " + new Date());
            System.out.println("Joined channel 'Quotes' (" + this.channel.getView().size() + " members)");
            this.channel.getState(null, 0L);
            System.out.println("Ready to serve requests");
        }
        catch (Exception e) {
            this.log.error((Object)("QuoteServer.start() : " + e));
            System.exit(-1);
        }
    }

    public float getQuote(String stock_name) throws Exception {
        System.out.print("Getting quote for " + stock_name + ": ");
        Float retval = (Float)this.stocks.get(stock_name);
        if (retval == null) {
            System.out.println("not found");
            throw new Exception("Stock " + stock_name + " not found");
        }
        System.out.println(retval.floatValue());
        return retval.floatValue();
    }

    public void setQuote(String stock_name, Float value) {
        System.out.println("Setting quote for " + stock_name + ": " + value);
        this.stocks.put(stock_name, value);
    }

    public Hashtable getAllStocks() {
        System.out.print("getAllStocks: ");
        this.printAllStocks();
        return this.stocks;
    }

    public void printAllStocks() {
        System.out.println(this.stocks);
    }

    public void receive(Message msg) {
    }

    public byte[] getState() {
        try {
            return Util.objectToByteBuffer(this.stocks.clone());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setState(byte[] state) {
        try {
            this.integrate((Hashtable)Util.objectFromByteBuffer(state));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            QuoteServer server = new QuoteServer();
            server.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

