/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import org.jgroups.util.Util;

public class ContextObjectInputStream
extends ObjectInputStream {
    private static final HashMap classCache = new HashMap();
    private static final HashMap primClasses = new HashMap(9, 1.0f);

    public ContextObjectInputStream(InputStream is) throws IOException {
        super(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        HashMap hashMap;
        String className = v.getName();
        Class<?> resolvedClass = null;
        if (classCache != null) {
            hashMap = classCache;
            synchronized (hashMap) {
                resolvedClass = (Class)classCache.get(className);
            }
        }
        if (resolvedClass == null) {
            try {
                resolvedClass = Util.loadClass(className, this.getClass());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (resolvedClass == null && (resolvedClass = (Class)primClasses.get(className)) == null) {
                resolvedClass = super.resolveClass(v);
            }
            if (classCache != null) {
                hashMap = classCache;
                synchronized (hashMap) {
                    classCache.put(className, resolvedClass);
                }
            }
        }
        return resolvedClass;
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }
}

