/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mimetype.ejb;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.MimetypeNotFoundException;
import org.nuxeo.ecm.platform.mimetype.ejb.interfaces.local.MimetypeRegistryLocal;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.mimetype.service.ExtensionDescriptor;
import org.nuxeo.ecm.platform.mimetype.service.MimetypeRegistryService;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Local(value={MimetypeRegistryLocal.class})
@Remote(value={MimetypeRegistry.class})
public class MimetypeRegistryBean
implements MimetypeRegistry {
    private MimetypeRegistry service;

    private MimetypeRegistry getService() {
        if (this.service == null) {
            this.service = (MimetypeRegistry)Framework.getLocalService(MimetypeRegistry.class);
        }
        return this.service;
    }

    public List<String> getExtensionsFromMimetypeName(String mimetypeName) {
        return this.getService().getExtensionsFromMimetypeName(mimetypeName);
    }

    public String getMimetypeFromFile(File file) throws MimetypeNotFoundException, MimetypeDetectionException {
        return this.getService().getMimetypeFromFile(file);
    }

    @Deprecated
    public String getMimetypeFromStream(InputStream stream) throws MimetypeNotFoundException, MimetypeDetectionException {
        return this.getService().getMimetypeFromStream(stream);
    }

    @Deprecated
    public String getMimetypeFromStreamWithDefault(InputStream is, String defaultMimetype) throws MimetypeDetectionException {
        return this.getService().getMimetypeFromStreamWithDefault(is, defaultMimetype);
    }

    public String getMimetypeFromBlob(Blob blob) throws MimetypeNotFoundException, MimetypeDetectionException {
        return this.getService().getMimetypeFromBlob(blob);
    }

    public String getMimetypeFromBlobWithDefault(Blob blob, String defaultMimetype) throws MimetypeDetectionException {
        return this.getService().getMimetypeFromBlobWithDefault(blob, defaultMimetype);
    }

    public String getMimetypeFromFilenameAndBlobWithDefault(String filename, Blob blob, String defaultMimetype) throws MimetypeDetectionException {
        return this.getService().getMimetypeFromFilenameAndBlobWithDefault(filename, blob, defaultMimetype);
    }

    @Deprecated
    public MimetypeEntry getMimetypeEntryByName(String name) {
        return this.getService().getMimetypeEntryByName(name);
    }

    public MimetypeEntry getMimetypeEntryByMimeType(String mimetype) {
        return this.getService().getMimetypeEntryByMimeType(mimetype);
    }

    public void registerMimetype(MimetypeEntry mimetype) {
        ((MimetypeRegistryService)this.getService()).registerMimetype(mimetype);
    }

    public void unregisterMimetype(String mimetype) {
        ((MimetypeRegistryService)this.getService()).unregisterMimetype(mimetype);
    }

    public void registerFileExtension(ExtensionDescriptor extension) {
        ((MimetypeRegistryService)this.getService()).registerFileExtension(extension);
    }

    public void unregisterFileExtension(ExtensionDescriptor extension) {
        ((MimetypeRegistryService)this.getService()).unregisterFileExtension(extension);
    }

    public Blob updateMimetype(Blob blob, String filename) throws MimetypeDetectionException {
        return this.getService().updateMimetype(blob, filename);
    }

    public Blob updateMimetype(Blob blob) throws MimetypeDetectionException {
        return this.getService().updateMimetype(blob);
    }
}

