/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.AOPInstance;
import org.jboss.cache.aop.CachedType;
import org.jboss.cache.aop.InternalDelegate;
import org.jboss.cache.aop.ObjectGraphHandler;
import org.jboss.cache.aop.PojoCache;
import org.jboss.cache.aop.collection.AbstractCollectionInterceptor;
import org.jboss.cache.aop.collection.CollectionInterceptorUtil;

public class CollectionClassHandler {
    protected static final Log log = LogFactory.getLog((Class)CollectionClassHandler.class);
    protected PojoCache cache_;
    protected InternalDelegate internal_;
    protected ObjectGraphHandler graphHandler_;

    public CollectionClassHandler(PojoCache cache, InternalDelegate internal, ObjectGraphHandler graphHandler) {
        this.cache_ = cache;
        this.internal_ = internal;
        this.graphHandler_ = graphHandler;
    }

    Object collectionObjectGet(Fqn fqn, Class clazz) throws CacheException {
        ClassProxy obj = null;
        try {
            if (Map.class.isAssignableFrom(clazz)) {
                Object map = clazz.newInstance();
                obj = CollectionInterceptorUtil.createMapProxy(this.cache_, fqn, clazz, (Map)map);
            } else if (List.class.isAssignableFrom(clazz)) {
                Object list = clazz.newInstance();
                obj = CollectionInterceptorUtil.createListProxy(this.cache_, fqn, clazz, (List)list);
            } else if (Set.class.isAssignableFrom(clazz)) {
                Object set = clazz.newInstance();
                obj = CollectionInterceptorUtil.createSetProxy(this.cache_, fqn, clazz, (Set)set);
            }
        }
        catch (Exception e) {
            throw new CacheException("failure creating proxy", e);
        }
        return obj;
    }

    boolean collectionObjectPut(Fqn fqn, Object obj) throws CacheException {
        Iterator i;
        Class<?> clazz;
        boolean isCollection = false;
        CachedType type = null;
        AbstractCollectionInterceptor interceptor = null;
        if (obj instanceof ClassProxy) {
            Class<?> originalClaz = obj.getClass().getSuperclass();
            interceptor = CollectionInterceptorUtil.getInterceptor((ClassProxy)obj);
            type = this.cache_.getCachedType(originalClaz);
        } else {
            type = this.cache_.getCachedType(obj.getClass());
        }
        if (obj instanceof ClassProxy) {
            if (interceptor == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("collectionObjectPut(): null interceptor. Could be removed previously. " + fqn));
                }
            } else if (interceptor.isAttached()) {
                if (this.graphHandler_.objectGraphPut(fqn, interceptor, type, obj)) {
                    return true;
                }
            } else {
                boolean copyToCache = true;
                interceptor.attach(fqn, copyToCache);
                this.internal_.putAopClazz(fqn, type.getType());
                this.internal_.setPojo(fqn, obj);
                return true;
            }
        }
        if (obj instanceof Map) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("collectionPutObject(): aspectized obj is a Map type of size: " + ((Map)obj).size()));
            }
            this.internal_.putAopClazz(fqn, type.getType());
            Map map = (Map)obj;
            if (!(obj instanceof ClassProxy)) {
                clazz = obj.getClass();
                try {
                    obj = CollectionInterceptorUtil.createMapProxy(this.cache_, fqn, clazz, (Map)obj);
                }
                catch (Exception e) {
                    throw new CacheException("failure creating proxy", e);
                }
            }
            isCollection = true;
            i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ((Map)obj).put(entry.getKey(), entry.getValue());
            }
        } else if (obj instanceof List) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("collectionPutObject(): aspectized obj is a List type of size: " + ((List)obj).size()));
            }
            List list = (List)obj;
            this.internal_.putAopClazz(fqn, type.getType());
            if (!(obj instanceof ClassProxy)) {
                clazz = obj.getClass();
                try {
                    obj = CollectionInterceptorUtil.createListProxy(this.cache_, fqn, clazz, (List)obj);
                }
                catch (Exception e) {
                    throw new CacheException("failure creating proxy", e);
                }
            }
            isCollection = true;
            i = list.iterator();
            while (i.hasNext()) {
                ((List)obj).add(i.next());
            }
        } else if (obj instanceof Set) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("collectionPutObject(): aspectized obj is a Set type of size: " + ((Set)obj).size()));
            }
            Set set = (Set)obj;
            this.internal_.putAopClazz(fqn, type.getType());
            if (!(obj instanceof ClassProxy)) {
                clazz = obj.getClass();
                try {
                    obj = CollectionInterceptorUtil.createSetProxy(this.cache_, fqn, clazz, (Set)obj);
                }
                catch (Exception e) {
                    throw new CacheException("failure creating proxy", e);
                }
            }
            isCollection = true;
            i = set.iterator();
            while (i.hasNext()) {
                ((Set)obj).add(i.next());
            }
        }
        if (isCollection) {
            AOPInstance aopInstance = this.internal_.initializeAopInstance(fqn);
            this.cache_.put(fqn, AOPInstance.KEY, (Object)aopInstance);
            AbstractCollectionInterceptor baseInterceptor = CollectionInterceptorUtil.getInterceptor((ClassProxy)obj);
            baseInterceptor.setAopInstance(aopInstance);
            this.internal_.setPojo(aopInstance, obj);
        }
        return isCollection;
    }

    boolean collectionObjectRemove(Fqn fqn, boolean removeCacheInterceptor, boolean evict) throws CacheException {
        Class clazz;
        if (!Map.class.isAssignableFrom(clazz = this.internal_.peekAopClazz(fqn)) && !Collection.class.isAssignableFrom(clazz)) {
            return false;
        }
        Object obj = this.cache_.getObject(fqn);
        if (!(obj instanceof ClassProxy)) {
            throw new RuntimeException("CollectionClassHandler.collectionRemoveObject(): object is not a proxy :" + obj);
        }
        AbstractCollectionInterceptor interceptor = CollectionInterceptorUtil.getInterceptor((ClassProxy)obj);
        boolean removeFromCache = true;
        interceptor.detach(removeFromCache);
        return true;
    }

    void collectionReplaceWithProxy(Object obj, Object value, Field field, Fqn tmpFqn) throws CacheException {
        if (value instanceof Map || value instanceof List || value instanceof Set) {
            Object newValue = this.cache_.getObject(tmpFqn);
            try {
                field.set(obj, newValue);
                this.cache_.addUndoCollectionProxy(field, obj, value);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("collectionReplaceWithProxy(): Can't swap out the Collection class of field " + field.getName() + "Exception " + e));
                throw new CacheException("CollectionClassHandler.collectionReplaceWithProxy(): Can't swap out the Collection class of field \" +field.getName()," + e);
            }
        }
    }
}

