/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.collection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.PojoCache;
import org.jboss.cache.aop.collection.AbstractCollectionInterceptor;
import org.jboss.cache.aop.collection.CachedMapImpl;
import org.jboss.cache.aop.collection.CollectionInterceptorUtil;

public class CachedMapInterceptor
extends AbstractCollectionInterceptor {
    protected static final Map managedMethods_ = CollectionInterceptorUtil.getManagedMethods(Map.class);
    protected Map methodMap_;
    protected Map cacheImpl_;
    protected Map inMemImpl_;
    protected Map current_;

    protected CachedMapInterceptor(PojoCache cache, Fqn fqn, Class clazz, Map obj) {
        this.fqn_ = fqn;
        this.methodMap_ = CollectionInterceptorUtil.getMethodMap(clazz);
        this.cacheImpl_ = new CachedMapImpl(cache, this);
        this.inMemImpl_ = obj;
        this.current_ = this.cacheImpl_;
    }

    public void attach(Fqn fqn, boolean copyToCache) {
        super.attach(fqn, copyToCache);
        if (copyToCache) {
            this.toCache();
        }
        this.current_ = this.cacheImpl_;
    }

    protected void toCache() {
        if (this.inMemImpl_ == null) {
            throw new IllegalStateException("CachedMapInterceptor.toCache(). inMemImpl is null.");
        }
        Iterator it = this.inMemImpl_.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object val = this.inMemImpl_.get(key);
            this.cacheImpl_.put(key, val);
        }
        this.inMemImpl_.clear();
        this.inMemImpl_ = null;
    }

    public void detach(boolean removeFromCache) {
        super.detach(removeFromCache);
        this.toMemory(removeFromCache);
        this.current_ = this.inMemImpl_;
    }

    protected void toMemory(boolean removeFromCache) {
        if (this.inMemImpl_ == null) {
            this.inMemImpl_ = new HashMap();
        }
        Iterator it = this.cacheImpl_.keySet().iterator();
        this.inMemImpl_.clear();
        while (it.hasNext()) {
            Object key = it.next();
            Object val = null;
            val = removeFromCache ? (Object)this.cacheImpl_.remove(key) : (Object)this.cacheImpl_.get(key);
            this.inMemImpl_.put(key, val);
        }
    }

    public String getName() {
        return "CachedMapInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.current_ == null) {
            throw new IllegalStateException("CachedMapInterceptor.invoke(). current_ is null.");
        }
        return CollectionInterceptorUtil.invoke(invocation, this.current_, this.methodMap_, managedMethods_);
    }
}

