/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.jboss.cache.AbstractTreeCacheListener;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.CacheMgmtInterceptorMBean;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;

public class CacheMgmtInterceptor
extends Interceptor
implements CacheMgmtInterceptorMBean,
NotificationBroadcaster {
    public static final String NOTIF_CACHE_STARTED = "org.jboss.cache.CacheStarted";
    public static final String NOTIF_CACHE_STOPPED = "org.jboss.cache.CacheStopped";
    public static final String NOTIF_NODE_CREATED = "org.jboss.cache.NodeCreated";
    public static final String NOTIF_NODE_EVICTED = "org.jboss.cache.NodeEvicted";
    public static final String NOTIF_NODE_LOADED = "org.jboss.cache.NodeLoaded";
    public static final String NOTIF_NODE_MODIFIED = "org.jboss.cache.NodeModified";
    public static final String NOTIF_NODE_REMOVED = "org.jboss.cache.NodeRemoved";
    public static final String NOTIF_NODE_VISITED = "org.jboss.cache.NodeVisited";
    public static final String NOTIF_VIEW_CHANGE = "org.jboss.cache.ViewChange";
    public static final String NOTIF_NODE_ACTIVATE = "org.jboss.cache.NodeActivate";
    public static final String NOTIF_NODE_EVICT = "org.jboss.cache.NodeEvict";
    public static final String NOTIF_NODE_MODIFY = "org.jboss.cache.NodeModify";
    public static final String NOTIF_NODE_PASSIVATE = "org.jboss.cache.NodePassivate";
    public static final String NOTIF_NODE_REMOVE = "org.jboss.cache.NodeRemove";
    private static final String MSG_CACHE_STARTED = "Cache has been started.";
    private static final String MSG_CACHE_STOPPED = "Cache has been stopped.";
    private static final String MSG_NODE_CREATED = "Node has been created.";
    private static final String MSG_NODE_EVICTED = "Node has been evicted.";
    private static final String MSG_NODE_LOADED = "Node has been loaded.";
    private static final String MSG_NODE_MODIFIED = "Node has been modifed.";
    private static final String MSG_NODE_REMOVED = "Node has been removed.";
    private static final String MSG_NODE_VISITED = "Node has been visited.";
    private static final String MSG_VIEW_CHANGE = "Cache cluster view has changed.";
    private static final String MSG_NODE_ACTIVATE = "Node about to be activated.";
    private static final String MSG_NODE_ACTIVATED = "Node has been activated.";
    private static final String MSG_NODE_EVICT = "Node about to be evicted.";
    private static final String MSG_NODE_MODIFY = "Node about to be modified.";
    private static final String MSG_NODE_PASSIVATE = "Node about to be passivated.";
    private static final String MSG_NODE_PASSIVATED = "Node has been passivated.";
    private static final String MSG_NODE_REMOVE = "Node about to be removed.";
    private static final String NOTIFICATION_NAME = Notification.class.getName();
    private static final String NOTIFICATION_DESCR = "JBossCache event notifications";
    private SynchronizedLong m_seq = new SynchronizedLong(0L);
    private int m_listeners = 0;
    private long m_hit_times = 0L;
    private long m_miss_times = 0L;
    private long m_store_times = 0L;
    private long m_hits = 0L;
    private long m_misses = 0L;
    private long m_stores = 0L;
    private long m_evictions = 0L;
    private long m_start;
    private long m_reset = this.m_start = System.currentTimeMillis();
    private CacheMgmtListener m_listener = new CacheMgmtListener();
    private NotificationBroadcasterSupport m_broadcaster = null;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.m_broadcaster = new NotificationBroadcasterSupport();
    }

    public Object invoke(MethodCall call) throws Throwable {
        JBCMethodCall m = (JBCMethodCall)call;
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        Object retval = null;
        if (!this.statsEnabled) {
            return super.invoke(m);
        }
        switch (m.getMethodId()) {
            case 26: {
                long t1 = System.currentTimeMillis();
                retval = super.invoke(m);
                long t2 = System.currentTimeMillis();
                if (retval == null) {
                    this.m_miss_times += t2 - t1;
                    ++this.m_misses;
                    break;
                }
                this.m_hit_times += t2 - t1;
                ++this.m_hits;
                break;
            }
            case 3: 
            case 4: {
                long t1 = System.currentTimeMillis();
                retval = super.invoke(m);
                long t2 = System.currentTimeMillis();
                this.m_store_times += t2 - t1;
                ++this.m_stores;
                break;
            }
            case 1: 
            case 2: {
                Map attributes = (Map)args[2];
                long t1 = System.currentTimeMillis();
                retval = super.invoke(m);
                long t2 = System.currentTimeMillis();
                if (attributes == null || attributes.size() <= 0) break;
                this.m_store_times += t2 - t1;
                this.m_stores += (long)attributes.size();
                break;
            }
            case 8: 
            case 9: {
                retval = super.invoke(m);
                ++this.m_evictions;
                break;
            }
            default: {
                retval = super.invoke(m);
            }
        }
        return retval;
    }

    public long getHits() {
        return this.m_hits;
    }

    public long getMisses() {
        return this.m_misses;
    }

    public long getStores() {
        return this.m_stores;
    }

    public long getEvictions() {
        return this.m_evictions;
    }

    public double getHitMissRatio() {
        double total = this.m_hits + this.m_misses;
        if (total == 0.0) {
            return 0.0;
        }
        return (double)this.m_hits / total;
    }

    public double getReadWriteRatio() {
        if (this.m_stores == 0L) {
            return 0.0;
        }
        return (double)(this.m_hits + this.m_misses) / (double)this.m_stores;
    }

    public long getAverageReadTime() {
        long total = this.m_hits + this.m_misses;
        if (total == 0L) {
            return 0L;
        }
        return (this.m_hit_times + this.m_miss_times) / total;
    }

    public long getAverageWriteTime() {
        if (this.m_stores == 0L) {
            return 0L;
        }
        return this.m_store_times / this.m_stores;
    }

    public int getNumberOfAttributes() {
        return this.cache.getNumberOfAttributes();
    }

    public int getNumberOfNodes() {
        return this.cache.getNumberOfNodes();
    }

    public long getElapsedTime() {
        return (System.currentTimeMillis() - this.m_start) / 1000L;
    }

    public long getTimeSinceReset() {
        return (System.currentTimeMillis() - this.m_reset) / 1000L;
    }

    public Map dumpStatistics() {
        HashMap<String, Number> retval = new HashMap<String, Number>();
        retval.put("Hits", new Long(this.m_hits));
        retval.put("Misses", new Long(this.m_misses));
        retval.put("Stores", new Long(this.m_stores));
        retval.put("Evictions", new Long(this.m_evictions));
        retval.put("NumberOfAttributes", new Integer(this.cache.getNumberOfAttributes()));
        retval.put("NumberOfNodes", new Integer(this.cache.getNumberOfNodes()));
        retval.put("ElapsedTime", new Long(this.getElapsedTime()));
        retval.put("TimeSinceReset", new Long(this.getTimeSinceReset()));
        retval.put("AverageReadTime", new Long(this.getAverageReadTime()));
        retval.put("AverageWriteTime", new Long(this.getAverageWriteTime()));
        retval.put("HitMissRatio", new Double(this.getHitMissRatio()));
        retval.put("ReadWriteRatio", new Double(this.getReadWriteRatio()));
        return retval;
    }

    public void resetStatistics() {
        this.m_hits = 0L;
        this.m_misses = 0L;
        this.m_stores = 0L;
        this.m_evictions = 0L;
        this.m_hit_times = 0L;
        this.m_miss_times = 0L;
        this.m_store_times = 0L;
        this.m_reset = System.currentTimeMillis();
    }

    private synchronized void emitNotifications(boolean emit) {
        if (emit) {
            ++this.m_listeners;
            this.cache.addTreeCacheListener(this.m_listener);
        } else {
            --this.m_listeners;
            if (this.m_listeners <= 0) {
                this.cache.removeTreeCacheListener(this.m_listener);
            }
        }
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.m_broadcaster.removeNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{NOTIF_CACHE_STARTED, NOTIF_CACHE_STOPPED, NOTIF_NODE_CREATED, NOTIF_NODE_EVICTED, NOTIF_NODE_LOADED, NOTIF_NODE_MODIFIED, NOTIF_NODE_REMOVED, NOTIF_NODE_VISITED, NOTIF_VIEW_CHANGE, NOTIF_NODE_ACTIVATE, NOTIF_NODE_EVICT, NOTIF_NODE_MODIFY, NOTIF_NODE_PASSIVATE, NOTIF_NODE_REMOVE};
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, NOTIFICATION_NAME, NOTIFICATION_DESCR);
        return new MBeanNotificationInfo[]{info};
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.m_broadcaster.addNotificationListener(listener, filter, handback);
        this.emitNotifications(true);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.m_broadcaster.removeNotificationListener(listener);
        this.emitNotifications(false);
    }

    private class CacheMgmtListener
    extends AbstractTreeCacheListener {
        CacheMgmtListener() {
        }

        private long seq() {
            return CacheMgmtInterceptor.this.m_seq.increment();
        }

        public void cacheStarted(TreeCache cache) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_CACHE_STARTED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_CACHE_STARTED);
            n.setUserData(cache.getServiceName());
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void cacheStopped(TreeCache cache) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_CACHE_STOPPED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_CACHE_STOPPED);
            n.setUserData(cache.getServiceName());
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeCreated(Fqn fqn) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_CREATED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_CREATED);
            n.setUserData(fqn.toString());
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeEvicted(Fqn fqn) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_EVICTED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_EVICTED);
            n.setUserData(fqn.toString());
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeLoaded(Fqn fqn) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_LOADED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_LOADED);
            n.setUserData(fqn.toString());
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeModified(Fqn fqn) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_MODIFIED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_MODIFIED);
            n.setUserData(fqn.toString());
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeRemoved(Fqn fqn) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_REMOVED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_REMOVED);
            n.setUserData(fqn.toString());
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeVisited(Fqn fqn) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_VISITED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_VISITED);
            n.setUserData(fqn.toString());
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void viewChange(View view) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_VIEW_CHANGE, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_VIEW_CHANGE);
            n.setUserData(view.toString());
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeActivate(Fqn fqn, boolean pre) {
            Notification n = pre ? new Notification(CacheMgmtInterceptor.NOTIF_NODE_ACTIVATE, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_ACTIVATE) : new Notification(CacheMgmtInterceptor.NOTIF_NODE_ACTIVATE, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_ACTIVATED);
            n.setUserData(new Object[]{fqn.toString(), pre});
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeEvict(Fqn fqn, boolean pre) {
            Notification n = pre ? new Notification(CacheMgmtInterceptor.NOTIF_NODE_EVICT, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_EVICT) : new Notification(CacheMgmtInterceptor.NOTIF_NODE_EVICT, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_EVICTED);
            n.setUserData(new Object[]{fqn.toString(), pre});
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeModify(Fqn fqn, boolean pre, boolean isLocal) {
            Notification n = pre ? new Notification(CacheMgmtInterceptor.NOTIF_NODE_MODIFY, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_MODIFY) : new Notification(CacheMgmtInterceptor.NOTIF_NODE_MODIFY, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_MODIFIED);
            n.setUserData(new Object[]{fqn.toString(), pre, isLocal});
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodePassivate(Fqn fqn, boolean pre) {
            Notification n = pre ? new Notification(CacheMgmtInterceptor.NOTIF_NODE_PASSIVATE, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_PASSIVATE) : new Notification(CacheMgmtInterceptor.NOTIF_NODE_PASSIVATE, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_PASSIVATED);
            n.setUserData(new Object[]{fqn.toString(), pre});
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeRemove(Fqn fqn, boolean pre, boolean isLocal) {
            Notification n = pre ? new Notification(CacheMgmtInterceptor.NOTIF_NODE_REMOVE, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_REMOVE) : new Notification(CacheMgmtInterceptor.NOTIF_NODE_REMOVE, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_REMOVED);
            n.setUserData(new Object[]{fqn.toString(), pre, isLocal});
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }
    }
}

