/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.cache.CacheException;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jgroups.blocks.MethodCall;

public class OptimisticReplicationInterceptor
extends BaseRpcInterceptor {
    private Map broadcastTxs = new ConcurrentHashMap();

    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    public Object invoke(MethodCall call) throws Throwable {
        Object retval;
        block17: {
            block16: {
                JBCMethodCall m = (JBCMethodCall)call;
                InvocationContext ctx = this.getInvocationContext();
                Option optionOverride = ctx.getOptionOverrides();
                if (optionOverride != null && optionOverride.isCacheModeLocal() && ctx.getTransaction() == null) {
                    return super.invoke(m);
                }
                if (ctx.getTransaction() == null) break block16;
                GlobalTransaction gtx = ctx.getGlobalTransaction();
                if (gtx == null) {
                    throw new CacheException("failed to get global transaction");
                }
                this.log.debug((Object)(" received method " + (Object)((Object)m)));
                switch (m.getMethodId()) {
                    case 18: {
                        retval = super.invoke(m);
                        if (!gtx.isRemote() && (retval = this.broadcastPrepare(m, gtx)) instanceof Throwable) {
                            throw (Throwable)retval;
                        }
                        break block17;
                    }
                    case 11: {
                        Throwable temp = null;
                        if (!gtx.isRemote() && this.broadcastTxs.containsKey(gtx)) {
                            try {
                                this.broadcastCommit(gtx);
                            }
                            catch (Throwable t) {
                                this.log.error((Object)" a problem occurred with remote commit", t);
                                temp = t;
                            }
                        }
                        retval = super.invoke(m);
                        if (temp != null) {
                            throw temp;
                        }
                        break block17;
                    }
                    case 12: {
                        Throwable temp2 = null;
                        if (!gtx.isRemote() && this.broadcastTxs.containsKey(gtx)) {
                            try {
                                this.broadcastRollback(gtx);
                            }
                            catch (Throwable t) {
                                this.log.error((Object)" a problem occurred with remote rollback", t);
                                temp2 = t;
                            }
                        }
                        retval = super.invoke(m);
                        if (temp2 != null) {
                            throw temp2;
                        }
                        break block17;
                    }
                    default: {
                        this.log.debug((Object)(" received method " + (Object)((Object)m) + " not handling"));
                        retval = super.invoke(m);
                        break;
                    }
                }
                break block17;
            }
            throw new CacheException("transaction does not exist");
        }
        return retval;
    }

    protected Object broadcastPrepare(JBCMethodCall methodCall, GlobalTransaction gtx) throws Throwable {
        int num_mods;
        boolean remoteCallSync = this.cache.getCacheModeInternal() == 3;
        Object[] args = methodCall.getArgs();
        List modifications = (List)args[1];
        int n = num_mods = modifications != null ? modifications.size() : 0;
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            this.broadcastTxs.put(gtx, gtx);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("(" + this.cache.getLocalAddress() + "): broadcasting prepare for " + gtx + " (" + num_mods + " modifications"));
            }
            this.replicateCall(methodCall, remoteCallSync);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("(" + this.cache.getLocalAddress() + "):not broadcasting prepare as members are " + this.cache.getMembers()));
        }
        return null;
    }

    protected void broadcastCommit(GlobalTransaction gtx) throws Throwable {
        boolean remoteCallSync = this.cache.getSyncCommitPhase();
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            try {
                this.broadcastTxs.remove(gtx);
                JBCMethodCall commit_method = MethodCallFactory.create(MethodDeclarations.commitMethod, new Object[]{gtx});
                this.log.debug((Object)("running remote commit for " + gtx + " and coord=" + this.cache.getLocalAddress()));
                this.replicateCall(commit_method, remoteCallSync);
            }
            catch (Exception e) {
                this.log.fatal((Object)"commit failed", (Throwable)e);
                throw e;
            }
        }
    }

    protected void broadcastRollback(GlobalTransaction gtx) throws Throwable {
        boolean remoteCallSync = this.cache.getSyncRollbackPhase();
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            try {
                this.broadcastTxs.remove(gtx);
                JBCMethodCall rollback_method = MethodCallFactory.create(MethodDeclarations.rollbackMethod, new Object[]{gtx});
                this.log.debug((Object)("running remote rollback for " + gtx + " and coord=" + this.cache.getLocalAddress()));
                this.replicateCall(rollback_method, remoteCallSync);
            }
            catch (Exception e) {
                this.log.error((Object)"rollback failed", (Throwable)e);
                throw e;
            }
        }
    }
}

