/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jgroups.blocks.MethodCall;

public class PessimisticLockInterceptor
extends Interceptor {
    TransactionTable tx_table = null;
    Map lock_table;
    private long lock_acquisition_timeout;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.tx_table = cache.getTransactionTable();
        this.lock_table = cache.getLockTable();
        this.lock_acquisition_timeout = cache.getLockAcquisitionTimeout();
    }

    public Object invoke(MethodCall call) throws Throwable {
        JBCMethodCall m = (JBCMethodCall)call;
        Fqn fqn = null;
        int lock_type = 0;
        long lock_timeout = this.lock_acquisition_timeout;
        Object[] args = m.getArgs();
        InvocationContext ctx = this.getInvocationContext();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("PessimisticLockInterceptor invoked for method " + (Object)((Object)m)));
        }
        if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isSuppressLocking()) {
            this.log.trace((Object)"Suppressing locking");
            switch (m.getMethodId()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.log.trace((Object)"Creating nodes if necessary");
                    this.createNodes((Fqn)args[1], ctx.getGlobalTransaction());
                }
            }
            return super.invoke(m);
        }
        boolean recursive = false;
        boolean createIfNotExists = false;
        switch (m.getMethodId()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                createIfNotExists = true;
                fqn = (Fqn)args[1];
                lock_type = 2;
                if (m.getMethodId() != 4) break;
                lock_timeout = (Long)args[5];
                break;
            }
            case 5: {
                fqn = (Fqn)args[1];
                lock_type = 2;
                recursive = true;
                break;
            }
            case 6: 
            case 7: 
            case 15: {
                fqn = (Fqn)args[1];
                lock_type = 2;
                break;
            }
            case 8: {
                fqn = (Fqn)args[0];
                lock_type = 2;
                break;
            }
            case 17: 
            case 23: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                fqn = (Fqn)args[0];
                lock_type = 1;
                break;
            }
            case 33: {
                fqn = (Fqn)args[0];
                lock_type = (Integer)args[1];
                recursive = (Boolean)args[2];
                break;
            }
            case 11: {
                this.commit(ctx.getGlobalTransaction());
                break;
            }
            case 12: {
                this.rollback(ctx.getGlobalTransaction());
                break;
            }
            default: {
                if (!this.isOnePhaseCommitPrepareMehod(m)) break;
                this.commit(ctx.getGlobalTransaction());
            }
        }
        if (fqn != null) {
            if (createIfNotExists) {
                do {
                    this.lock(fqn, ctx.getGlobalTransaction(), lock_type, recursive, lock_timeout, createIfNotExists);
                } while (!this.cache.exists(fqn));
            } else {
                this.lock(fqn, ctx.getGlobalTransaction(), lock_type, recursive, lock_timeout, createIfNotExists);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("bypassed locking as method " + m.getName() + "() doesn't require locking"));
        }
        if (m.getMethodId() == 33) {
            return null;
        }
        return super.invoke(m);
    }

    private void lock(Fqn fqn, GlobalTransaction gtx, int lock_type, boolean recursive, long lock_timeout, boolean createIfNotExists) throws TimeoutException, LockingException, InterruptedException {
        Thread currentThread = Thread.currentThread();
        Object owner = gtx != null ? gtx : currentThread;
        boolean acquired = false;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Attempting to lock node " + fqn + " for owner " + owner));
        }
        if (fqn == null) {
            this.log.error((Object)"fqn is null - this should not be the case");
            return;
        }
        int treeNodeSize = fqn.size();
        if (treeNodeSize == 0) {
            return;
        }
        if (this.cache.getIsolationLevelClass() == IsolationLevel.NONE) {
            lock_type = 0;
        }
        DataNode n = this.cache.getRoot();
        for (int i = 0; i < treeNodeSize; ++i) {
            Set acquired_locks;
            List locks;
            Object child_name = fqn.get(i);
            DataNode child_node = (DataNode)n.getOrCreateChild(child_name, gtx, createIfNotExists);
            if (child_node == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("failed to find or create child " + child_name + " of node " + n.getFqn()));
                }
                return;
            }
            if (lock_type == 0) {
                n = child_node;
                continue;
            }
            acquired = lock_type == 2 && i == treeNodeSize - 1 ? child_node.acquire(owner, lock_timeout, 2) : child_node.acquire(owner, lock_timeout, 1);
            if (acquired) {
                if (gtx != null) {
                    this.cache.getTransactionTable().addLock(gtx, child_node.getLock());
                } else {
                    IdentityLock l = child_node.getLock();
                    locks = this.getLocks(currentThread);
                    if (!locks.contains(l)) {
                        locks.add(l);
                    }
                }
            }
            if (recursive && i == treeNodeSize - 1 && (acquired_locks = child_node.acquireAll(owner, lock_timeout, lock_type)).size() > 0) {
                if (gtx != null) {
                    this.cache.getTransactionTable().addLocks(gtx, acquired_locks);
                } else {
                    locks = this.getLocks(currentThread);
                    locks.addAll(acquired_locks);
                }
            }
            n = child_node;
        }
    }

    private List getLocks(Thread currentThread) {
        List locks = (List)this.lock_table.get(currentThread);
        if (locks == null) {
            locks = Collections.synchronizedList(new LinkedList());
            this.lock_table.put(currentThread, locks);
        }
        return locks;
    }

    private void createNodes(Fqn fqn, GlobalTransaction gtx) {
        int treeNodeSize = fqn.size();
        if (treeNodeSize == 0) {
            return;
        }
        DataNode n = this.cache.getRoot();
        for (int i = 0; i < treeNodeSize; ++i) {
            Object child_name = fqn.get(i);
            DataNode child_node = (DataNode)n.getOrCreateChild(child_name, gtx, true);
            if (child_node == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("failed to find or create child " + child_name + " of node " + n.getFqn()));
                }
                return;
            }
            n = child_node;
        }
    }

    private void commit(GlobalTransaction gtx) {
        TransactionEntry entry;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("committing cache with gtx " + gtx));
        }
        if ((entry = this.tx_table.get(gtx)) == null) {
            this.log.error((Object)("entry for transaction " + gtx + " not found (maybe already committed)"));
            return;
        }
        entry.releaseAllLocksLIFO(gtx);
        Transaction ltx = entry.getTransaction();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("removing local transaction " + ltx + " and global transaction " + gtx));
        }
        this.tx_table.remove(ltx);
        this.tx_table.remove(gtx);
    }

    private void rollback(GlobalTransaction tx) {
        TransactionEntry entry = this.tx_table.get(tx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("called to rollback cache with GlobalTransaction=" + tx));
        }
        if (entry == null) {
            this.log.error((Object)("entry for transaction " + tx + " not found (transaction has possibly already been rolled back)"));
            return;
        }
        entry.undoOperations(this.cache);
        entry.releaseAllLocksLIFO(tx);
        Transaction ltx = entry.getTransaction();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("removing local transaction " + ltx + " and global transaction " + tx));
        }
        this.tx_table.remove(ltx);
        this.tx_table.remove(tx);
    }
}

