/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.ExtendedCacheLoader;

public class AsyncCacheLoader
implements CacheLoader {
    private static final Log log = LogFactory.getLog((Class)AsyncCacheLoader.class);
    private static SynchronizedInt threadId = new SynchronizedInt(0);
    public static final int DEFAULT_QUEUE_SIZE = 10000;
    private CacheLoader delegateTo;
    private AsyncProcessor processor;
    private SynchronizedBoolean stopped = new SynchronizedBoolean(true);
    private BoundedLinkedQueue queue = new BoundedLinkedQueue(10000);
    private int batchSize = 100;
    private long pollWait = 100L;
    private boolean returnOld = true;
    private boolean asyncPut = true;

    public AsyncCacheLoader() {
    }

    public AsyncCacheLoader(CacheLoader cacheLoader) {
        this.delegateTo = cacheLoader;
    }

    public CacheLoader getCacheLoader() {
        return this.delegateTo;
    }

    public void setConfig(Properties props) {
        log.debug((Object)("setConfig " + props));
        String s = props.getProperty("cache.async.batchSize");
        if (s != null) {
            this.batchSize = Integer.parseInt(s);
        }
        if (this.batchSize <= 0) {
            throw new IllegalArgumentException("Invalid size: " + this.batchSize);
        }
        s = props.getProperty("cache.async.pollWait");
        if (s != null) {
            this.pollWait = Integer.parseInt(s);
        }
        if ((s = props.getProperty("cache.async.returnOld")) != null) {
            this.returnOld = Boolean.valueOf(s);
        }
        if ((s = props.getProperty("cache.async.queueSize")) != null) {
            this.queue = new BoundedLinkedQueue(Integer.parseInt(s));
        }
        if ((s = props.getProperty("cache.async.put")) != null) {
            this.asyncPut = Boolean.valueOf(s);
        }
        this.delegateTo.setConfig(props);
    }

    public void setCache(TreeCache c) {
        this.delegateTo.setCache(c);
    }

    public Set getChildrenNames(Fqn fqn) throws Exception {
        return this.delegateTo.getChildrenNames(fqn);
    }

    public Map get(Fqn name) throws Exception {
        try {
            return this.delegateTo.get(name);
        }
        catch (IOException e) {
            log.trace((Object)e);
            return new HashMap();
        }
    }

    public boolean exists(Fqn name) throws Exception {
        return this.delegateTo.exists(name);
    }

    Object get(Fqn name, Object key) throws Exception {
        if (this.returnOld) {
            try {
                Map map = this.delegateTo.get(name);
                if (map != null) {
                    return map.get(key);
                }
            }
            catch (IOException e) {
                log.trace((Object)e);
            }
        }
        return null;
    }

    public Object put(Fqn name, Object key, Object value) throws Exception {
        if (this.asyncPut) {
            Object oldValue = this.get(name, key);
            Modification mod = new Modification(1, name, key, value);
            this.enqueue(mod);
            return oldValue;
        }
        return this.delegateTo.put(name, key, value);
    }

    public void put(Fqn name, Map attributes) throws Exception {
        if (this.asyncPut) {
            Modification mod = new Modification(2, name, attributes);
            this.enqueue(mod);
        } else {
            this.delegateTo.put(name, attributes);
        }
    }

    public void put(List modifications) throws Exception {
        if (this.asyncPut) {
            Iterator i = modifications.iterator();
            while (i.hasNext()) {
                this.enqueue((Modification)i.next());
            }
        } else {
            this.delegateTo.put(modifications);
        }
    }

    public Object remove(Fqn name, Object key) throws Exception {
        Object oldValue = this.get(name, key);
        Modification mod = new Modification(5, name, key);
        this.enqueue(mod);
        return oldValue;
    }

    public void remove(Fqn name) throws Exception {
        Modification mod = new Modification(4, name);
        this.enqueue(mod);
    }

    public void removeData(Fqn name) throws Exception {
        Modification mod = new Modification(6, name);
        this.enqueue(mod);
    }

    public void prepare(Object tx, List modifications, boolean one_phase) throws Exception {
        this.delegateTo.prepare(tx, modifications, one_phase);
    }

    public void commit(Object tx) throws Exception {
        this.delegateTo.commit(tx);
    }

    public void rollback(Object tx) {
        this.delegateTo.rollback(tx);
    }

    public byte[] loadEntireState() throws Exception {
        return this.delegateTo.loadEntireState();
    }

    void storeState(byte[] state, Fqn subtree) throws Exception {
        Modification mod = new Modification(7, subtree, null, state);
        this.enqueue(mod);
    }

    public void storeEntireState(byte[] state) throws Exception {
        Modification mod = new Modification(7, null, null, state);
        this.enqueue(mod);
    }

    public void create() throws Exception {
        this.delegateTo.create();
    }

    public void start() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Async cache loader starting: " + this));
        }
        this.stopped.set(false);
        this.delegateTo.start();
        this.processor = new AsyncProcessor();
        this.processor.start();
    }

    public void stop() {
        this.stopped.set(true);
        if (this.processor != null) {
            this.processor.stop();
        }
        this.delegateTo.stop();
    }

    public void destroy() {
        this.delegateTo.destroy();
    }

    private void enqueue(Modification mod) throws CacheException, InterruptedException {
        if (this.stopped.get()) {
            throw new CacheException("AsyncCacheLoader stopped; no longer accepting more entries.");
        }
        this.queue.put((Object)mod);
    }

    public String toString() {
        return super.toString() + " delegate=[" + this.delegateTo + "]" + " processor=" + this.processor + " stopped=" + this.stopped + " batchSize=" + this.batchSize + " pollWait=" + this.pollWait + " returnOld=" + this.returnOld + " asyncPut=" + this.asyncPut + " queue.capacity()=" + this.queue.capacity() + " queue.peek()=" + this.queue.peek();
    }

    private class AsyncProcessor
    implements Runnable {
        private Thread t;
        private final List mods;

        private AsyncProcessor() {
            this.mods = new ArrayList(AsyncCacheLoader.this.batchSize);
        }

        public void start() {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread((Runnable)this, "AsyncCacheLoader-" + threadId.increment());
                this.t.start();
            }
        }

        public void stop() {
            if (this.t != null) {
                this.t.interrupt();
                try {
                    this.t.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!AsyncCacheLoader.this.queue.isEmpty()) {
                log.warn((Object)"Async queue not yet empty, possibly interrupted");
            }
        }

        public void run() {
            while (!Thread.interrupted()) {
                try {
                    this.run0();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("process remaining batch " + this.mods.size()));
                }
                this.put(this.mods);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("process remaining queued " + AsyncCacheLoader.this.queue.size()));
                }
                while (!AsyncCacheLoader.this.queue.isEmpty()) {
                    this.run0();
                }
            }
            catch (InterruptedException e) {
                log.trace((Object)"remaining interrupted");
            }
        }

        private void run0() throws InterruptedException {
            log.trace((Object)"run0");
            Object o = AsyncCacheLoader.this.queue.take();
            this.addTaken(o);
            while (this.mods.size() < AsyncCacheLoader.this.batchSize && (o = AsyncCacheLoader.this.queue.poll(AsyncCacheLoader.this.pollWait)) != null) {
                this.addTaken(o);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("put " + this.mods.size()));
            }
            this.put(this.mods);
            this.mods.clear();
        }

        private void addTaken(Object o) throws InterruptedException {
            if (o instanceof List) {
                this.mods.addAll((List)o);
            } else {
                Modification mod = (Modification)o;
                if (mod.getType() == 7) {
                    log.trace((Object)"storeState");
                    this.storeState(mod.getFqn(), (byte[])mod.getValue());
                } else {
                    this.mods.add(mod);
                }
            }
        }

        private void storeState(Fqn fqn, byte[] b) {
            try {
                if (fqn == null) {
                    AsyncCacheLoader.this.delegateTo.storeEntireState(b);
                } else {
                    ((ExtendedCacheLoader)AsyncCacheLoader.this.delegateTo).storeState(b, fqn);
                }
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Failed to store " + e));
                }
                log.debug((Object)"Exception: ", (Throwable)e);
            }
        }

        private void put(List mods) {
            try {
                AsyncCacheLoader.this.delegateTo.put(mods);
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Failed to process async modifications: " + e));
                }
                log.debug((Object)"Exception: ", (Throwable)e);
            }
        }

        public String toString() {
            return "TQ t=" + this.t;
        }
    }
}

