/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.tcp;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.Node;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.cache.loader.tcp.TcpCacheServerMBean;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceMBeanSupport;

public class TcpCacheServer
extends ServiceMBeanSupport
implements TcpCacheServerMBean {
    ServerSocket srv_sock;
    InetAddress bind_addr = null;
    int port = 7500;
    TreeCacheMBean cache;
    ObjectName cache_name;
    String config;
    boolean running = true;
    List conns = new LinkedList();
    String agendId;
    static Log mylog = LogFactory.getLog((Class)TcpCacheServer.class);

    public String getBindAddress() {
        return this.bind_addr != null ? this.bind_addr.toString() : "n/a";
    }

    public void setBindAddress(String bind_addr) throws UnknownHostException {
        if (bind_addr != null) {
            this.bind_addr = InetAddress.getByName(bind_addr);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getMBeanServerName() {
        return this.agendId;
    }

    public void setMBeanServerName(String name) {
        this.agendId = name;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public TreeCacheMBean getCache() {
        return this.cache;
    }

    public void setCache(TreeCacheMBean cache) {
        this.cache = cache;
    }

    public String getCacheName() {
        return this.cache_name != null ? this.cache_name.toString() : "n/a";
    }

    public void setCacheName(String cache_name) throws MalformedObjectNameException {
        this.cache_name = new ObjectName(cache_name);
    }

    public void createService() throws Exception {
        super.createService();
    }

    public void startService() throws Exception {
        if (this.cache == null && this.cache_name != null && this.server != null) {
            this.cache = (TreeCacheMBean)MBeanProxyExt.create((Class)TreeCacheMBean.class, (ObjectName)this.cache_name, (MBeanServer)this.server);
        }
        if (this.cache == null && this.config != null) {
            this.cache = new TreeCache();
            PropertyConfigurator cfg = new PropertyConfigurator();
            cfg.configure((Object)this.cache, this.config);
            this.cache.createService();
            this.cache.startService();
        }
        if (this.cache == null) {
            throw new CacheException("cache reference is not set");
        }
        this.srv_sock = new ServerSocket(this.port, 10, this.bind_addr);
        System.out.println("TcpCacheServer listening on : " + this.srv_sock.getInetAddress() + ":" + this.srv_sock.getLocalPort());
        while (this.running) {
            Socket client_sock = this.srv_sock.accept();
            Connection conn = new Connection(client_sock, this.cache);
            this.conns.add(conn);
            conn.start();
        }
    }

    public void stopService() {
        this.running = false;
        Iterator it = this.conns.iterator();
        while (it.hasNext()) {
            Connection conn = (Connection)it.next();
            conn.close();
        }
        this.conns.clear();
        if (this.srv_sock != null) {
            try {
                this.srv_sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getConnections() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.conns.size() + " connections:\n");
        Iterator it = this.conns.iterator();
        while (it.hasNext()) {
            Connection c = (Connection)it.next();
            sb.append(c).append("\n");
        }
        return sb.toString();
    }

    public void destroy() {
        super.destroy();
    }

    public static void main(String[] args) throws Exception {
        String bind_addr = null;
        int port = 7500;
        String config = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-bind_addr")) {
                bind_addr = args[++i];
                continue;
            }
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-config")) {
                config = args[++i];
                continue;
            }
            TcpCacheServer.help();
            return;
        }
        TcpCacheServer server = new TcpCacheServer();
        server.setBindAddress(bind_addr);
        server.setPort(port);
        server.setConfig(config);
        server.createService();
        server.startService();
    }

    private static void help() {
        System.out.println("TcpCacheServer [-bind_addr <address>] [-port <port>] [-config <config file>] [-help]");
    }

    private static class Connection
    implements Runnable {
        Socket sock = null;
        ObjectInputStream input = null;
        ObjectOutputStream output = null;
        TreeCacheMBean c;
        Thread t = null;

        public Connection(Socket sock, TreeCacheMBean cache) throws IOException {
            this.sock = sock;
            this.output = new ObjectOutputStream(sock.getOutputStream());
            this.input = new ObjectInputStream(sock.getInputStream());
            this.c = cache;
        }

        public void start() {
            this.t = new Thread((Runnable)this, "TcpCacheServer.Connection");
            this.t.setDaemon(true);
            this.t.start();
        }

        public void close() {
            this.t = null;
            try {
                if (this.output != null) {
                    this.output.close();
                }
            }
            catch (Throwable th) {
                // empty catch block
            }
            try {
                if (this.input != null) {
                    this.input.close();
                }
            }
            catch (Throwable th) {
                // empty catch block
            }
            try {
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void run() {
            while (this.t != null && Thread.currentThread().equals(this.t)) {
                int op;
                try {
                    op = this.input.readInt();
                }
                catch (IOException e) {
                    mylog.warn((Object)"failed reading data, thread will terminate", (Throwable)e);
                    try {
                        if (this.output != null) {
                            this.output.close();
                        }
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                    try {
                        if (this.input != null) {
                            this.input.close();
                        }
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                    try {
                        if (this.sock == null) break;
                        this.sock.close();
                    }
                    catch (Throwable th) {}
                    break;
                }
                try {
                    switch (op) {
                        case 1: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Set children = this.c.getChildrenNames(fqn);
                            this.output.writeObject(children);
                            break;
                        }
                        case 2: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Object key = this.input.readObject();
                            Object retval = this.c.get(fqn, key);
                            this.output.writeObject(retval);
                            break;
                        }
                        case 3: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Node n = this.c.get(fqn);
                            if (n == null) {
                                this.output.writeObject(n);
                                break;
                            }
                            Map map = n.getData();
                            if (map == null) {
                                map = new HashMap();
                            }
                            this.output.writeObject(map);
                            break;
                        }
                        case 4: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            boolean flag = this.c.exists(fqn);
                            this.output.writeObject(flag);
                            break;
                        }
                        case 5: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Object key = this.input.readObject();
                            Object val = this.input.readObject();
                            Object retval = this.c.put(fqn, key, val);
                            this.output.writeObject(retval);
                            break;
                        }
                        case 6: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Map map = (HashMap)this.input.readObject();
                            this.c.put(fqn, map);
                            this.output.writeObject(Boolean.TRUE);
                            break;
                        }
                        case 12: {
                            int length = this.input.readInt();
                            Object retval = Boolean.TRUE;
                            if (length > 0) {
                                ArrayList<Modification> mods = new ArrayList<Modification>(length);
                                for (int i = 0; i < length; ++i) {
                                    Modification mod = new Modification();
                                    mod.readExternal(this.input);
                                    mods.add(mod);
                                }
                                try {
                                    this.handleModifications(mods);
                                }
                                catch (Exception ex) {
                                    retval = ex;
                                }
                            }
                            this.output.writeObject(retval);
                            break;
                        }
                        case 7: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Object key = this.input.readObject();
                            Object retval = this.c.remove(fqn, key);
                            this.output.writeObject(retval);
                            break;
                        }
                        case 8: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            this.c.remove(fqn);
                            this.output.writeObject(Boolean.TRUE);
                            break;
                        }
                        case 9: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            this.c.removeData(fqn);
                            this.output.writeObject(Boolean.TRUE);
                            break;
                        }
                        case 10: {
                            byte[] state = this.c.getCacheLoader() != null ? this.c.getCacheLoader().loadEntireState() : null;
                            this.output.writeObject(state);
                            break;
                        }
                        case 11: {
                            byte[] state = (byte[])this.input.readObject();
                            if (this.c.getCacheLoader() != null) {
                                this.c.getCacheLoader().storeEntireState(state);
                            }
                            this.output.writeObject(Boolean.TRUE);
                            break;
                        }
                        default: {
                            mylog.error((Object)("Operation " + op + " unknown"));
                        }
                    }
                    this.output.flush();
                }
                catch (Exception e) {
                    try {
                        this.output.writeObject(e);
                        this.output.flush();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.sock != null) {
                sb.append(this.sock.getRemoteSocketAddress());
            }
            return sb.toString();
        }

        protected void handleModifications(List modifications) throws CacheException {
            Iterator it = modifications.iterator();
            block8: while (it.hasNext()) {
                Modification m = (Modification)it.next();
                switch (m.getType()) {
                    case 2: {
                        this.c.put(m.getFqn(), m.getData());
                        continue block8;
                    }
                    case 3: {
                        this.c.put(m.getFqn(), m.getData());
                        continue block8;
                    }
                    case 1: {
                        this.c.put(m.getFqn(), m.getKey(), m.getValue());
                        continue block8;
                    }
                    case 6: {
                        this.c.removeData(m.getFqn());
                        continue block8;
                    }
                    case 5: {
                        this.c.remove(m.getFqn(), m.getKey());
                        continue block8;
                    }
                    case 4: {
                        this.c.remove(m.getFqn());
                        continue block8;
                    }
                }
                mylog.error((Object)("modification type " + m.getType() + " not known"));
            }
        }
    }
}

