/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.marshall.Region;
import org.jboss.cache.marshall.RegionManager;
import org.jgroups.Address;
import org.jgroups.blocks.MethodCall;
import org.jgroups.stack.IpAddress;

public class TreeCacheMarshaller140
extends Marshaller {
    private static Log log = LogFactory.getLog((Class)TreeCacheMarshaller140.class);
    protected static final int MAGICNUMBER_METHODCALL = 1;
    protected static final int MAGICNUMBER_FQN = 2;
    protected static final int MAGICNUMBER_GTX = 3;
    protected static final int MAGICNUMBER_IPADDRESS = 4;
    protected static final int MAGICNUMBER_LIST = 5;
    protected static final int MAGICNUMBER_INTEGER = 6;
    protected static final int MAGICNUMBER_LONG = 7;
    protected static final int MAGICNUMBER_BOOLEAN = 8;
    protected static final int MAGICNUMBER_STRING = 9;
    protected static final int MAGICNUMBER_NULL = 99;
    protected static final int MAGICNUMBER_SERIALIZABLE = 100;
    protected static final int MAGICNUMBER_REF = 101;

    public TreeCacheMarshaller140(RegionManager manager, boolean defaultInactive, boolean useRegionBasedMarshalling) {
        this.init(manager, defaultInactive, useRegionBasedMarshalling);
        if (useRegionBasedMarshalling) {
            log.debug((Object)"Using region based marshalling logic : marshalling Fqn as a String first for every call.");
        }
    }

    public void objectToStream(Object o, ObjectOutputStream out) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Marshalling object " + o));
        }
        HashMap refMap = new HashMap();
        if (this.useRegionBasedMarshalling) {
            JBCMethodCall call = null;
            try {
                call = (JBCMethodCall)((Object)o);
                String fqnAsString = this.extractFqnAsString(call);
                this.marshallObject(fqnAsString, out, refMap);
            }
            catch (ClassCastException cce) {
                if (call == null) {
                    log.debug((Object)("Received non-JBCMethodCall " + o + " -- cannot extract Fqn so using null"));
                    this.marshallObject(null, out, refMap);
                }
                throw cce;
            }
        }
        this.marshallObject(o, out, refMap);
    }

    public Object objectFromStream(ObjectInputStream in) throws Exception {
        Object retValue;
        HashMap refMap = new HashMap();
        if (this.useRegionBasedMarshalling) {
            String fqn = (String)this.unmarshallObject(in, refMap);
            try {
                Region region = null;
                if (fqn != null) {
                    region = this.findRegion(fqn);
                }
                Object object = retValue = region == null ? this.unmarshallObject(in, refMap) : this.unmarshallObject(in, region.getClassLoader(), refMap);
                if (region != null && region.isQueueing()) {
                    Object originalRetValue = retValue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Received call on an ququing Fqn region (" + fqn + ").  Calling enqueueMethodCallMethod"));
                    }
                    retValue = MethodCallFactory.create(MethodDeclarations.enqueueMethodCallMethod, new Object[]{fqn, originalRetValue});
                }
            }
            catch (InactiveRegionException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Received call on an inactive Fqn region (" + fqn + ").  Calling notifyCallOnInactiveMetod"));
                }
                retValue = MethodCallFactory.create(MethodDeclarations.notifyCallOnInactiveMethod, new Object[]{fqn});
            }
        } else {
            retValue = this.unmarshallObject(in, refMap);
        }
        return retValue;
    }

    private Region findRegion(String fqn) throws InactiveRegionException {
        Region region;
        Region region2 = region = fqn == null ? null : this.getRegion(fqn);
        if (region != null ? region.getStatus() == 1 : this.defaultInactive) {
            throw new InactiveRegionException();
        }
        return region;
    }

    private String extractFqnAsString(JBCMethodCall call) throws Exception {
        String fqnAsString;
        switch (call.getMethodId()) {
            case 13: {
                fqnAsString = this.extractFqnFromMethodCall(call);
                break;
            }
            case 14: {
                fqnAsString = this.extractFqnFromListOfMethodCall(call);
                break;
            }
            case 27: {
                JBCMethodCall call2 = (JBCMethodCall)((Object)call.getArgs()[1]);
                fqnAsString = this.extractFqn(call2);
                break;
            }
            default: {
                fqnAsString = this.extractFqn(call);
            }
        }
        return fqnAsString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void marshallObject(Object o, ObjectOutputStream out, Map refMap) throws Exception {
        if (o == null) {
            out.writeByte(99);
            return;
        } else if (refMap.containsKey(o)) {
            out.writeByte(101);
            out.writeShort((Integer)refMap.get(o));
            return;
        } else if (o instanceof JBCMethodCall) {
            JBCMethodCall call = (JBCMethodCall)((Object)o);
            if (call.getMethodId() <= -1) throw new IllegalArgumentException("MethodCall does not have a valid method id.  Was this method call created with MethodCallFactory?");
            out.writeByte(1);
            this.marshallMethodCall(call, out, refMap);
            return;
        } else if (o instanceof Fqn) {
            int refId = this.createReference(o, refMap);
            out.writeByte(2);
            out.writeShort(refId);
            this.marshallFqn((Fqn)o, out, refMap);
            return;
        } else if (o instanceof GlobalTransaction) {
            int refId = this.createReference(o, refMap);
            out.writeByte(3);
            out.writeShort(refId);
            this.marshallGlobalTransaction((GlobalTransaction)o, out, refMap);
            return;
        } else if (o instanceof IpAddress) {
            out.writeByte(4);
            this.marshallIpAddress((IpAddress)o, out);
            return;
        } else if (o instanceof List) {
            out.writeByte(5);
            this.marshallList((List)o, out, refMap);
            return;
        } else if (o instanceof Boolean) {
            out.writeByte(8);
            out.writeBoolean((Boolean)o);
            return;
        } else if (o instanceof Integer) {
            out.writeByte(6);
            out.writeInt((Integer)o);
            return;
        } else if (o instanceof Long) {
            out.writeByte(7);
            out.writeLong((Long)o);
            return;
        } else if (o instanceof String) {
            int refId = this.createReference(o, refMap);
            out.writeByte(9);
            out.writeShort(refId);
            out.writeUTF((String)o);
            return;
        } else {
            if (!(o instanceof Serializable)) throw new Exception("Don't know how to marshall object of type " + o.getClass());
            int refId = this.createReference(o, refMap);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Warning: using object serialization for " + o.getClass()));
            }
            out.writeByte(100);
            out.writeShort(refId);
            out.writeObject(o);
        }
    }

    private int createReference(Object o, Map refMap) {
        int reference = refMap.size();
        refMap.put(o, new Integer(reference));
        return reference;
    }

    private void marshallMethodCall(JBCMethodCall methodCall, ObjectOutputStream out, Map refMap) throws Exception {
        out.writeShort(methodCall.getMethodId());
        Object[] args = methodCall.getArgs();
        int numArgs = args == null ? 0 : args.length;
        out.writeByte(numArgs);
        for (int i = 0; i < numArgs; ++i) {
            this.marshallObject(args[i], out, refMap);
        }
    }

    private void marshallGlobalTransaction(GlobalTransaction globalTransaction, ObjectOutputStream out, Map refMap) throws Exception {
        out.writeLong(globalTransaction.getId());
        this.marshallObject(globalTransaction.getAddress(), out, refMap);
    }

    private void marshallFqn(Fqn fqn, ObjectOutputStream out, Map refMap) throws Exception {
        boolean isRoot = fqn.isRoot();
        out.writeBoolean(isRoot);
        if (!isRoot) {
            out.writeShort(fqn.size());
            for (int i = 0; i < fqn.size(); ++i) {
                this.marshallObject(fqn.get(i), out, refMap);
            }
        }
    }

    private void marshallIpAddress(IpAddress ipAddress, ObjectOutputStream out) throws Exception {
        ipAddress.writeExternal((ObjectOutput)out);
    }

    private void marshallList(List l, ObjectOutputStream out, Map refMap) throws Exception {
        out.writeInt(l.size());
        Iterator i = l.iterator();
        while (i.hasNext()) {
            this.marshallObject(i.next(), out, refMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unmarshallObject(ObjectInputStream in, ClassLoader loader, Map refMap) throws Exception {
        if (loader == null) {
            return this.unmarshallObject(in, refMap);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader old = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(loader);
            Object object = this.unmarshallObject(in, refMap);
            return object;
        }
        finally {
            currentThread.setContextClassLoader(old);
        }
    }

    private Object unmarshallObject(ObjectInputStream in, Map refMap) throws Exception {
        byte magicNumber = in.readByte();
        switch (magicNumber) {
            case 99: {
                return null;
            }
            case 101: {
                Integer reference = new Integer(in.readShort());
                if (!refMap.containsKey(reference)) {
                    throw new IOException("Unable to locate object reference " + reference + " in byte stream!");
                }
                return refMap.get(reference);
            }
            case 100: {
                Integer reference = new Integer(in.readShort());
                Object retVal = in.readObject();
                refMap.put(reference, retVal);
                return retVal;
            }
            case 1: {
                MethodCall retVal = this.unmarshallMethodCall(in, refMap);
                return retVal;
            }
            case 2: {
                Integer reference = new Integer(in.readShort());
                Fqn retVal = this.unmarshallFqn(in, refMap);
                refMap.put(reference, retVal);
                return retVal;
            }
            case 3: {
                Integer reference = new Integer(in.readShort());
                GlobalTransaction retVal = this.unmarshallGlobalTransaction(in, refMap);
                refMap.put(reference, retVal);
                return retVal;
            }
            case 4: {
                IpAddress retVal = this.unmarshallIpAddress(in);
                return retVal;
            }
            case 5: {
                return this.unmarshallList(in, refMap);
            }
            case 8: {
                return in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return new Integer(in.readInt());
            }
            case 7: {
                Long retVal = new Long(in.readLong());
                return retVal;
            }
            case 9: {
                Integer reference = new Integer(in.readShort());
                String retVal = in.readUTF();
                refMap.put(reference, retVal);
                return retVal;
            }
        }
        if (log.isErrorEnabled()) {
            log.error((Object)("Unknown Magic Number " + magicNumber));
        }
        throw new Exception("Unknown magic number " + magicNumber);
    }

    private MethodCall unmarshallMethodCall(ObjectInputStream in, Map refMap) throws Exception {
        short methodId = in.readShort();
        int numArgs = in.readByte();
        Object[] args = null;
        if (numArgs > 0) {
            args = new Object[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                args[i] = this.unmarshallObject(in, refMap);
            }
        }
        return MethodCallFactory.create(MethodDeclarations.lookupMethod(methodId), args);
    }

    private GlobalTransaction unmarshallGlobalTransaction(ObjectInputStream in, Map refMap) throws Exception {
        GlobalTransaction gtx = new GlobalTransaction();
        long id = in.readLong();
        Object address = this.unmarshallObject(in, refMap);
        gtx.setId(id);
        gtx.setAddress((Address)address);
        return gtx;
    }

    private Fqn unmarshallFqn(ObjectInputStream in, Map refMap) throws Exception {
        Fqn fqn;
        boolean isRoot = in.readBoolean();
        if (!isRoot) {
            int numElements = in.readShort();
            ArrayList<Object> elements = new ArrayList<Object>(numElements);
            for (int i = 0; i < numElements; ++i) {
                elements.add(this.unmarshallObject(in, refMap));
            }
            fqn = new Fqn(elements);
        } else {
            fqn = Fqn.ROOT;
        }
        return fqn;
    }

    private IpAddress unmarshallIpAddress(ObjectInputStream in) throws Exception {
        IpAddress ipAddress = new IpAddress();
        ipAddress.readExternal((ObjectInput)in);
        return ipAddress;
    }

    private List unmarshallList(ObjectInputStream in, Map refMap) throws Exception {
        int listSize = in.readInt();
        ArrayList<Object> list = new ArrayList<Object>(listSize);
        for (int i = 0; i < listSize; ++i) {
            list.add(this.unmarshallObject(in, refMap));
        }
        return list;
    }

    class InactiveRegionException
    extends CacheException {
        public InactiveRegionException() {
        }

        public InactiveRegionException(String msg) {
            super(msg);
        }

        public InactiveRegionException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

