/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.preview.adapter.AbstractPreviewer;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.api.PreviewException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImagePreviewer
extends AbstractPreviewer
implements MimeTypePreviewer {
    @Override
    public List<Blob> getPreview(Blob blob, DocumentModel dm) throws PreviewException {
        ArrayList<Blob> blobResults = new ArrayList<Blob>();
        try {
            StringBuffer htmlPage = new StringBuffer();
            htmlPage.append("<html><head><title>");
            htmlPage.append(this.getPreviewTitle(dm));
            htmlPage.append("</title></head><body>");
            this.appendPreviewSettings(htmlPage);
            htmlPage.append("<img src=\"image\">");
            StringBlob mainBlob = new StringBlob(htmlPage.toString());
            mainBlob.setFilename("index.html");
            mainBlob.setMimeType("text/html");
            blob.setFilename("image");
            blobResults.add((Blob)mainBlob);
            blobResults.add(blob);
        }
        catch (ClientException e) {
            throw new PreviewException("Unable to get document property", e);
        }
        return blobResults;
    }

    protected void appendPreviewSettings(StringBuffer sb) {
        sb.append("<script type=\"text/javascript\">");
        sb.append("var previewSettings = { ");
        sb.append("imageOnly: true");
        sb.append("}");
        sb.append("</script>");
    }
}

