/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter.base;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.api.ConverterNotAvailable;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.adapter.PreviewAdapterManager;
import org.nuxeo.ecm.platform.preview.adapter.base.AbstractHtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterBasedHtmlPreviewAdapter
extends AbstractHtmlPreviewAdapter {
    private static final Log log = LogFactory.getLog(ConverterBasedHtmlPreviewAdapter.class);
    protected static PreviewAdapterManager previewManager;
    protected static ConversionService cs;
    protected String defaultFieldXPath;

    public static ConversionService getConversionService() throws Exception {
        if (cs == null) {
            cs = (ConversionService)Framework.getService(ConversionService.class);
        }
        return cs;
    }

    @Override
    protected PreviewAdapterManager getPreviewManager() throws PreviewException {
        if (previewManager == null) {
            try {
                previewManager = (PreviewAdapterManager)Framework.getService(PreviewAdapterManager.class);
            }
            catch (Exception e) {
                throw new PreviewException(e);
            }
        }
        return previewManager;
    }

    protected static String getMimeType(Blob blob) {
        if (blob == null) {
            return null;
        }
        String srcMT = blob.getMimeType();
        if (srcMT == null || srcMT.startsWith("application/octet-stream")) {
            try {
                MimetypeRegistry mtr = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
                srcMT = mtr.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), blob, "application/octet-stream");
                log.debug((Object)("mime type service returned " + srcMT));
            }
            catch (Exception e) {
                log.warn((Object)"error while calling Mimetype service", (Throwable)e);
            }
        }
        return srcMT;
    }

    protected String getDefaultPreviewFieldXPath() {
        return this.defaultFieldXPath;
    }

    public void setDefaultPreviewFieldXPath(String xPath) {
        this.defaultFieldXPath = xPath;
    }

    @Override
    public List<Blob> getPreviewBlobs() throws PreviewException {
        return this.getPreviewBlobs(this.getDefaultPreviewFieldXPath());
    }

    @Override
    public List<Blob> getPreviewBlobs(String xpath) throws PreviewException {
        Blob blob2Preview = null;
        Object blobHolder2preview = null;
        blobHolder2preview = xpath == null || "default".equals(xpath) ? (BlobHolder)this.adaptedDoc.getAdapter(BlobHolder.class) : new DocumentBlobHolder(this.adaptedDoc, xpath);
        try {
            blob2Preview = blobHolder2preview.getBlob();
        }
        catch (ClientException e) {
            throw new PreviewException("Error while getting blob", e);
        }
        if (blob2Preview == null) {
            throw new PreviewException("can not preview a document without blob");
        }
        ArrayList<Blob> blobResults = new ArrayList();
        String srcMT = ConverterBasedHtmlPreviewAdapter.getMimeType(blob2Preview);
        log.debug((Object)("Source type for HTML preview =" + srcMT));
        MimeTypePreviewer mtPreviewer = this.getPreviewManager().getPreviewer(srcMT);
        if (mtPreviewer != null) {
            blobResults = mtPreviewer.getPreview(blob2Preview, this.adaptedDoc);
            return blobResults;
        }
        String converterName = null;
        try {
            converterName = ConverterBasedHtmlPreviewAdapter.getConversionService().getConverterName(srcMT, "text/html");
        }
        catch (Exception e1) {
            throw new PreviewException("Unable to get converter", e1);
        }
        if (converterName == null) {
            log.debug((Object)"No dedicated converter found, using generic");
            converterName = "any2html";
        }
        try {
            BlobHolder result = ConverterBasedHtmlPreviewAdapter.getConversionService().convert(converterName, blobHolder2preview, null);
            this.setMimeType(result);
            return result.getBlobs();
        }
        catch (ConverterNotAvailable e) {
            throw new PreviewException(e.getMessage(), e);
        }
        catch (ConversionException e) {
            throw new PreviewException("Error during conversion", e);
        }
        catch (Exception e) {
            throw new PreviewException("Unexpected Error", e);
        }
    }

    protected void setMimeType(BlobHolder result) throws ClientException {
        Blob blob;
        boolean foundHtmlBlob = false;
        for (Blob blob2 : result.getBlobs()) {
            String filename = blob2.getFilename();
            if (filename == null || !filename.endsWith("html")) continue;
            blob2.setMimeType("text/html");
            foundHtmlBlob = true;
        }
        if (!foundHtmlBlob && (blob = result.getBlob()).getMimeType() == null) {
            blob.setMimeType("text/html");
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean cachable() {
        return true;
    }
}

