/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.launcher;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class Main {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("You must specify a main class to invoke as the first parameter to that program.");
            System.exit(2);
        }
        String path = args[0];
        String method = "main";
        int p = path.lastIndexOf(58);
        if (p > -1) {
            method = path.substring(p + 1);
            path = path.substring(0, p);
        }
        p = path.lastIndexOf(47);
        String mainClassName = null;
        if (p > -1) {
            mainClassName = path.substring(p + 1);
            path = path.substring(0, p);
        }
        try {
            File file = new File(path).getCanonicalFile();
            URL[] urls = new URL[1];
            if (file.exists()) {
                urls[0] = file.toURI().toURL();
            } else {
                System.err.println("Could not find main class: " + args[0] + ". Make sure you have this class on the boot class path");
                System.exit(3);
            }
            URLClassLoader classLoader = new URLClassLoader(urls, Main.class.getClassLoader());
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> mainClass = classLoader.loadClass(mainClassName);
            Method m = mainClass.getMethod(method, String[].class);
            if (args.length > 1) {
                String[] tmp = new String[args.length - 1];
                System.arraycopy(args, 1, tmp, 0, tmp.length);
                args = tmp;
            } else {
                args = new String[]{};
            }
            m.invoke(null, new Object[]{args});
        }
        catch (IOException e) {
            System.err.println("Could not find main class: " + args[0] + ". Make sure you have this class on the boot class path");
            e.printStackTrace();
            System.exit(3);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not load main class: " + args[0] + ". Make sure you have this class on the boot class path");
            e.printStackTrace();
            System.exit(4);
        }
        catch (NoSuchMethodException e) {
            System.err.println("Could not find main class method: " + mainClassName + "." + method + "(String[] args)");
            e.printStackTrace();
            System.exit(5);
        }
        catch (SecurityException e) {
            System.err.println("Failed to access the main class method: " + mainClassName + "." + method + "(String[] args)");
            e.printStackTrace();
            System.exit(5);
        }
        catch (IllegalAccessException e) {
            System.err.println("Failed to invoke method: " + mainClassName + "." + method + "(String[] args)");
            e.printStackTrace();
            System.exit(6);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Failed to invoke method: " + mainClassName + "." + method + "(String[] args)");
            e.printStackTrace();
            System.exit(6);
        }
        catch (InvocationTargetException e) {
            System.err.println("Failed to invoke method: " + mainClassName + "." + method + "(String[] args)");
            e.printStackTrace();
            System.exit(6);
        }
    }
}

