/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelComparator;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryCache;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFieldMapper;
import org.nuxeo.ecm.directory.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDirectory
implements Directory {
    protected DirectoryFieldMapper fieldMapper;
    protected final Map<String, Reference> references = new HashMap<String, Reference>();
    protected final DirectoryCache cache = new DirectoryCache();

    public void invalidateCaches() throws DirectoryException {
        this.cache.invalidateAll();
        for (Reference ref : this.references.values()) {
            Directory targetDir = ref.getTargetDirectory();
            if (targetDir == null) continue;
            targetDir.getCache().invalidateAll();
        }
    }

    public DirectoryFieldMapper getFieldMapper() {
        if (this.fieldMapper == null) {
            this.fieldMapper = new DirectoryFieldMapper();
        }
        return this.fieldMapper;
    }

    public Reference getReference(String referenceFieldName) {
        return this.references.get(referenceFieldName);
    }

    public boolean isReference(String referenceFieldName) {
        return this.references.containsKey(referenceFieldName);
    }

    public void addReference(Reference reference) throws ClientException {
        reference.setSourceDirectoryName(this.getName());
        this.references.put(reference.getFieldName(), reference);
    }

    public void addReferences(Reference[] references) throws ClientException {
        for (Reference reference : references) {
            this.addReference(reference);
        }
    }

    public Collection<Reference> getReferences() {
        return this.references.values();
    }

    public void orderEntries(List<DocumentModel> entries, Map<String, String> orderBy) throws DirectoryException {
        Collections.sort(entries, new DocumentModelComparator(this.getSchema(), orderBy));
    }

    public DirectoryCache getCache() {
        return this.cache;
    }
}

