/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.io;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.io.api.IOResources;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IORelationResources
implements IOResources {
    private static final long serialVersionUID = 3613545698356485035L;
    final Map<String, String> namespaces;
    final Map<DocumentRef, Set<Resource>> documentResources;
    final List<Statement> statements;

    public IORelationResources(Map<String, String> namespaces, Map<DocumentRef, Set<Resource>> documentResources, List<Statement> statements) {
        this.namespaces = namespaces;
        this.documentResources = documentResources;
        this.statements = statements;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public Map<DocumentRef, Set<Resource>> getResourcesMap() {
        return Collections.unmodifiableMap(this.documentResources);
    }

    public Set<Resource> getDocumentResources(DocumentRef docRef) {
        Set<Resource> res = this.documentResources.get(docRef);
        if (res != null) {
            return Collections.unmodifiableSet(res);
        }
        return null;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }
}

