/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.api.AnnotationManager;
import org.nuxeo.ecm.platform.annotations.api.AnnotationsService;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.runtime.api.Framework;

public class AnnotationServiceFacade {
    private static final String TRANSIENT_GRAPH_TYPE = "jena";
    private final AnnotationsService service;
    private final AnnotationManager manager = new AnnotationManager();

    public AnnotationServiceFacade() throws AnnotationException {
        try {
            this.service = (AnnotationsService)Framework.getService(AnnotationsService.class);
        }
        catch (Exception e) {
            throw new AnnotationException((Throwable)e);
        }
    }

    public void query(String uri, OutputStream outputStream, NuxeoPrincipal name) throws AnnotationException {
        Graph graph;
        List annotations;
        try {
            annotations = this.service.queryAnnotations(new URI(uri), null, name);
        }
        catch (URISyntaxException e) {
            throw new AnnotationException((Throwable)e);
        }
        ArrayList statements = new ArrayList();
        for (Annotation annotation : annotations) {
            statements.addAll(annotation.getStatements());
        }
        try {
            RelationManager service = (RelationManager)Framework.getService(RelationManager.class);
            graph = service.getTransientGraph(TRANSIENT_GRAPH_TYPE);
        }
        catch (Exception e) {
            throw new AnnotationException((Throwable)e);
        }
        graph.add(statements);
        try {
            outputStream.write("<?xml version='1.0'?>\n".getBytes());
        }
        catch (IOException e) {
            throw new AnnotationException((Throwable)e);
        }
        graph.write(outputStream, null, null);
    }

    public void getAnnotation(String annId, NuxeoPrincipal name, OutputStream os, String baseUrl) throws AnnotationException {
        Annotation annotation = this.service.getAnnotation(annId, name, baseUrl);
        this.manager.writeAnnotation(os, annotation);
    }

    public void updateAnnotation(InputStream is, NuxeoPrincipal name, OutputStream outputStream, String baseUrl) throws AnnotationException {
        Annotation annotation = this.manager.getAnnotation(is);
        annotation = this.service.updateAnnotation(annotation, name, baseUrl);
        this.manager.writeAnnotation(outputStream, annotation);
    }

    public String getAnnotationBody(String id, NuxeoPrincipal name, String baseUrl) throws AnnotationException {
        Annotation annotation = this.service.getAnnotation(id, name, baseUrl);
        return annotation.getBodyAsText();
    }

    public void createAnnotation(InputStream inputStream, NuxeoPrincipal name, OutputStream outputStream, String baseUrl) throws AnnotationException {
        Annotation annotation = this.manager.getAnnotation(inputStream);
        annotation = this.service.addAnnotation(annotation, name, baseUrl);
        this.manager.writeAnnotation(outputStream, annotation);
    }

    public void delete(String annId, NuxeoPrincipal name, String baseUrl) throws AnnotationException {
        Annotation annotation = this.service.getAnnotation(annId, name, baseUrl);
        this.service.deleteAnnotation(annotation, name);
    }

    public void deleteFor(String uri, String annId, NuxeoPrincipal name, String baseUrl) throws AnnotationException {
        try {
            Annotation annotation = this.service.getAnnotation(annId, name, baseUrl);
            this.service.deleteAnnotationFor(new URI(uri), annotation, name);
        }
        catch (URISyntaxException e) {
            throw new AnnotationException((Throwable)e);
        }
    }
}

