/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.persistence.Filter;
import org.jboss.seam.persistence.HibernatePersistenceProvider;
import org.jboss.seam.persistence.PersistenceContextManager;
import org.jboss.seam.persistence.PersistenceContexts;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.transaction.UserTransaction;
import org.jboss.seam.util.Naming;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.CONVERSATION)
@BypassInterceptors
public class ManagedHibernateSession
implements Serializable,
HttpSessionActivationListener,
Mutable,
PersistenceContextManager,
Synchronization {
    private static final long serialVersionUID = 3130309555079841107L;
    private static final LogProvider log = Logging.getLogProvider(ManagedHibernateSession.class);
    private Session session;
    private String sessionFactoryJndiName;
    private String componentName;
    private Expressions.ValueExpression<SessionFactory> sessionFactory;
    private List<Filter> filters = new ArrayList<Filter>(0);
    private transient boolean synchronizationRegistered;
    private transient boolean destroyed;

    @Override
    public boolean clearDirty() {
        return true;
    }

    @Create
    public void create(Component component) {
        this.componentName = component.getName();
        if (this.sessionFactoryJndiName == null) {
            this.sessionFactoryJndiName = "java:/" + this.componentName;
        }
        PersistenceContexts.instance().touch(this.componentName);
    }

    private void initSession() throws Exception {
        this.session = this.getSessionFactoryFromJndiOrValueBinding().openSession();
        this.setSessionFlushMode(PersistenceContexts.instance().getFlushMode());
        this.session = HibernatePersistenceProvider.proxySession(this.session);
        for (Filter f : this.filters) {
            if (!f.isFilterEnabled()) continue;
            this.enableFilter(f);
        }
        if (log.isDebugEnabled()) {
            log.debug("created seam managed session for session factory: " + this.sessionFactoryJndiName);
        }
    }

    private void enableFilter(Filter f) {
        org.hibernate.Filter filter = this.session.enableFilter(f.getName());
        for (Map.Entry<String, Expressions.ValueExpression> me : f.getParameters().entrySet()) {
            filter.setParameter(me.getKey(), me.getValue().getValue());
        }
        filter.validate();
    }

    @Unwrap
    public Session getSession() throws Exception {
        if (this.session == null) {
            this.initSession();
        }
        if (!this.synchronizationRegistered && !Lifecycle.isDestroying()) {
            this.joinTransaction();
        }
        return this.session;
    }

    private void joinTransaction() throws SystemException {
        UserTransaction transaction = Transaction.instance();
        if (transaction.isActive()) {
            this.session.isOpen();
            try {
                transaction.registerSynchronization(this);
            }
            catch (Exception e) {
                this.session.getTransaction().registerSynchronization((Synchronization)this);
            }
            this.synchronizationRegistered = true;
        }
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        if (this.synchronizationRegistered) {
            throw new IllegalStateException("cannot passivate persistence context with active transaction");
        }
        if (this.session != null && !this.session.isDirty()) {
            this.session.close();
            this.session = null;
        }
    }

    public void sessionDidActivate(HttpSessionEvent event) {
    }

    @Destroy
    public void destroy() {
        this.destroyed = true;
        if (!this.synchronizationRegistered) {
            this.close();
        }
        PersistenceContexts.instance().untouch(this.componentName);
    }

    public void afterCompletion(int status) {
        this.synchronizationRegistered = false;
        if (this.destroyed) {
            this.close();
        }
    }

    public void beforeCompletion() {
    }

    private void close() {
        boolean transactionActive = false;
        try {
            transactionActive = Transaction.instance().isActive();
        }
        catch (SystemException se) {
            log.debug("could not get transaction status while destroying persistence context");
        }
        if (transactionActive) {
            throw new IllegalStateException("attempting to destroy the persistence context while an active transaction exists (try installing <transaction:ejb-transaction/>)");
        }
        if (log.isDebugEnabled()) {
            log.debug("destroying seam managed session for session factory: " + this.sessionFactoryJndiName);
        }
        if (this.session != null) {
            this.session.close();
        }
    }

    private SessionFactory getSessionFactoryFromJndiOrValueBinding() {
        SessionFactory result = null;
        if (this.sessionFactory != null) {
            result = this.sessionFactory.getValue();
        }
        if (result == null) {
            try {
                result = (SessionFactory)Naming.getInitialContext().lookup(this.sessionFactoryJndiName);
            }
            catch (NamingException ne) {
                throw new IllegalArgumentException("SessionFactory not found in JNDI: " + this.sessionFactoryJndiName, ne);
            }
        }
        return result;
    }

    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public void changeFlushMode(FlushModeType flushMode) {
        if (this.session != null) {
            this.setSessionFlushMode(flushMode);
        }
    }

    protected void setSessionFlushMode(FlushModeType flushMode) {
        switch (flushMode) {
            case AUTO: {
                this.session.setFlushMode(FlushMode.AUTO);
                break;
            }
            case MANUAL: {
                this.session.setFlushMode(FlushMode.MANUAL);
                break;
            }
            case COMMIT: {
                this.session.setFlushMode(FlushMode.COMMIT);
            }
        }
    }

    public String getSessionFactoryJndiName() {
        return this.sessionFactoryJndiName;
    }

    public void setSessionFactoryJndiName(String sessionFactoryName) {
        this.sessionFactoryJndiName = sessionFactoryName;
    }

    public void setSessionFactory(Expressions.ValueExpression<SessionFactory> sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Expressions.ValueExpression<SessionFactory> getSessionFactory() {
        return this.sessionFactory;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public String toString() {
        return "ManagedHibernateSession(" + this.sessionFactoryJndiName + ")";
    }
}

