/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.web;

import java.util.Date;
import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.Subject;
import org.nuxeo.ecm.platform.relations.api.impl.RelationDate;
import org.nuxeo.ecm.platform.relations.api.util.RelationConstants;
import org.nuxeo.ecm.platform.relations.web.NodeInfo;
import org.nuxeo.ecm.platform.relations.web.NodeInfoImpl;
import org.nuxeo.ecm.platform.relations.web.StatementInfo;

public class StatementInfoImpl
implements StatementInfo {
    private static final long serialVersionUID = 8474035719439311510L;
    private final Statement statement;
    private NodeInfo subjectRepresentation;
    private NodeInfo predicateRepresentation;
    private NodeInfo objectRepresentation;
    private boolean incoming = false;
    private boolean outgoing = false;

    public StatementInfoImpl() {
        this(null);
    }

    public StatementInfoImpl(Statement statement) {
        this.statement = statement;
    }

    public StatementInfoImpl(Statement statement, NodeInfo subjectRepresentation, NodeInfo predicateRepresentation, NodeInfo objectRepresentation) {
        this.statement = statement;
        this.subjectRepresentation = subjectRepresentation;
        this.predicateRepresentation = predicateRepresentation;
        this.objectRepresentation = objectRepresentation;
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public boolean isOutgoing() {
        return this.outgoing;
    }

    public void setIncoming(boolean incoming) {
        this.incoming = incoming;
    }

    public void setOutgoing(boolean outgoing) {
        this.outgoing = outgoing;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public Subject getSubject() {
        return this.statement.getSubject();
    }

    public NodeInfo getSubjectInfo() {
        if (this.subjectRepresentation == null) {
            return new NodeInfoImpl((Node)this.getSubject());
        }
        return this.subjectRepresentation;
    }

    public Resource getPredicate() {
        return this.statement.getPredicate();
    }

    public NodeInfo getPredicateInfo() {
        if (this.predicateRepresentation == null) {
            return new NodeInfoImpl((Node)this.getPredicate());
        }
        return this.predicateRepresentation;
    }

    public Node getObject() {
        return this.statement.getObject();
    }

    public NodeInfo getObjectInfo() {
        if (this.objectRepresentation == null) {
            return new NodeInfoImpl(this.getObject());
        }
        return this.objectRepresentation;
    }

    public String getComment() {
        String comment = null;
        Node node = this.statement.getProperty(RelationConstants.COMMENT);
        if (node != null && node.isLiteral()) {
            comment = ((Literal)node).getValue();
        }
        return comment;
    }

    public Date getCreationDate() {
        Date date = null;
        Node dateNode = this.statement.getProperty(RelationConstants.CREATION_DATE);
        if (dateNode != null && dateNode.isLiteral()) {
            date = RelationDate.getDate((Literal)((Literal)dateNode));
        }
        return date;
    }

    public Date getModificationDate() {
        Date date = null;
        Node dateNode = this.statement.getProperty(RelationConstants.MODIFICATION_DATE);
        if (dateNode != null && dateNode.isLiteral()) {
            date = RelationDate.getDate((Literal)((Literal)dateNode));
        }
        return date;
    }

    public String getAuthor() {
        String source = null;
        Node node = this.statement.getProperty(RelationConstants.AUTHOR);
        if (node != null && node.isLiteral()) {
            source = ((Literal)node).getValue();
        }
        return source;
    }
}

