/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.rules.PublishingValidatorException;
import org.nuxeo.ecm.platform.publisher.rules.ValidatorsRule;
import org.nuxeo.ecm.platform.versioning.api.VersioningActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasePublishedDocumentFactory
implements PublishedDocumentFactory {
    protected CoreSession coreSession;
    protected Map<String, String> parameters;
    protected PublicationTree publicationTree;
    protected ValidatorsRule validatorsRule;
    public static final String ENABLE_SNAPSHOT = "enableSnapshot";
    public static final String TARGET_PUBLISHED_DOCUMENT_STATE = "targetPublishedDocumentState";

    @Override
    public void init(CoreSession coreSession, ValidatorsRule validatorsRule, Map<String, String> parameters) throws ClientException {
        this.coreSession = coreSession;
        this.parameters = parameters;
        this.validatorsRule = validatorsRule;
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
    }

    @Override
    public void init(CoreSession coreSession, Map<String, String> parameters) throws ClientException {
        this.init(coreSession, null, parameters);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    protected String getParameter(String name) {
        return this.parameters.get(name);
    }

    protected boolean isSnapshotingEnabled() {
        String snap = this.getParameter(ENABLE_SNAPSHOT);
        if (snap == null) {
            return false;
        }
        return snap.equalsIgnoreCase("true");
    }

    protected String getTargetPublishedDocumentState() {
        return this.getParameter(TARGET_PUBLISHED_DOCUMENT_STATE);
    }

    @Override
    public PublishedDocument publishDocument(DocumentModel doc, PublicationNode targetNode) throws ClientException {
        return this.publishDocument(doc, targetNode, null);
    }

    protected boolean needToVersionDocument(DocumentModel doc) {
        return !doc.isVersion() && doc.isVersionable();
    }

    @Override
    public DocumentModel snapshotDocumentBeforePublish(DocumentModel doc) throws ClientException {
        if (this.isSnapshotingEnabled() && this.needToVersionDocument(doc)) {
            doc.putContextData(ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE", (Serializable)Boolean.valueOf(true));
            doc.putContextData(ScopeType.REQUEST, "VersioningOption", (Serializable)VersioningActions.ACTION_INCREMENT_MINOR);
            DocumentModel doc2 = this.coreSession.saveDocument(doc);
            this.coreSession.save();
            List versions = this.coreSession.getVersions(doc.getRef());
            return (DocumentModel)versions.get(versions.size() - 1);
        }
        return doc;
    }

    @Override
    public String[] getValidatorsFor(DocumentModel dm) throws PublishingValidatorException {
        return this.validatorsRule.computesValidatorsFor(dm);
    }

    @Override
    public ValidatorsRule getValidatorsRule() throws PublishingValidatorException {
        return this.validatorsRule;
    }

    @Override
    public void validatorPublishDocument(PublishedDocument publishedDocument, String comment) throws ClientException {
    }

    @Override
    public void validatorRejectPublication(PublishedDocument publishedDocument, String comment) throws ClientException {
    }

    @Override
    public boolean canManagePublishing(PublishedDocument publishedDocument) throws ClientException {
        return false;
    }

    @Override
    public boolean hasValidationTask(PublishedDocument publishedDocument) throws ClientException {
        return false;
    }
}

