/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.helper;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.schema.TypeService;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionsFinder;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootSectionsFinderHelper {
    private static final Log log = LogFactory.getLog(RootSectionsFinderHelper.class);
    private static Set<String> sectionRootTypes;
    private static Set<String> sectionTypes;

    private RootSectionsFinderHelper() {
    }

    public static RootSectionsFinder getRootSectionsFinder(CoreSession coreSession) {
        return new RootSectionsFinder(coreSession, RootSectionsFinderHelper.getSectionRootTypes(), RootSectionsFinderHelper.getSectionTypes());
    }

    private static Set<String> getSectionRootTypes() {
        if (sectionRootTypes == null && (sectionRootTypes = RootSectionsFinderHelper.getTypeNamesForFacet("MasterPublishSpace")) == null) {
            sectionRootTypes = new HashSet<String>();
            sectionRootTypes.add("SectionRoot");
        }
        return sectionRootTypes;
    }

    private static Set<String> getTypeNamesForFacet(String facetName) {
        TypeService schemaService;
        try {
            schemaService = (TypeService)Framework.getRuntime().getComponent(TypeService.NAME);
        }
        catch (Exception e) {
            log.error((Object)"Exception in retrieving publish spaces : ", (Throwable)e);
            return null;
        }
        Set publishRoots = schemaService.getTypeManager().getDocumentTypeNamesForFacet(facetName);
        if (publishRoots == null || publishRoots.isEmpty()) {
            return null;
        }
        return publishRoots;
    }

    private static Set<String> getSectionTypes() {
        if (sectionTypes == null && (sectionTypes = RootSectionsFinderHelper.getTypeNamesForFacet("PublishSpace")) == null) {
            sectionTypes = new HashSet<String>();
            sectionTypes.add("Section");
        }
        return sectionTypes;
    }
}

